/*
 * Decompiled with CFR 0.152.
 */
package ambience.scheduler.forecast;

import ambience.arch.Arch$;
import ambience.module.UserDB;
import ambience.scheduler.CalendarModel;
import ambience.scheduler.Collections$;
import ambience.scheduler.Forecast;
import ambience.scheduler.Forecast$;
import ambience.scheduler.ForecastRule;
import ambience.scheduler.Model;
import ambience.scheduler.SchedulerUtil$;
import ambience.scheduler.calendar.CalendarManager$;
import ambience.scheduler.calendar.CalendarState;
import ambience.scheduler.calendar.CalendarTester$;
import ambience.scheduler.forecast.Forecaster$;
import ambience.scheduler.forecast.Forecaster$CalendarCheck$;
import ambience.scheduler.forecast.Forecaster$Range$;
import ambience.scheduler.trigger.TriggerIO$;
import ambience.scheduler.util.CronExp;
import com.elixirtech.arch.Clock;
import com.elixirtech.codex.CodexFilter;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import monix.eval.Task;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;

public class Forecaster {
    private final LocalDate today = LocalDateTime.now().toLocalDate();
    private final ZonedDateTime start = ZonedDateTime.of(this.today().atStartOfDay(), ZoneId.systemDefault()).minusSeconds(1L);
    private final long startMs = this.start().plusSeconds(1L).toInstant().toEpochMilli();
    private final ZonedDateTime end = this.start().plusDays(1L);
    private final List[] array = (List[])Array$.MODULE$.fill(1440, Forecaster::$init$$$anonfun$1, ClassTag$.MODULE$.apply(List.class));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(Forecaster$.class.getDeclaredField("rules$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(Forecaster$.class.getDeclaredField("clock$lzy1"));

    public static long OneMinuteMs() {
        return Forecaster$.MODULE$.OneMinuteMs();
    }

    public static Task<Forecast> apply(UserDB.User user) {
        return Forecaster$.MODULE$.apply(user);
    }

    public static Clock clock() {
        return Forecaster$.MODULE$.clock();
    }

    public static List<ForecastRule> rules() {
        return Forecaster$.MODULE$.rules();
    }

    public static String timeZone() {
        return Forecaster$.MODULE$.timeZone();
    }

    public LocalDate today() {
        return this.today;
    }

    public ZonedDateTime start() {
        return this.start;
    }

    public long startMs() {
        return this.startMs;
    }

    public ZonedDateTime end() {
        return this.end;
    }

    public List<String>[] array() {
        return this.array;
    }

    public Task<Forecast> resultT() {
        return CalendarManager$.MODULE$.loadState().flatMap((Function1 & Serializable)cstate -> this.getEnabledTriggersO().map((Function1)(JProcedure1 & Serializable)t -> this.buildArray((CalendarState)cstate, (Model.Trigger)t)).completedL().map((Function1 & Serializable)_$1 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.array());
            return Forecast$.MODULE$.apply(Forecaster$.MODULE$.timeZone(), Forecaster$.MODULE$.rules(), Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$2 -> (List)_$2.sorted((Ordering)Ordering.String$.MODULE$), ClassTag$.MODULE$.apply(List.class))).toList());
        }));
    }

    public void buildArray(CalendarState cstate, Model.Trigger t) {
        ZoneId zoneId = (ZoneId)Arch$.MODULE$.opts(t.constraints().timeZone()).map((Function1 & Serializable)x$0 -> ZoneId.of(x$0)).getOrElse(Forecaster::$anonfun$2);
        String cronString = SchedulerUtil$.MODULE$.cronExpression(t.info().cron());
        CalendarCheck cc = this.calCheck(cstate, t);
        SchedulerUtil$.MODULE$.buildCronExpression(cronString, zoneId).foreach((Function1)(JProcedure1 & Serializable)cronExp -> this.run(t.name(), cc, (CronExp)cronExp, this.start()));
    }

    public void bumpValue(ZonedDateTime zts, String triggerName) {
        int idx = zts.getHour() * 60 + zts.getMinute();
        this.array()[idx] = this.array()[idx].$colon$colon((Object)triggerName);
    }

    public final void run(String triggerName, CalendarCheck cc, CronExp cronExp, ZonedDateTime zts) {
        while (zts.isBefore(this.end())) {
            Option<ZonedDateTime> option = cronExp.getTimeAfter(zts);
            if (option instanceof Some) {
                ZonedDateTime next = (ZonedDateTime)((Some)option).value();
                if (next.isBefore(this.end())) {
                    if (this.isTimeAllowed(cc, next)) {
                        this.bumpValue(next, triggerName);
                    }
                    zts = next;
                    continue;
                }
                return;
            }
            if (None$.MODULE$.equals(option)) {
                return;
            }
            throw new MatchError(option);
        }
    }

    public CalendarCheck calCheck(CalendarState cstate, Model.Trigger t) {
        List calendarsIn = t.constraints().calendarsInclusive().flatMap((Function1 & Serializable)id -> cstate.get((String)id));
        List calendarsOut = t.constraints().calendarsExclusive().flatMap((Function1 & Serializable)id -> cstate.get((String)id));
        return Forecaster$CalendarCheck$.MODULE$.apply((List<CalendarModel.Calendar>)calendarsIn, (List<CalendarModel.Calendar>)calendarsOut);
    }

    public Observable<Model.Trigger> getEnabledTriggersO() {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Exists$.MODULE$.apply("name"), CodexFilter.Eq$.MODULE$.apply("enabled", (BsonValue)BsonBoolean$.MODULE$.apply(true))}));
        return Observable$.MODULE$.fromTask(Collections$.MODULE$.triggersCltnT()).flatMap((Function1 & Serializable)_$3 -> _$3.findO((CodexFilter)filter)).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(TriggerIO$.MODULE$.decodeTrigger((Document)doc).toOption())));
    }

    public ZonedDateTime constrain(ZonedDateTime startTime, ZonedDateTime d) {
        if (startTime.isAfter(d)) {
            return startTime;
        }
        return d;
    }

    public boolean isTimeAllowed(CalendarCheck cc, ZonedDateTime timestamp) {
        return cc.cin().forall((Function1 & Serializable)calendar -> CalendarTester$.MODULE$.matches((CalendarModel.Calendar)calendar, timestamp)) && cc.cout().forall((Function1 & Serializable)calendar -> !CalendarTester$.MODULE$.matches((CalendarModel.Calendar)calendar, timestamp));
    }

    private static final List $init$$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final ZoneId $anonfun$2() {
        return ZoneId.systemDefault();
    }

    public static final class CalendarCheck
    implements Product,
    Serializable {
        private final List cin;
        private final List cout;

        public static CalendarCheck apply(List<CalendarModel.Calendar> list, List<CalendarModel.Calendar> list2) {
            return Forecaster$CalendarCheck$.MODULE$.apply(list, list2);
        }

        public static CalendarCheck fromProduct(Product product) {
            return Forecaster$CalendarCheck$.MODULE$.fromProduct(product);
        }

        public static CalendarCheck unapply(CalendarCheck calendarCheck) {
            return Forecaster$CalendarCheck$.MODULE$.unapply(calendarCheck);
        }

        public CalendarCheck(List<CalendarModel.Calendar> cin, List<CalendarModel.Calendar> cout) {
            this.cin = cin;
            this.cout = cout;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof CalendarCheck)) return false;
            CalendarCheck calendarCheck = (CalendarCheck)object;
            List<CalendarModel.Calendar> list = this.cin();
            List<CalendarModel.Calendar> list2 = calendarCheck.cin();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<CalendarModel.Calendar> list3 = this.cout();
            List<CalendarModel.Calendar> list4 = calendarCheck.cout();
            if (list3 == null) {
                if (list4 == null) return true;
                return false;
            } else {
                if (!list3.equals(list4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof CalendarCheck;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "CalendarCheck";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "cin";
            }
            if (1 == n2) {
                return "cout";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<CalendarModel.Calendar> cin() {
            return this.cin;
        }

        public List<CalendarModel.Calendar> cout() {
            return this.cout;
        }

        public CalendarCheck copy(List<CalendarModel.Calendar> cin, List<CalendarModel.Calendar> cout) {
            return new CalendarCheck(cin, cout);
        }

        public List<CalendarModel.Calendar> copy$default$1() {
            return this.cin();
        }

        public List<CalendarModel.Calendar> copy$default$2() {
            return this.cout();
        }

        public List<CalendarModel.Calendar> _1() {
            return this.cin();
        }

        public List<CalendarModel.Calendar> _2() {
            return this.cout();
        }
    }

    public static final class Range
    implements Product,
    Serializable {
        private final long start;
        private final long end;

        public static Range apply(long l, long l2) {
            return Forecaster$Range$.MODULE$.apply(l, l2);
        }

        public static Range fromProduct(Product product) {
            return Forecaster$Range$.MODULE$.fromProduct(product);
        }

        public static Range unapply(Range range) {
            return Forecaster$Range$.MODULE$.unapply(range);
        }

        public Range(long start, long end) {
            this.start = start;
            this.end = end;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.start()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.end()));
            return Statics.finalizeHash((int)n, (int)2);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Range)) return false;
            Range range = (Range)object;
            if (this.start() != range.start()) return false;
            if (this.end() != range.end()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Range;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Range";
        }

        public Object productElement(int n) {
            long l;
            int n2 = n;
            if (0 == n2) {
                l = this._1();
            } else if (1 == n2) {
                l = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToLong((long)l);
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "start";
            }
            if (1 == n2) {
                return "end";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }

        public Range copy(long start, long end) {
            return new Range(start, end);
        }

        public long copy$default$1() {
            return this.start();
        }

        public long copy$default$2() {
            return this.end();
        }

        public long _1() {
            return this.start();
        }

        public long _2() {
            return this.end();
        }
    }
}

