/*
 * Decompiled with CFR 0.152.
 */
package ambience.sysinfo;

import ambience.module.LicenceConfig;
import ambience.module.ProjectConfig;
import ambience.queue.JobType;
import ambience.queue.SystemQueueManager;
import ambience.sysinfo.Checksum$;
import ambience.sysinfo.ClusterInfo$;
import ambience.sysinfo.ExtractHostPort;
import ambience.sysinfo.ExtractHostPort$;
import ambience.sysinfo.JarBuild;
import ambience.sysinfo.JarBuild$;
import ambience.sysinfo.JarInfo;
import ambience.sysinfo.JarInfo$;
import ambience.sysinfo.JavaSetting;
import ambience.sysinfo.JavaSetting$;
import ambience.sysinfo.JavaSettings;
import ambience.sysinfo.JavaSettings$;
import ambience.sysinfo.JobEngine;
import ambience.sysinfo.JobEngine$;
import ambience.sysinfo.JsonResponse;
import ambience.sysinfo.JsonResponse$;
import ambience.sysinfo.MongoDBSettings;
import ambience.sysinfo.MongoDBSettings$;
import ambience.sysinfo.SysInfoModule;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.info.JavaPID$;
import com.elixirtech.arch.info.RunInfo;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.mongodb.BsonETL$;
import com.elixirtech.mongodb.MongoDB;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.SingleObservable;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class SystemInfo
implements LoggingHelper2 {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(SystemInfo.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(SystemInfo.class.getDeclaredField("hasMongoDB$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(SystemInfo.class.getDeclaredField("jsonStructure$lzy1"));
    private volatile Object log$lzy1;
    private final SysInfoModule module;
    private final Config config;
    private volatile Object jsonStructure$lzy1;
    private volatile Object hasMongoDB$lzy1;

    public SystemInfo(SysInfoModule module) {
        this.module = module;
        this.config = module.projectConfig().config();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Config config() {
        return this.config;
    }

    public Json jsonStructure() {
        Object object = this.jsonStructure$lzy1;
        if (object instanceof Json) {
            return (Json)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Json)this.jsonStructure$lzyINIT1();
    }

    private Object jsonStructure$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.jsonStructure$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Json json = null;
                    try {
                        JsonResponse jsonResponse = (JsonResponse)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this.buildJsonStructure());
                        json = package.EncoderOps$.MODULE$.asJson$extension((Object)jsonResponse, JsonResponse$.MODULE$.encoder());
                        object2 = json == null ? LazyVals.NullValue$.MODULE$ : json;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.jsonStructure$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return json;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public boolean hasMongoDB() {
        Object object = this.hasMongoDB$lzy1;
        if (object instanceof Boolean) {
            return BoxesRunTime.unboxToBoolean((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToBoolean(null);
        }
        return BoxesRunTime.unboxToBoolean((Object)this.hasMongoDB$lzyINIT1());
    }

    private Object hasMongoDB$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.hasMongoDB$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Boolean bl = null;
                    try {
                        bl = BoxesRunTime.boxToBoolean((boolean)Try$.MODULE$.apply(SystemInfo::hasMongoDB$lzyINIT1$$anonfun$1).isSuccess());
                        object2 = bl == null ? LazyVals.NullValue$.MODULE$ : bl;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.hasMongoDB$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return bl;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public GravityResponse response() {
        return GravityResponse$.MODULE$.json(this.jsonStructure());
    }

    public JsonResponse buildJsonStructure() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File("lib").listFiles()).getOrElse(SystemInfo::$anonfun$1));
        List libFiles = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1 & Serializable)_$1 -> _$1.getName(), (Ordering)Ordering.String$.MODULE$)).toList().filter((Function1 & Serializable)_$2 -> _$2.isFile()).filterNot((Function1 & Serializable)f -> this.ignore((File)f));
        List jarInfos = libFiles.map((Function1 & Serializable)file -> this.logJar((File)file));
        String fingerprint = Checksum$.MODULE$.apply(jarInfos.map((Function1 & Serializable)_$3 -> _$3.checksum()).mkString(""));
        List elxJars = jarInfos.filter((Function1 & Serializable)_$4 -> _$4.name().startsWith("elx-"));
        String elxFingerprint = Checksum$.MODULE$.apply(elxJars.map((Function1 & Serializable)_$5 -> _$5.checksum()).mkString(""));
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)new File("ext").listFiles()).getOrElse(SystemInfo::$anonfun$9));
        List extFiles = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.sortBy$extension(object2, (Function1 & Serializable)_$6 -> _$6.getName(), (Ordering)Ordering.String$.MODULE$)).toList().filter((Function1 & Serializable)_$7 -> _$7.isFile()).filterNot((Function1 & Serializable)f -> this.ignore((File)f));
        List extJarInfos = extFiles.map((Function1 & Serializable)file -> this.logJar((File)file));
        String version = (String)Try$.MODULE$.apply(this::$anonfun$14).toOption().getOrElse(SystemInfo::$anonfun$15);
        String release = (String)Try$.MODULE$.apply(this::$anonfun$16).toOption().getOrElse(SystemInfo::$anonfun$17);
        RunInfo runInfo = (RunInfo)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RunInfo.class));
        String pid = JavaPID$.MODULE$.value();
        JavaSettings javaSettings = this.buildJavaSettings();
        String licence = this.loadLicenceFile();
        String locale = Locale.getDefault().toLanguageTag();
        String timeZone = ZoneId.systemDefault().getDisplayName(TextStyle.FULL, Locale.getDefault());
        MongoDBSettings mongoDBInfo = this.buildMongoDBInfo();
        List<String> modules = this.listModules();
        List<JobEngine> jobEngines = this.listJobEngines();
        Set<String> extras = this.buildExtras();
        this.log().info(() -> SystemInfo.buildJsonStructure$$anonfun$1(javaSettings), Line$.MODULE$.apply(66), FullName$.MODULE$.apply("ambience.sysinfo.SystemInfo.buildJsonStructure"));
        return JsonResponse$.MODULE$.apply(ClusterInfo$.MODULE$.SystemId().getValue(), this.module.now(), version, release, runInfo.runId(), pid, licence, locale, timeZone, mongoDBInfo, modules, jobEngines, javaSettings, jarInfos, extJarInfos, fingerprint, elxFingerprint, extras);
    }

    public String trunc(String s) {
        if (s.length() > 19) {
            return s.substring(0, 10) + " " + s.substring(11, 19) + "Z";
        }
        return s;
    }

    public String loadLicenceFile() {
        Config licConfig = ((LicenceConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(LicenceConfig.class))).config().withValue("licence-key", ConfigValueFactory.fromAnyRef((Object)"<masked>"));
        return ((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(licConfig.entrySet()).asScala().toList().map((Function1 & Serializable)kv -> kv.getKey() + ":" + this.getLicenceValues((ConfigValue)kv.getValue())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n");
    }

    private String getLicenceValues(ConfigValue value) {
        return value.render(ConfigRenderOptions.concise());
    }

    public List<String> listModules() {
        return (List)((ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class))).Modules().modules().keySet().toList().sorted((Ordering)Ordering.String$.MODULE$);
    }

    public List<JobEngine> listJobEngines() {
        SystemQueueManager sqm = (SystemQueueManager)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(SystemQueueManager.class));
        List engines = (List)sqm.engineIds().toList().sorted((Ordering)Ordering.String$.MODULE$);
        Set jobTypes = (Set)sqm.jobTypes().map((Function1 & Serializable)_$8 -> _$8 == null ? null : ((JobType)_$8).value());
        return engines.map((Function1 & Serializable)e -> JobEngine$.MODULE$.apply(e, jobTypes));
    }

    public MongoDBSettings buildMongoDBInfo() {
        boolean enabled;
        boolean bl = enabled = this.hasMongoDB() && this.config().getBoolean("ambience.modules.sysinfo.include-mongodb-settings");
        if (enabled) {
            String rawConnectionString = Crypt$.MODULE$.encPrefixDecrypt(this.config().getString("elixir.mongo.connectionString"));
            String connectionString = rawConnectionString.replace(",", ".COMMA.");
            String connectionChecksum = Checksum$.MODULE$.apply(connectionString);
            ExtractHostPort.HostPort hostPort = ExtractHostPort$.MODULE$.apply(connectionString);
            Future fRet = org.mongodb.scala.package$.MODULE$.SingleObservableFuture(SystemInfo::$anonfun$19).toFuture();
            Try try_ = Try$.MODULE$.apply(() -> SystemInfo.buildMongoDBInfo$$anonfun$1(fRet));
            if (try_ instanceof Success) {
                Document doc = (Document)((Success)try_).value();
                String version = (String)doc.get("version", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$9 -> _$9.getValue()).getOrElse(SystemInfo::$anonfun$21);
                String maxBsonObjectSize = this.inBytes((Option<BsonInt32>)doc.get("maxBsonObjectSize", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)));
                String target_arch = this.bsonToString((Option<BsonValue>)BsonETL$.MODULE$.get(doc, "buildEnvironment.target_arch"));
                String target_os = this.bsonToString((Option<BsonValue>)BsonETL$.MODULE$.get(doc, "buildEnvironment.target_os"));
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"Host");
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Port");
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Version");
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Max. Bson Size");
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Target Architecture");
                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Target OS");
                String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"Connection Fingerprint");
                return MongoDBSettings$.MODULE$.apply((List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)hostPort.host()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)hostPort.port()), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)version), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)maxBsonObjectSize), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)target_arch), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)target_os), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)connectionChecksum), (List)Nil$.MODULE$))))))));
            }
            if (try_ instanceof Failure) {
                Throwable err = ((Failure)try_).exception();
                this.log().warn(() -> SystemInfo.buildMongoDBInfo$$anonfun$2(err), Line$.MODULE$.apply(143), FullName$.MODULE$.apply("ambience.sysinfo.SystemInfo.buildMongoDBInfo"));
                return MongoDBSettings$.MODULE$.apply((List)scala.package$.MODULE$.Nil());
            }
            throw new MatchError((Object)try_);
        }
        return MongoDBSettings$.MODULE$.apply((List)scala.package$.MODULE$.Nil());
    }

    public String bsonToString(Option<BsonValue> bv) {
        BsonValue bsonValue;
        Option<BsonValue> option = bv;
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
            BsonString s = (BsonString)bsonValue;
            return s.getValue();
        }
        return "Unavailable";
    }

    public String inBytes(Option<BsonInt32> bv) {
        Option<BsonInt32> option = bv;
        if (option instanceof Some) {
            BsonInt32 i = (BsonInt32)((Some)option).value();
            return StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.grouped$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.reverse$extension(Predef$.MODULE$.augmentString(String.valueOf(i.getValue())))), 3).mkString(","))) + " bytes";
        }
        if (None$.MODULE$.equals(option)) {
            return "Unavailable";
        }
        throw new MatchError(option);
    }

    public JavaSettings buildJavaSettings() {
        List items = (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"user.name", "user.home", "user.dir", "java.version", "java.vendor", "java.home", "java.io.tmpdir", "os.name", "os.arch", "os.version"}));
        List core = items.map((Function1 & Serializable)item -> JavaSetting$.MODULE$.apply(item, System.getProperty(item)));
        JavaSetting gc = this.buildGCSettings();
        return JavaSettings$.MODULE$.apply(((List)new .colon.colon((Object)gc, (List)Nil$.MODULE$)).$colon$colon$colon(core));
    }

    public JavaSetting buildGCSettings() {
        Buffer gcMxBeans = CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        return JavaSetting$.MODULE$.apply("garbage collection", ((IterableOnceOps)gcMxBeans.map((Function1 & Serializable)bean -> bean.getName())).mkString(", "));
    }

    public JarInfo logJar(File file) {
        Some some;
        Try try_ = Try$.MODULE$.apply(() -> SystemInfo.$anonfun$23(file));
        if (try_ instanceof Success) {
            ZipFile zip2 = (ZipFile)((Success)try_).value();
            some = Some$.MODULE$.apply((Object)zip2);
        } else if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            this.log().warn(() -> SystemInfo.$anonfun$24(file, ex), Line$.MODULE$.apply(191), FullName$.MODULE$.apply("ambience.sysinfo.SystemInfo.optTS"));
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        Option optTS = some.flatMap((Function1 & Serializable)zip -> Option$.MODULE$.apply((Object)zip.getEntry("META-INF/MANIFEST.MF")).map((Function1 & Serializable)meta -> this.buildMap(com.elixirtech.arch.package$.MODULE$.enrichInputStream(zip.getInputStream((ZipEntry)meta)).text())).flatMap((Function1 & Serializable)map -> map.get((Object)"ElxBuild").flatMap((Function1 & Serializable)s -> Try$.MODULE$.apply(() -> SystemInfo.$anonfun$25$$anonfun$2$$anonfun$1$$anonfun$1(s)).toOption()).map((Function1 & Serializable)ts -> ts)));
        return JarInfo$.MODULE$.apply(file.getName(), Checksum$.MODULE$.apply(file), optTS);
    }

    public boolean ignore(File f) {
        String string = f.getName().toLowerCase();
        if (".ds_store".equals(string)) {
            return true;
        }
        return "empty-directory.txt".equals(string);
    }

    public Map<String, String> buildMap(String text) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])text.split("\n"));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)s -> SystemInfo.pair$1(s), ClassTag$.MODULE$.apply(Tuple2.class))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    public Set<String> buildExtras() {
        File dependencyChecks = new File(this.module.codeLoaderOptions().WebRootDir(), "build/dependency-check-report.html");
        if (dependencyChecks.exists() && dependencyChecks.isFile()) {
            return (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"dependency-checks"}));
        }
        return Predef$.MODULE$.Set().empty();
    }

    private static final MongoDB hasMongoDB$lzyINIT1$$anonfun$1() {
        return (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
    }

    private static final File[] $anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final File[] $anonfun$9() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private final String $anonfun$14() {
        return this.trunc(this.config().getString("ambience.ElxVersion"));
    }

    private static final String $anonfun$15() {
        return "Unknown";
    }

    private final String $anonfun$16() {
        return this.trunc(this.config().getString("ambience.ElxRelease"));
    }

    private static final String $anonfun$17() {
        return "Unknown";
    }

    private static final Object buildJsonStructure$$anonfun$1(JavaSettings javaSettings$1) {
        return "buildingJsonResponse " + javaSettings$1.items().mkString(", ");
    }

    private static final SingleObservable $anonfun$19() {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"buildInfo");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return ((MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class))).mongoClient().getDatabase("admin").runCommand((Bson)org.mongodb.scala.bson.collection.package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
    }

    private static final Document buildMongoDBInfo$$anonfun$1(Future fRet$1) {
        return (Document)Await$.MODULE$.result((Awaitable)fRet$1, (Duration)FiniteDuration$.MODULE$.apply(20L, package$.MODULE$.SECONDS()));
    }

    private static final String $anonfun$21() {
        return "Unavailable";
    }

    private static final Object buildMongoDBInfo$$anonfun$2(Throwable err$1) {
        return "Error getting MongoDBInfo: " + err$1;
    }

    private static final ZipFile $anonfun$23(File file$1) {
        return new ZipFile(file$1);
    }

    private static final Object $anonfun$24(File file$2, Throwable ex$1) {
        return "Can't open zip " + file$2.getName() + ": " + ex$1;
    }

    private static final JarBuild $anonfun$25$$anonfun$2$$anonfun$1$$anonfun$1(String s$1) {
        return JarBuild$.MODULE$.apply(s$1.substring(0, 10), s$1.substring(11, 19));
    }

    private static final Option pair$1(String s) {
        int idx = s.indexOf(":");
        if (idx >= 0) {
            return Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)s.substring(0, idx).trim(), (Object)s.substring(idx + 1).trim()));
        }
        return None$.MODULE$;
    }
}

