/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chore.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chore.model.IParameterHolder;
import com.elixirtech.chore.model.Parameter;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public abstract class Identifier
implements IBean,
IParameterHolder {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Identifier.class);
    protected boolean m_IsLoaded;
    protected List<Parameter> m_Parameter = new ArrayList<Parameter>();
    protected String m_Name;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public String getTagName() {
        return "id";
    }

    public void loaded() {
        this.m_IsLoaded = true;
        Iterator<Parameter> iterator = this.m_Parameter.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    public void dispose() {
        if (this.m_Parameter != null) {
            Iterator<Parameter> iterator = this.m_Parameter.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Parameter = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Identifier identifier = (Identifier)this.getClass().newInstance();
        identifier.m_Name = this.m_Name;
        return identifier;
    }

    public Parameter getParameter(String string) {
        Iterator<Parameter> iterator = this.getParameterIterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!parameter.getKey().equals(string) || !parameter.isEnabled().booleanValue()) continue;
            return parameter;
        }
        return null;
    }

    public void setParameter(String string, String string2) {
        Parameter parameter = this.getParameter(string);
        if (parameter == null) {
            parameter = new Parameter(string, string2);
            parameter.setEnabled(Boolean.TRUE);
            this.m_Parameter.add(parameter);
        } else {
            parameter.setValue(string2);
        }
    }

    public String getParameterValue(String string) {
        Parameter parameter = this.getParameter(string);
        if (parameter != null && parameter.isEnabled().booleanValue()) {
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public void addParameter(Parameter parameter) {
        this.m_Parameter.add(parameter);
    }

    public void addParameter(int n, Parameter parameter) {
        this.m_Parameter.add(n, parameter);
    }

    public void addAllParameters(Collection<Parameter> collection) {
        this.m_Parameter.addAll(collection);
    }

    public int indexOfParameter(Parameter parameter) {
        return this.m_Parameter.indexOf(parameter);
    }

    @Override
    public void removeParameter(Parameter parameter) {
        this.m_Parameter.remove(parameter);
    }

    public void removeAllParameters(Collection collection) {
        this.m_Parameter.removeAll(collection);
    }

    public void removeAllParameters() {
        this.m_Parameter.clear();
    }

    @Override
    public Parameter getParameter(int n) {
        return this.m_Parameter.get(n);
    }

    @Override
    public int getParameterCount() {
        return this.m_Parameter.size();
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameter.iterator();
    }

    @Override
    public List<Parameter> getParameterList() {
        return this.m_Parameter;
    }

    public void setParameterList(List<Parameter> list) {
        this.m_Parameter = list;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public abstract Identifier deepCopy();

    protected void copyInto(Identifier identifier) {
        identifier.m_Name = this.m_Name;
        identifier.m_Parameter = new ArrayList<Parameter>();
        for (Parameter parameter : this.m_Parameter) {
            identifier.addParameter(parameter.deepCopy());
        }
    }
}

