/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chore.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.chore.model.CompositeTask;
import com.elixirtech.chore.model.Job;
import com.elixirtech.chore.model.Notes;
import com.elixirtech.jdom.Element;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.sax.IBean;
import java.util.HashSet;
import java.util.Set;

public abstract class Task
implements IBean,
ChangeNotifier,
IDirtyState {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Task.class);
    private CompositeTask m_Parent;
    protected boolean m_IsLoaded;
    protected Notes m_Notes;
    protected String m_Name;
    protected Boolean m_Enabled = true;
    private Set<ChangeListener> m_ChangeListeners;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public String getTagName() {
        return "task";
    }

    public CompositeTask getParent() {
        return this.m_Parent;
    }

    public void setParent(CompositeTask compositeTask) {
        this.m_Parent = compositeTask;
    }

    public void loaded() {
        this.m_IsLoaded = true;
        if (this.m_Notes != null) {
            this.m_Notes.loaded();
        }
    }

    public void dispose() {
        if (this.m_Notes != null) {
            if (this.m_Notes != null) {
                this.m_Notes.dispose();
            }
            this.m_Notes = null;
        }
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_Enabled != null) {
            element.setAttribute("enabled", this.m_Enabled != false ? "Yes" : "No");
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Task task = (Task)this.getClass().newInstance();
        task.m_Name = this.m_Name;
        task.m_Enabled = this.m_Enabled;
        return task;
    }

    public abstract String getTypeName();

    public void setDirty(boolean bl) {
        if (this.m_Parent != null) {
            this.m_Parent.setDirty(bl);
        }
    }

    public boolean isDirty() {
        if (this.m_Parent != null) {
            return this.m_Parent.isDirty();
        }
        return false;
    }

    public void addDirtyListener(IDirtyState.Listener listener) {
    }

    public void removeDirtyListener(IDirtyState.Listener listener) {
    }

    public Notes getNotes() {
        return this.m_Notes;
    }

    public void setNotes(Notes notes) {
        this.m_Notes = notes;
    }

    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
        if (this.m_Name != null) {
            this.m_Name = this.m_Name.trim();
        }
    }

    public Boolean isEnabled() {
        return this.m_Enabled;
    }

    public void setEnabled(Boolean bl) {
        this.m_Enabled = bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet<ChangeListener>();
        }
        this.m_ChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
        if (this.m_ChangeListeners.size() == 0) {
            this.m_ChangeListeners = null;
        }
    }

    public void notifyChanged(String string) {
        if (this.m_ChangeListeners != null) {
            for (ChangeListener changeListener : this.m_ChangeListeners) {
                changeListener.beanChanged((ChangeNotifier)this, string);
            }
        }
    }

    public Job.MyTreeModel getTreeModel() {
        if (this.m_Parent != null) {
            return this.m_Parent.getTreeModel();
        }
        return null;
    }

    public abstract Task deepCopy();

    protected void copyInto(Task task) {
        task.m_Name = this.m_Name;
        task.m_Enabled = this.m_Enabled;
        if (this.m_Notes != null) {
            task.m_Notes = this.m_Notes.deepCopy();
        }
    }
}

