/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chore.sax;

import ambience.etl.chore.ChoreFileObject;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chore.model.Job;
import com.elixirtech.chore.model.JobSAX;
import com.elixirtech.chore.sax.IJobBuilder;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JobBuilder
implements IJobBuilder {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(JobBuilder.class);

    @Override
    public Job build(ChoreFileObject choreFileObject) throws IOException {
        m_Log.debug((Object)("readJob(" + choreFileObject.getName() + ")"));
        Job job = JobBuilder.build(choreFileObject.getInputStream());
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Job build(InputStream inputStream) throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            JobSAX jobSAX = new JobSAX();
            try {
                sAXParser.parse(inputStream, (DefaultHandler)((Object)jobSAX));
            }
            finally {
                inputStream.close();
            }
            Job job = (Job)jobSAX.getObject();
            job.loaded();
            return job;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            m_Log.error((Object)("readJob: " + String.valueOf(parserConfigurationException)), (Throwable)parserConfigurationException);
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            m_Log.error((Object)("readJob: " + String.valueOf(sAXException)), (Throwable)sAXException);
            throw new IOException(sAXException.toString());
        }
    }
}

