/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import ambience.etl.chore.ChoreFileObject;
import ambience.etl.chore.ChoreRepository;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.Ant;
import com.elixirtech.chore.model.AntFile;
import com.elixirtech.chore.model.Parameter;
import com.elixirtech.chore.model.Task;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Hashtable;
import java.util.Iterator;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;

public class AntRunnable
implements TaskRunnable {
    public static final String TYPE = "Ant";
    private Ant m_Ant;

    @Override
    public void setTask(Task task) {
        this.m_Ant = (Ant)task;
    }

    @Override
    public Task getTask() {
        return this.m_Ant;
    }

    @Override
    public void run(JobContext jobContext) throws TaskException {
        try {
            Target target;
            jobContext.debug(TYPE, "begin");
            Project project = new Project();
            project.init();
            project.setUserProperty("ant.version", Main.getAntVersion());
            AntFile antFile = this.m_Ant.getAntFile();
            String string = jobContext.substitute(antFile.getName());
            this.parseFile(project, string);
            Hashtable hashtable = project.getTargets();
            String string2 = this.m_Ant.getTarget();
            if (StringUtil.isEmpty((String)string2)) {
                string2 = project.getDefaultTarget();
            }
            if ((target = (Target)hashtable.get(string2)) != null) {
                Iterator<Parameter> iterator = antFile.getParameterIterator();
                while (iterator.hasNext()) {
                    Parameter parameter = iterator.next();
                    if (!Boolean.TRUE.equals(parameter.isEnabled())) continue;
                    String string3 = parameter.getKey();
                    String string4 = jobContext.substitute(parameter.getValue());
                    project.setProperty(string3, string4);
                }
            } else {
                String string5 = "Build target \"" + string2 + "\" not found";
                jobContext.error(TYPE, string5);
                throw new NonRecoverableException(string5);
            }
            project.addBuildListener((BuildListener)new BL(jobContext));
            target.execute();
            jobContext.debug(TYPE, "end");
        }
        catch (Exception exception) {
            jobContext.error(TYPE, "Error processing Ant file: " + exception.toString());
            throw new NonRecoverableException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(Project project, String string) throws IOException {
        String string2 = string.startsWith("repository:") ? string.substring(11) : string;
        ChoreFileObject choreFileObject = ChoreRepository.getFileJ(string2);
        if (choreFileObject != null) {
            File file = File.createTempFile("ant-", ".xml");
            try {
                try (InputStream inputStream = choreFileObject.getInputStream();){
                    Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                ProjectHelper projectHelper = ProjectHelper.getProjectHelper();
                projectHelper.parse(project, (Object)file);
            }
            finally {
                file.delete();
            }
        }
        throw new IOException("File Not Found: " + string2);
    }

    private static class BL
    implements BuildListener {
        private JobContext m_Context;

        public BL(JobContext jobContext) {
            this.m_Context = jobContext;
        }

        public void buildStarted(BuildEvent buildEvent) {
            this.m_Context.debug(AntRunnable.TYPE, "Build Started");
        }

        public void buildFinished(BuildEvent buildEvent) {
            this.m_Context.debug(AntRunnable.TYPE, "Build Finished");
        }

        public void targetStarted(BuildEvent buildEvent) {
            this.m_Context.debug(AntRunnable.TYPE, "Target " + buildEvent.getTarget().getName() + " started");
        }

        public void targetFinished(BuildEvent buildEvent) {
            this.m_Context.debug(AntRunnable.TYPE, "Target " + buildEvent.getTarget().getName() + " finished");
        }

        public void taskStarted(BuildEvent buildEvent) {
            this.m_Context.debug(AntRunnable.TYPE, "Task " + buildEvent.getTask().getTaskName() + " started");
        }

        public void taskFinished(BuildEvent buildEvent) {
            this.m_Context.debug(AntRunnable.TYPE, "Task " + buildEvent.getTask().getTaskName() + " finished");
        }

        public void messageLogged(BuildEvent buildEvent) {
            String string = buildEvent.getMessage();
            if (string != null) {
                this.m_Context.info(AntRunnable.TYPE, string);
            }
        }
    }
}

