/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import ambience.etl.chore.ChoreFileObject;
import ambience.etl.chore.ChoreRepository;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.DataLoop;
import com.elixirtech.chore.model.DataSource;
import com.elixirtech.chore.model.Parameter;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.ensemble.ds.DSUtil;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.v2.jobengine.job.CompositeRunnable;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.RecoverableException;
import com.elixirtech.v2.jobengine.job.ScopedJobContext;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;
import java.util.Iterator;

public class DataLoopRunnable
extends CompositeRunnable {
    public static final String TYPE = "DataLoop";

    @Override
    public void run(JobContext jobContext) throws TaskException {
        jobContext.debug(TYPE, "begin");
        DataLoop dataLoop = (DataLoop)this.m_Task;
        DataSource dataSource = dataLoop.getDataSource();
        String string = jobContext.substitute(dataSource.getName());
        ChoreFileObject choreFileObject = ChoreRepository.getFileJ(string);
        if (choreFileObject != null) {
            ScopedJobContext scopedJobContext = new ScopedJobContext(jobContext);
            try {
                IDataSource iDataSource = DSUtil.load((RMLFileObject)choreFileObject.toRMLFileObject());
                DefaultPushContext defaultPushContext = new DefaultPushContext();
                Iterator<Parameter> iterator = dataSource.getParameterIterator();
                while (iterator.hasNext()) {
                    Parameter parameter = iterator.next();
                    defaultPushContext.setParameter(parameter.getKey(), jobContext.substitute(parameter.getValue()));
                }
                iDataSource.pushTo((PushContext)defaultPushContext, (DataListener)new DL(scopedJobContext));
            }
            catch (Exception exception) {
                jobContext.error(TYPE, "Datasource processing error: " + String.valueOf(exception));
                Throwable throwable = exception.getCause();
                if (throwable != null && throwable instanceof TaskException) {
                    throw (TaskException)throwable;
                }
                throw new RecoverableException(exception);
            }
        } else {
            String string2 = "Datasource not found: " + string;
            jobContext.info(TYPE, string2);
            throw new NonRecoverableException(string2);
        }
        jobContext.debug(TYPE, "end");
    }

    protected void runLoop(ScopedJobContext scopedJobContext) throws TaskException {
        for (TaskRunnable taskRunnable : this.m_Run) {
            taskRunnable.run(scopedJobContext);
        }
    }

    private class DL
    implements DataListener {
        private ScopedJobContext m_Scope;
        private DataSchema m_Schema;
        private String[] m_Names;
        private DataType[] m_Types;

        public DL(ScopedJobContext scopedJobContext) {
            this.m_Scope = scopedJobContext;
        }

        public void startData(IDataSource iDataSource) {
            this.m_Schema = iDataSource.getSchema();
            this.m_Names = new String[this.m_Schema.getColumnCount()];
            this.m_Types = new DataType[this.m_Schema.getColumnCount()];
            for (int i = 0; i < this.m_Names.length; ++i) {
                this.m_Names[i] = this.m_Schema.getColumnName(i);
                this.m_Types[i] = this.m_Schema.getColumnType(i);
            }
        }

        public void startGroup(DataGroup dataGroup) {
        }

        public boolean processRecord(DataRecord dataRecord) {
            Object[] objectArray = dataRecord.getData();
            if (objectArray.length > 0) {
                this.m_Scope.debug(DataLoopRunnable.TYPE, "processRecord " + String.valueOf(objectArray[0]));
            }
            for (int i = 0; i < this.m_Names.length; ++i) {
                this.m_Scope.setProperty(this.m_Names[i], this.m_Schema.format(this.m_Types[i], objectArray[i]));
            }
            try {
                DataLoopRunnable.this.runLoop(this.m_Scope);
            }
            catch (TaskException taskException) {
                throw new RuntimeException("Failed to process data.", taskException);
            }
            return true;
        }

        public void endGroup(DataGroup dataGroup) {
        }

        public void endData(IDataSource iDataSource) {
        }
    }
}

