/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import ambience.etl.chore.ChoreFileObject;
import ambience.etl.chore.ChoreRepository;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.FileCriteria;
import com.elixirtech.chore.model.FileLoop;
import com.elixirtech.v2.jobengine.job.CompositeRunnable;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.ScopedJobContext;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;
import com.elixirtech.v2.jobengine.job.WhenProcessor;
import java.util.Iterator;

public class FileLoopRunnable
extends CompositeRunnable {
    public static final String TYPE = "FileLoop";

    @Override
    public void run(JobContext jobContext) throws TaskException {
        jobContext.debug(TYPE, "begin");
        FileLoop fileLoop = (FileLoop)this.m_Task;
        String string = jobContext.substitute(fileLoop.getFolder());
        ChoreFileObject choreFileObject = ChoreRepository.getFileJ(string);
        if (choreFileObject != null) {
            ScopedJobContext scopedJobContext = new ScopedJobContext(jobContext);
            if (fileLoop.isRecursive()) {
                this.recurse(scopedJobContext, choreFileObject);
            } else {
                this.process(scopedJobContext, choreFileObject);
            }
        } else {
            String string2 = "Folder not found: " + string;
            jobContext.info(TYPE, string2);
            throw new NonRecoverableException(string2);
        }
        jobContext.debug(TYPE, "end");
    }

    private void recurse(ScopedJobContext scopedJobContext, ChoreFileObject choreFileObject) throws TaskException {
        if (choreFileObject.isFolder()) {
            ChoreFileObject[] choreFileObjectArray = choreFileObject.getChildrenJ();
            for (int i = 0; i < choreFileObjectArray.length; ++i) {
                this.recurse(scopedJobContext, choreFileObjectArray[i]);
            }
        } else {
            this.processFile(scopedJobContext, choreFileObject);
        }
    }

    private void process(ScopedJobContext scopedJobContext, ChoreFileObject choreFileObject) throws TaskException {
        if (choreFileObject.isFolder()) {
            ChoreFileObject[] choreFileObjectArray = choreFileObject.getChildrenJ();
            for (int i = 0; i < choreFileObjectArray.length; ++i) {
                if (!choreFileObjectArray[i].isData()) continue;
                this.processFile(scopedJobContext, choreFileObjectArray[i]);
            }
        } else {
            this.processFile(scopedJobContext, choreFileObject);
        }
    }

    private void processFile(ScopedJobContext scopedJobContext, ChoreFileObject choreFileObject) throws TaskException {
        if (this.meetsCriteria(scopedJobContext, choreFileObject)) {
            FileLoop fileLoop = (FileLoop)this.m_Task;
            String string = fileLoop.getParameterName();
            String string2 = choreFileObject.getPathString();
            if (StringUtil.notEmpty((String)string)) {
                scopedJobContext.setProperty(string, string2);
            }
            this.runLoop(scopedJobContext);
        }
    }

    private boolean meetsCriteria(ScopedJobContext scopedJobContext, ChoreFileObject choreFileObject) {
        FileLoop fileLoop = (FileLoop)this.m_Task;
        Iterator<FileCriteria> iterator = fileLoop.getCriteriaIterator();
        while (iterator.hasNext()) {
            FileCriteria fileCriteria = iterator.next();
            if (this.meetsCriteria(scopedJobContext, choreFileObject, fileCriteria)) continue;
            return false;
        }
        return true;
    }

    private boolean meetsCriteria(ScopedJobContext scopedJobContext, ChoreFileObject choreFileObject, FileCriteria fileCriteria) {
        String string = fileCriteria.getTest();
        String string2 = fileCriteria.getWhen();
        String string3 = scopedJobContext.substitute(fileCriteria.getValue());
        Object object = null;
        if ("Name".equals(string)) {
            object = choreFileObject.getName();
        } else if ("Extension".equals(string)) {
            object = choreFileObject.getExtension();
        } else if ("Path".equals(string)) {
            object = choreFileObject.getPath();
        } else if ("LastModified".equals(string)) {
            object = choreFileObject.lastModified();
        } else {
            return true;
        }
        WhenProcessor whenProcessor = WhenProcessor.get(string2);
        if (whenProcessor != null) {
            return whenProcessor.matches(object, string3);
        }
        return true;
    }

    private void runLoop(ScopedJobContext scopedJobContext) throws TaskException {
        for (TaskRunnable taskRunnable : this.m_Run) {
            taskRunnable.run(scopedJobContext);
        }
    }
}

