/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.Job;
import com.elixirtech.chore.model.OnFailure;
import com.elixirtech.v2.jobengine.job.CompositeRunnable;
import com.elixirtech.v2.jobengine.job.NestedJobContext;
import com.elixirtech.v2.jobengine.job.OnFailureRunnable;
import com.elixirtech.v2.jobengine.job.RecoverableException;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;

public class JobRunnable
extends CompositeRunnable {
    public static final String TYPE = "Job";

    @Override
    public void run(JobContext jobContext) throws TaskException {
        Job job = (Job)this.m_Task;
        jobContext.info(TYPE, "Job Start");
        NestedJobContext nestedJobContext = new NestedJobContext(jobContext, job);
        OnFailureRunnable onFailureRunnable = this.getOnFailureRunnable();
        int n = 0;
        if (onFailureRunnable != null) {
            n = this.getMaxRetry(jobContext, onFailureRunnable);
        }
        int n2 = 0;
        boolean bl = false;
        do {
            try {
                for (TaskRunnable taskRunnable : this.m_Run) {
                    if (this.isOnFailureTask(taskRunnable)) continue;
                    taskRunnable.run(nestedJobContext);
                }
                jobContext.info(TYPE, "Job End Successfully");
                bl = false;
            }
            catch (TaskException taskException) {
                jobContext.warn(TYPE, "Job failed with error: " + taskException.getMessage());
                if (onFailureRunnable != null) {
                    onFailureRunnable.run(nestedJobContext);
                }
                boolean bl2 = bl = taskException instanceof RecoverableException && n2 < n;
                if (bl) {
                    jobContext.info(TYPE, "We will try it again.");
                    ++n2;
                    continue;
                }
                throw taskException;
            }
        } while (bl);
    }

    private int getMaxRetry(JobContext jobContext, OnFailureRunnable onFailureRunnable) {
        OnFailure onFailure = (OnFailure)onFailureRunnable.getTask();
        int n = 0;
        if (onFailure != null && (n = onFailure.getRetry()) < 0) {
            jobContext.warn(TYPE, "Invalid job re-try counter: " + n);
            n = 0;
        }
        return n;
    }

    private OnFailureRunnable getOnFailureRunnable() {
        for (TaskRunnable taskRunnable : this.m_Run) {
            if (!this.isOnFailureTask(taskRunnable)) continue;
            return (OnFailureRunnable)taskRunnable;
        }
        return null;
    }

    private boolean isOnFailureTask(TaskRunnable taskRunnable) {
        return taskRunnable.getTask() instanceof OnFailure;
    }
}

