/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.Loop;
import com.elixirtech.v2.jobengine.job.CompositeRunnable;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;

public class LoopRunnable
extends CompositeRunnable {
    public static final String TYPE = "Loop";

    @Override
    public void run(JobContext jobContext) throws TaskException {
        jobContext.debug(TYPE, "begin");
        Loop loop = (Loop)this.m_Task;
        String string = jobContext.substitute(loop.getRepeatCount());
        if (string == null) {
            jobContext.error(TYPE, "Repeat count is not configured.");
            throw new NonRecoverableException("Repeat count is not configured.");
        }
        int n = 0;
        try {
            n = Double.valueOf(string).intValue();
        }
        catch (NumberFormatException numberFormatException) {
            String string2 = "Can't parse repeat count \"" + string + "\"";
            jobContext.error(TYPE, string2);
            throw new NonRecoverableException(string2);
        }
        for (int i = 0; i < n; ++i) {
            jobContext.info(TYPE, "Iteration " + (i + 1));
            for (TaskRunnable taskRunnable : this.m_Run) {
                taskRunnable.run(jobContext);
            }
        }
        jobContext.debug(TYPE, "end");
    }
}

