/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import com.elixirtech.arch.Credentials;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.security.Authentication;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.Parallel;
import com.elixirtech.chore.model.Task;
import com.elixirtech.v2.jobengine.job.CompositeRunnable;
import com.elixirtech.v2.jobengine.job.TaskException;
import com.elixirtech.v2.jobengine.job.TaskRunnable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class ParallelRunnable
extends CompositeRunnable {
    public static final String TYPE = "Parallel";

    @Override
    public void run(JobContext jobContext) throws TaskException {
        jobContext.debug(TYPE, "begin");
        Parallel parallel = (Parallel)this.m_Task;
        String string = parallel.getThreadCount();
        int n = 0;
        if (StringUtil.notEmpty((String)string)) {
            string = jobContext.substitute(string);
            try {
                n = Double.valueOf(string).intValue();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n > 0) {
            this.runPool(jobContext, n);
        } else {
            this.runAllThreads(jobContext);
        }
        jobContext.debug(TYPE, "end");
    }

    private void runPool(JobContext jobContext, int n) throws TaskException {
        Credentials credentials = Authentication.credentials();
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        int n2 = this.m_Run.size();
        TaskRunner[] taskRunnerArray = new TaskRunner[n2];
        for (int i = 0; i < n2; ++i) {
            taskRunnerArray[i] = new TaskRunner(jobContext, (TaskRunnable)this.m_Run.get(i), credentials);
            executorService.execute(taskRunnerArray[i]);
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }
        catch (InterruptedException interruptedException) {
            jobContext.warn(TYPE, "Parallel executor interrupted");
            Thread.currentThread().interrupt();
        }
        this.checkTaskExceptions(taskRunnerArray);
    }

    private void runAllThreads(JobContext jobContext) throws TaskException {
        int n;
        Credentials credentials = Authentication.credentials();
        int n2 = this.m_Run.size();
        Thread[] threadArray = new Thread[n2];
        TaskRunner[] taskRunnerArray = new TaskRunner[n2];
        for (n = 0; n < n2; ++n) {
            taskRunnerArray[n] = new TaskRunner(jobContext, (TaskRunnable)this.m_Run.get(n), credentials);
            threadArray[n] = new Thread(taskRunnerArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            threadArray[n].start();
        }
        for (n = 0; n < n2; ++n) {
            try {
                threadArray[n].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                Parallel parallel = (Parallel)this.m_Task;
                Task task = parallel.getTask(n);
                jobContext.warn(TYPE, "Thread interrupted: " + task.getTypeName() + ":" + task.getName());
            }
        }
        this.checkTaskExceptions(taskRunnerArray);
    }

    private void checkTaskExceptions(TaskRunner[] taskRunnerArray) throws TaskException {
        for (int i = 0; i < taskRunnerArray.length; ++i) {
            if (taskRunnerArray[i].getException() == null) continue;
            throw taskRunnerArray[i].getException();
        }
    }

    private static class TaskRunner
    implements Runnable {
        private JobContext m_Context;
        private TaskRunnable m_Runnable;
        private TaskException m_Exception;

        public TaskRunner(JobContext jobContext, TaskRunnable taskRunnable, Credentials credentials) {
            this.m_Context = jobContext;
            this.m_Runnable = taskRunnable;
        }

        @Override
        public void run() {
            try {
                this.m_Runnable.run(this.m_Context);
            }
            catch (TaskException taskException) {
                this.m_Exception = taskException;
            }
        }

        public TaskException getException() {
            return this.m_Exception;
        }
    }
}

