/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.v2.jobengine.job;

import ambience.api.RMLEngine;
import ambience.api.ReportEngine;
import ambience.etl.chore.ChoreFileObject;
import ambience.etl.chore.ChoreRepository$;
import ambience.module.CurrentUser$;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeType$;
import com.elixirtech.arch.job.IJobLog;
import com.elixirtech.arch.job.JobLogStorage$;
import com.elixirtech.arch.job.JobLogging$;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.chore.JobContext;
import com.elixirtech.chore.model.RenderReport;
import com.elixirtech.chore.model.Report;
import com.elixirtech.chore.model.Target;
import com.elixirtech.chore.model.Task;
import com.elixirtech.v2.jobengine.job.NonRecoverableException;
import com.elixirtech.v2.jobengine.job.RecoverableException;
import com.elixirtech.v2.jobengine.job.RunJob$;
import com.elixirtech.v2.jobengine.job.TaskRunnable;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public class RenderReportRunnable
implements TaskRunnable,
SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(RenderReportRunnable.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final Scheduler scheduler = Scheduler$.MODULE$.global();
    private final FiniteDuration RenderTimeout = FiniteDuration$.MODULE$.apply(8L, package$.MODULE$.HOURS());
    private final String TYPE;
    private RenderReport m_RenderReport = null;

    public RenderReportRunnable() {
        this.TYPE = "RenderReport";
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public FiniteDuration RenderTimeout() {
        return this.RenderTimeout;
    }

    public String TYPE() {
        return this.TYPE;
    }

    @Override
    public void setTask(Task t) {
        this.m_RenderReport = (RenderReport)t;
    }

    @Override
    public Task getTask() {
        return this.m_RenderReport;
    }

    public void runDocx(ChoreFileObject fo, JobContext cxt) {
        cxt.debug(this.TYPE(), "begin");
        Target target = this.m_RenderReport.getTarget();
        target.setName(cxt.substitute(target.getName()));
        cxt.debug(this.TYPE(), "end");
    }

    @Override
    public void run(JobContext cxt) {
        cxt.debug(this.TYPE(), "begin");
        Report report = this.m_RenderReport.getReport();
        String reportName = cxt.substitute(report.getName());
        Option<ChoreFileObject> option = ChoreRepository$.MODULE$.getFile(reportName);
        if (None$.MODULE$.equals(option)) {
            String errMsg = "Report not available: " + reportName;
            cxt.error(this.TYPE(), errMsg);
            throw new NonRecoverableException(errMsg);
        }
        if (option instanceof Some) {
            ChoreFileObject choreFileObject = (ChoreFileObject)((Some)option).value();
            ChoreFileObject fo = choreFileObject;
            if (fo.getExtension().endsWith("docx")) {
                this.runDocx(fo, cxt);
                return;
            }
            ChoreFileObject fo2 = choreFileObject;
            this.runRml(fo2, cxt, reportName);
            return;
        }
        throw new MatchError(option);
    }

    public void runRml(ChoreFileObject fo, JobContext cxt, String reportName) {
        block6: {
            try {
                BoxedUnit boxedUnit;
                Option option = CurrentUser$.MODULE$.get();
                if (option instanceof Some) {
                    UserDB.User user = (UserDB.User)((Some)option).value();
                    RMLEngine engine = (RMLEngine)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RMLEngine.class));
                    Report report = this.m_RenderReport.getReport();
                    Target target = this.m_RenderReport.getTarget();
                    Json reportParams = Json$.MODULE$.obj((Seq)RunJob$.MODULE$.getParams(cxt, report).toList().map((Function1 & Serializable)x$1 -> {
                        Tuple2 tuple2 = x$1;
                        if (tuple2 != null) {
                            String k = (String)tuple2._1();
                            String v = (String)tuple2._2();
                            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)k);
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(v));
                        }
                        throw new MatchError((Object)tuple2);
                    }));
                    Map<String, String> targetParams = RunJob$.MODULE$.getParams(cxt, target);
                    MimeType mimeType = MimeType$.MODULE$.apply((String)targetParams.getOrElse((Object)"mime-type", RenderReportRunnable::$anonfun$2));
                    ReportEngine.Request request = ReportEngine.Request$.MODULE$.apply(ReportEngine.TemplatePath$.MODULE$.apply(fo.getPath()), mimeType, reportParams, Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
                    Either either = (Either)Await$.MODULE$.result((Awaitable)engine.renderReport(user, request).runToFuture(this.scheduler()), (Duration)this.RenderTimeout());
                    if (either instanceof Right) {
                        ReportEngine.Report result = (ReportEngine.Report)((Right)either).value();
                        boxedUnit = result.bytes();
                        break block6;
                    }
                    if (either instanceof Left) {
                        ReportEngine.Error error = (ReportEngine.Error)((Left)either).value();
                        IJobLog jobLog = JobLogStorage$.MODULE$.load(error.jobLog());
                        jobLog.entries().foreach((Function1)(JProcedure1 & Serializable)entry -> JobLogging$.MODULE$.add(entry));
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    throw new MatchError((Object)either);
                }
                if (None$.MODULE$.equals(option)) {
                    cxt.error(this.TYPE(), "No current user defined");
                    boxedUnit = BoxedUnit.UNIT;
                    break block6;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception ex) {
                throw new RecoverableException(ex);
            }
        }
        cxt.debug(this.TYPE(), "end");
    }

    private static final String $anonfun$2() {
        return "application/pdf";
    }
}

