/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.bouncycastle.extensions;

import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.bouncycastle.extensions.PGPPublicKeyExtensionsKt;
import org.pgpainless.exception.KeyIntegrityException;
import org.pgpainless.key.OpenPgpFingerprint;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.key.protection.UnlockSecretKey;
import org.pgpainless.util.Passphrase;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\t\u001a\u00020\n*\u0004\u0018\u00010\u0002\u001a\f\u0010\u000b\u001a\u00020\n*\u0004\u0018\u00010\u0002\u001a\f\u0010\f\u001a\u00020\n*\u0004\u0018\u00010\u0002\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u001a\u0016\u0010\r\u001a\u00020\u000e*\u00020\u00022\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0007\u001a\u0012\u0010\r\u001a\u00020\u000e*\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"openPgpFingerprint", "Lorg/pgpainless/key/OpenPgpFingerprint;", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "getOpenPgpFingerprint", "(Lorg/bouncycastle/openpgp/PGPSecretKey;)Lorg/pgpainless/key/OpenPgpFingerprint;", "publicKeyAlgorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getPublicKeyAlgorithm", "(Lorg/bouncycastle/openpgp/PGPSecretKey;)Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "hasDummyS2K", "", "isDecrypted", "isEncrypted", "unlock", "Lorg/bouncycastle/openpgp/PGPPrivateKey;", "decryptor", "Lorg/bouncycastle/openpgp/operator/PBESecretKeyDecryptor;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "passphrase", "Lorg/pgpainless/util/Passphrase;", "pgpainless-core"})
public final class PGPSecretKeyExtensionsKt {
    @NotNull
    public static final PGPPrivateKey unlock(@NotNull PGPSecretKey $this$unlock, @NotNull Passphrase passphrase) throws PGPException, KeyIntegrityException {
        Intrinsics.checkNotNullParameter((Object)$this$unlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return UnlockSecretKey.Companion.unlockSecretKey($this$unlock, passphrase);
    }

    @JvmOverloads
    @NotNull
    public static final PGPPrivateKey unlock(@NotNull PGPSecretKey $this$unlock, @NotNull SecretKeyRingProtector protector) throws PGPException, KeyIntegrityException {
        Intrinsics.checkNotNullParameter((Object)$this$unlock, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        return UnlockSecretKey.Companion.unlockSecretKey($this$unlock, protector);
    }

    public static /* synthetic */ PGPPrivateKey unlock$default(PGPSecretKey pGPSecretKey, SecretKeyRingProtector secretKeyRingProtector, int n, Object object) throws PGPException, KeyIntegrityException {
        if ((n & 1) != 0) {
            secretKeyRingProtector = SecretKeyRingProtector.Companion.unprotectedKeys();
        }
        return PGPSecretKeyExtensionsKt.unlock(pGPSecretKey, secretKeyRingProtector);
    }

    @NotNull
    public static final PGPPrivateKey unlock(@NotNull PGPSecretKey $this$unlock, @Nullable PBESecretKeyDecryptor decryptor) throws PGPException, KeyIntegrityException {
        Intrinsics.checkNotNullParameter((Object)$this$unlock, (String)"<this>");
        return UnlockSecretKey.Companion.unlockSecretKey($this$unlock, decryptor);
    }

    public static final boolean isEncrypted(@Nullable PGPSecretKey $this$isEncrypted) {
        return $this$isEncrypted != null && $this$isEncrypted.getS2KUsage() != 0;
    }

    public static final boolean isDecrypted(@Nullable PGPSecretKey $this$isDecrypted) {
        return $this$isDecrypted == null || $this$isDecrypted.getS2KUsage() == 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasDummyS2K(@Nullable PGPSecretKey $this$hasDummyS2K) {
        if ($this$hasDummyS2K == null) return false;
        S2K s2K = $this$hasDummyS2K.getS2K();
        if (s2K == null) return false;
        if (s2K.getType() != 101) return false;
        return true;
    }

    @NotNull
    public static final PublicKeyAlgorithm getPublicKeyAlgorithm(@NotNull PGPSecretKey $this$publicKeyAlgorithm) {
        Intrinsics.checkNotNullParameter((Object)$this$publicKeyAlgorithm, (String)"<this>");
        PGPPublicKey pGPPublicKey = $this$publicKeyAlgorithm.getPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)pGPPublicKey, (String)"publicKey");
        return PGPPublicKeyExtensionsKt.getPublicKeyAlgorithm(pGPPublicKey);
    }

    @NotNull
    public static final OpenPgpFingerprint getOpenPgpFingerprint(@NotNull PGPSecretKey $this$openPgpFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$openPgpFingerprint, (String)"<this>");
        return OpenPgpFingerprint.Companion.of($this$openPgpFingerprint);
    }

    @JvmOverloads
    @NotNull
    public static final PGPPrivateKey unlock(@NotNull PGPSecretKey $this$unlock) throws PGPException, KeyIntegrityException {
        Intrinsics.checkNotNullParameter((Object)$this$unlock, (String)"<this>");
        return PGPSecretKeyExtensionsKt.unlock$default($this$unlock, null, 1, null);
    }
}

