/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.HashAlgorithm;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.algorithm.StreamEncoding;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;

public class OpenPgpInputStream
extends BufferedInputStream {
    private static final byte[] ARMOR_HEADER = "-----BEGIN PGP ".getBytes(Charset.forName("UTF8"));
    public static final int MAX_BUFFER_SIZE = 16384;
    private final byte[] buffer;
    private final int bufferLen;
    private boolean containsArmorHeader;
    private boolean containsOpenPgpPackets;
    private boolean isLikelyOpenPgpMessage;

    public OpenPgpInputStream(InputStream in, boolean check) throws IOException {
        super(in, 16384);
        this.mark(16384);
        this.buffer = new byte[16384];
        this.bufferLen = this.read(this.buffer);
        this.reset();
        if (check) {
            this.inspectBuffer();
        }
    }

    public OpenPgpInputStream(InputStream in) throws IOException {
        this(in, true);
    }

    private void inspectBuffer() throws IOException {
        if (this.checkForAsciiArmor()) {
            return;
        }
        this.checkForBinaryOpenPgp();
    }

    private boolean checkForAsciiArmor() {
        if (this.startsWithIgnoringWhitespace(this.buffer, ARMOR_HEADER, this.bufferLen)) {
            this.containsArmorHeader = true;
            return true;
        }
        return false;
    }

    private void checkForBinaryOpenPgp() throws IOException {
        if (this.bufferLen == -1) {
            return;
        }
        ByteArrayInputStream bufferIn = new ByteArrayInputStream(this.buffer, 0, this.bufferLen);
        this.nonExhaustiveParseAndCheckPlausibility(bufferIn);
    }

    private void nonExhaustiveParseAndCheckPlausibility(ByteArrayInputStream bufferIn) throws IOException {
        int hdr = bufferIn.read();
        if (hdr < 0 || (hdr & 0x80) == 0) {
            return;
        }
        boolean newPacket = (hdr & 0x40) != 0;
        int tag = 0;
        int bodyLen = 0;
        boolean partial = false;
        if (newPacket) {
            tag = hdr & 0x3F;
            int l = bufferIn.read();
            if (l < 192) {
                bodyLen = l;
            } else if (l <= 223) {
                int b = bufferIn.read();
                bodyLen = (l - 192 << 8) + b + 192;
            } else if (l == 255) {
                bodyLen = bufferIn.read() << 24 | bufferIn.read() << 16 | bufferIn.read() << 8 | bufferIn.read();
            } else {
                partial = true;
                bodyLen = 1 << (l & 0x1F);
            }
        } else {
            int lengthType = hdr & 3;
            tag = (hdr & 0x3F) >> 2;
            switch (lengthType) {
                case 0: {
                    bodyLen = bufferIn.read();
                    break;
                }
                case 1: {
                    bodyLen = bufferIn.read() << 8 | bufferIn.read();
                    break;
                }
                case 2: {
                    bodyLen = bufferIn.read() << 24 | bufferIn.read() << 16 | bufferIn.read() << 8 | bufferIn.read();
                    break;
                }
                case 3: {
                    partial = true;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (bodyLen < 0) {
            return;
        }
        BCPGInputStream bcpgIn = new BCPGInputStream((InputStream)bufferIn);
        switch (tag) {
            case 0: {
                return;
            }
            case 1: {
                int pkeskVersion = bcpgIn.read();
                if (pkeskVersion <= 0 || pkeskVersion > 5) {
                    return;
                }
                for (int i = 0; i < 8; ++i) {
                    bcpgIn.read();
                }
                int pkeskAlg = bcpgIn.read();
                if (PublicKeyAlgorithm.fromId(pkeskAlg) == null) {
                    return;
                }
                this.containsOpenPgpPackets = true;
                this.isLikelyOpenPgpMessage = true;
                break;
            }
            case 2: {
                int sigType;
                int sigVersion = bcpgIn.read();
                if (sigVersion == 2 || sigVersion == 3) {
                    int l = bcpgIn.read();
                    sigType = bcpgIn.read();
                } else if (sigVersion == 4 || sigVersion == 5) {
                    sigType = bcpgIn.read();
                } else {
                    return;
                }
                try {
                    SignatureType.requireFromCode(sigType);
                }
                catch (NoSuchElementException e) {
                    return;
                }
                this.containsOpenPgpPackets = true;
                break;
            }
            case 3: {
                int skeskVersion = bcpgIn.read();
                if (skeskVersion == 4) {
                    int skeskAlg = bcpgIn.read();
                    if (SymmetricKeyAlgorithm.fromId(skeskAlg) == null) {
                        return;
                    }
                } else {
                    return;
                }
                this.containsOpenPgpPackets = true;
                this.isLikelyOpenPgpMessage = true;
                break;
            }
            case 4: {
                int opsVersion = bcpgIn.read();
                if (opsVersion == 3) {
                    int opsSigType = bcpgIn.read();
                    try {
                        SignatureType.requireFromCode(opsSigType);
                    }
                    catch (NoSuchElementException e) {
                        return;
                    }
                    int opsHashAlg = bcpgIn.read();
                    if (HashAlgorithm.fromId(opsHashAlg) == null) {
                        return;
                    }
                    int opsKeyAlg = bcpgIn.read();
                    if (PublicKeyAlgorithm.fromId(opsKeyAlg) == null) {
                        return;
                    }
                } else {
                    return;
                }
                this.containsOpenPgpPackets = true;
                this.isLikelyOpenPgpMessage = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 14: {
                int keyAlg;
                int keyVersion = bcpgIn.read();
                for (int i = 0; i < 4; ++i) {
                    bcpgIn.read();
                }
                if (keyVersion == 3) {
                    long validDays = this.in.read() << 8 | this.in.read();
                    if (validDays < 0L) {
                        return;
                    }
                } else if (keyVersion != 4 && keyVersion != 5) {
                    return;
                }
                if (PublicKeyAlgorithm.fromId(keyAlg = bcpgIn.read()) == null) {
                    return;
                }
                this.containsOpenPgpPackets = true;
                break;
            }
            case 8: {
                int compAlg = bcpgIn.read();
                if (CompressionAlgorithm.fromId(compAlg) == null) {
                    return;
                }
                this.containsOpenPgpPackets = true;
                this.isLikelyOpenPgpMessage = true;
                break;
            }
            case 9: {
                this.containsOpenPgpPackets = true;
                break;
            }
            case 10: {
                byte[] marker = new byte[3];
                bcpgIn.readFully(marker);
                if (marker[0] != 80 || marker[1] != 71 || marker[2] != 80) {
                    return;
                }
                this.containsOpenPgpPackets = true;
                break;
            }
            case 11: {
                int format = bcpgIn.read();
                if (StreamEncoding.fromCode(format) == null) {
                    return;
                }
                this.containsOpenPgpPackets = true;
                this.isLikelyOpenPgpMessage = true;
                break;
            }
            case 12: 
            case 13: 
            case 17: {
                this.containsOpenPgpPackets = true;
                break;
            }
            case 18: {
                int seipVersion = bcpgIn.read();
                if (seipVersion != 1) {
                    return;
                }
                this.isLikelyOpenPgpMessage = true;
                this.containsOpenPgpPackets = true;
                break;
            }
            case 19: {
                byte[] digest = new byte[20];
                bcpgIn.readFully(digest);
                this.containsOpenPgpPackets = true;
                break;
            }
            case 60: 
            case 61: 
            case 62: 
            case 63: {
                return;
            }
            default: {
                this.containsOpenPgpPackets = false;
            }
        }
    }

    private boolean startsWithIgnoringWhitespace(byte[] bytes, byte[] subsequence, int bufferLen) {
        if (bufferLen == -1) {
            return false;
        }
        for (int i = 0; i < bufferLen; ++i) {
            if (Character.isWhitespace(bytes[i])) continue;
            if (i + subsequence.length > bytes.length) {
                return false;
            }
            for (int j = 0; j < subsequence.length; ++j) {
                if (bytes[i + j] == subsequence[j]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isAsciiArmored() {
        return this.containsArmorHeader;
    }

    public boolean isBinaryOpenPgp() {
        return this.containsOpenPgpPackets;
    }

    public boolean isLikelyOpenPgpMessage() {
        return this.isLikelyOpenPgpMessage;
    }

    public boolean isNonOpenPgp() {
        return !this.isAsciiArmored() && !this.isBinaryOpenPgp();
    }
}

