/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.decryption_verification.syntax_check;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.decryption_verification.syntax_check.InputSymbol;
import org.pgpainless.decryption_verification.syntax_check.StackSymbol;
import org.pgpainless.decryption_verification.syntax_check.State;
import org.pgpainless.decryption_verification.syntax_check.Syntax;
import org.pgpainless.decryption_verification.syntax_check.Transition;
import org.pgpainless.exception.MalformedOpenPgpMessageException;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\"\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/pgpainless/decryption_verification/syntax_check/OpenPgpMessageSyntax;", "Lorg/pgpainless/decryption_verification/syntax_check/Syntax;", "()V", "fromCompressedMessage", "Lorg/pgpainless/decryption_verification/syntax_check/Transition;", "input", "Lorg/pgpainless/decryption_verification/syntax_check/InputSymbol;", "stackItem", "Lorg/pgpainless/decryption_verification/syntax_check/StackSymbol;", "fromEncryptedMessage", "fromLiteralMessage", "fromOpenPgpMessage", "fromValid", "transition", "from", "Lorg/pgpainless/decryption_verification/syntax_check/State;", "pgpainless-core"})
public final class OpenPgpMessageSyntax
implements Syntax {
    @Override
    @NotNull
    public Transition transition(@NotNull State from, @NotNull InputSymbol input, @Nullable StackSymbol stackItem) {
        Transition transition;
        Intrinsics.checkNotNullParameter((Object)((Object)from), (String)"from");
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        switch (WhenMappings.$EnumSwitchMapping$0[from.ordinal()]) {
            case 1: {
                transition = this.fromOpenPgpMessage(input, stackItem);
                break;
            }
            case 2: {
                transition = this.fromLiteralMessage(input, stackItem);
                break;
            }
            case 3: {
                transition = this.fromCompressedMessage(input, stackItem);
                break;
            }
            case 4: {
                transition = this.fromEncryptedMessage(input, stackItem);
                break;
            }
            case 5: {
                transition = this.fromValid(input, stackItem);
                break;
            }
            default: {
                throw new MalformedOpenPgpMessageException(from, input, stackItem);
            }
        }
        return transition;
    }

    @NotNull
    public final Transition fromOpenPgpMessage(@NotNull InputSymbol input, @Nullable StackSymbol stackItem) {
        Transition transition;
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        if (stackItem != StackSymbol.MSG) {
            throw new MalformedOpenPgpMessageException(State.OPENPGP_MESSAGE, input, stackItem);
        }
        switch (WhenMappings.$EnumSwitchMapping$1[input.ordinal()]) {
            case 1: {
                transition = new Transition(State.LITERAL_MESSAGE, new StackSymbol[0]);
                break;
            }
            case 2: {
                StackSymbol[] stackSymbolArray = new StackSymbol[]{StackSymbol.MSG};
                Transition transition2 = new Transition(State.OPENPGP_MESSAGE, stackSymbolArray);
                transition = transition2;
                break;
            }
            case 3: {
                StackSymbol[] stackSymbolArray = new StackSymbol[]{StackSymbol.OPS, StackSymbol.MSG};
                Transition transition3 = new Transition(State.OPENPGP_MESSAGE, stackSymbolArray);
                transition = transition3;
                break;
            }
            case 4: {
                transition = new Transition(State.COMPRESSED_MESSAGE, new StackSymbol[0]);
                break;
            }
            case 5: {
                transition = new Transition(State.ENCRYPTED_MESSAGE, new StackSymbol[0]);
                break;
            }
            case 6: {
                throw new MalformedOpenPgpMessageException(State.OPENPGP_MESSAGE, input, stackItem);
            }
            default: {
                throw new MalformedOpenPgpMessageException(State.OPENPGP_MESSAGE, input, stackItem);
            }
        }
        return transition;
    }

    @NotNull
    public final Transition fromLiteralMessage(@NotNull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        if (input == InputSymbol.SIGNATURE && stackItem == StackSymbol.OPS) {
            return new Transition(State.LITERAL_MESSAGE, new StackSymbol[0]);
        }
        if (input == InputSymbol.END_OF_SEQUENCE && stackItem == StackSymbol.TERMINUS) {
            return new Transition(State.VALID, new StackSymbol[0]);
        }
        throw new MalformedOpenPgpMessageException(State.LITERAL_MESSAGE, input, stackItem);
    }

    @NotNull
    public final Transition fromCompressedMessage(@NotNull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        if (input == InputSymbol.SIGNATURE && stackItem == StackSymbol.OPS) {
            return new Transition(State.COMPRESSED_MESSAGE, new StackSymbol[0]);
        }
        if (input == InputSymbol.END_OF_SEQUENCE && stackItem == StackSymbol.TERMINUS) {
            return new Transition(State.VALID, new StackSymbol[0]);
        }
        throw new MalformedOpenPgpMessageException(State.COMPRESSED_MESSAGE, input, stackItem);
    }

    @NotNull
    public final Transition fromEncryptedMessage(@NotNull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        if (input == InputSymbol.SIGNATURE && stackItem == StackSymbol.OPS) {
            return new Transition(State.ENCRYPTED_MESSAGE, new StackSymbol[0]);
        }
        if (input == InputSymbol.END_OF_SEQUENCE && stackItem == StackSymbol.TERMINUS) {
            return new Transition(State.VALID, new StackSymbol[0]);
        }
        throw new MalformedOpenPgpMessageException(State.ENCRYPTED_MESSAGE, input, stackItem);
    }

    @NotNull
    public final Transition fromValid(@NotNull InputSymbol input, @Nullable StackSymbol stackItem) throws MalformedOpenPgpMessageException {
        Intrinsics.checkNotNullParameter((Object)((Object)input), (String)"input");
        if (input == InputSymbol.END_OF_SEQUENCE) {
            return new Transition(State.VALID, new StackSymbol[0]);
        }
        throw new MalformedOpenPgpMessageException(State.VALID, input, stackItem);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.OPENPGP_MESSAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.LITERAL_MESSAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.COMPRESSED_MESSAGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.ENCRYPTED_MESSAGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.VALID.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[InputSymbol.values().length];
            try {
                nArray[InputSymbol.LITERAL_DATA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputSymbol.SIGNATURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputSymbol.ONE_PASS_SIGNATURE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputSymbol.COMPRESSED_DATA.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputSymbol.ENCRYPTED_DATA.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[InputSymbol.END_OF_SEQUENCE.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

