/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.StreamEncoding;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/pgpainless/encryption_signing/CRLFGeneratorStream;", "Ljava/io/OutputStream;", "crlfOut", "encoding", "Lorg/pgpainless/algorithm/StreamEncoding;", "(Ljava/io/OutputStream;Lorg/pgpainless/algorithm/StreamEncoding;)V", "isBinary", "", "lastB", "", "close", "", "flush", "write", "b", "pgpainless-core"})
public final class CRLFGeneratorStream
extends OutputStream {
    @NotNull
    private final OutputStream crlfOut;
    private final boolean isBinary;
    private int lastB;

    public CRLFGeneratorStream(@NotNull OutputStream crlfOut, @NotNull StreamEncoding encoding) {
        Intrinsics.checkNotNullParameter((Object)crlfOut, (String)"crlfOut");
        Intrinsics.checkNotNullParameter((Object)((Object)encoding), (String)"encoding");
        this.crlfOut = crlfOut;
        this.isBinary = encoding == StreamEncoding.BINARY;
    }

    @Override
    public void write(int b) {
        if (!this.isBinary) {
            if (b == 10 && this.lastB != 13) {
                this.crlfOut.write(13);
            } else if (this.lastB == 13 && b != 10) {
                this.crlfOut.write(10);
            }
            this.lastB = b;
        }
        this.crlfOut.write(b);
    }

    @Override
    public void close() {
        if (!this.isBinary && this.lastB == 13) {
            this.crlfOut.write(10);
        }
        this.crlfOut.close();
    }

    @Override
    public void flush() {
        super.flush();
        this.crlfOut.flush();
    }
}

