/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.generation.type.ecc.ecdsa;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.jetbrains.annotations.NotNull;
import org.pgpainless.algorithm.PublicKeyAlgorithm;
import org.pgpainless.key.generation.type.KeyType;
import org.pgpainless.key.generation.type.ecc.EllipticCurve;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/pgpainless/key/generation/type/ecc/ecdsa/ECDSA;", "Lorg/pgpainless/key/generation/type/KeyType;", "curve", "Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "(Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;)V", "algorithm", "Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "getAlgorithm", "()Lorg/pgpainless/algorithm/PublicKeyAlgorithm;", "algorithmSpec", "Lorg/bouncycastle/jce/spec/ECNamedCurveGenParameterSpec;", "getAlgorithmSpec", "()Lorg/bouncycastle/jce/spec/ECNamedCurveGenParameterSpec;", "bitStrength", "", "getBitStrength", "()I", "getCurve", "()Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "name", "", "getName", "()Ljava/lang/String;", "Companion", "pgpainless-core"})
public final class ECDSA
implements KeyType {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EllipticCurve curve;
    @NotNull
    private final String name;
    @NotNull
    private final PublicKeyAlgorithm algorithm;
    private final int bitStrength;
    @NotNull
    private final ECNamedCurveGenParameterSpec algorithmSpec;

    private ECDSA(EllipticCurve curve) {
        this.curve = curve;
        this.name = "ECDSA";
        this.algorithm = PublicKeyAlgorithm.ECDSA;
        this.bitStrength = this.curve.getBitStrength();
        this.algorithmSpec = new ECNamedCurveGenParameterSpec(this.curve.getCurveName());
    }

    @NotNull
    public final EllipticCurve getCurve() {
        return this.curve;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PublicKeyAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public int getBitStrength() {
        return this.bitStrength;
    }

    @NotNull
    public ECNamedCurveGenParameterSpec getAlgorithmSpec() {
        return this.algorithmSpec;
    }

    @JvmStatic
    @NotNull
    public static final ECDSA fromCurve(@NotNull EllipticCurve curve) {
        return Companion.fromCurve(curve);
    }

    public /* synthetic */ ECDSA(EllipticCurve curve, DefaultConstructorMarker $constructor_marker) {
        this(curve);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lorg/pgpainless/key/generation/type/ecc/ecdsa/ECDSA$Companion;", "", "()V", "fromCurve", "Lorg/pgpainless/key/generation/type/ecc/ecdsa/ECDSA;", "curve", "Lorg/pgpainless/key/generation/type/ecc/EllipticCurve;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ECDSA fromCurve(@NotNull EllipticCurve curve) {
            Intrinsics.checkNotNullParameter((Object)((Object)curve), (String)"curve");
            return new ECDSA(curve, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

