/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.key.parsing;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPKeyRing;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.util.io.Streams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.PGPainless;
import org.pgpainless.implementation.ImplementationFactory;
import org.pgpainless.key.collection.PGPKeyRingCollection;
import org.pgpainless.util.ArmorUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0019"}, d2={"Lorg/pgpainless/key/parsing/KeyRingReader;", "", "()V", "keyRing", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "inputStream", "Ljava/io/InputStream;", "bytes", "", "asciiArmored", "", "keyRingCollection", "Lorg/pgpainless/key/collection/PGPKeyRingCollection;", "inptStream", "isSilent", "", "publicKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "publicKeyRingCollection", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "secretKeyRing", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "secretKeyRingCollection", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "Companion", "pgpainless-core"})
public final class KeyRingReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MAX_ITERATIONS = 10000;
    @NotNull
    private static final Charset UTF8;

    @Nullable
    public final PGPKeyRing keyRing(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return org.pgpainless.key.parsing.KeyRingReader$Companion.readKeyRing$default(Companion, inputStream, 0, 2, null);
    }

    @Nullable
    public final PGPKeyRing keyRing(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.keyRing(new ByteArrayInputStream(bytes));
    }

    @Nullable
    public final PGPKeyRing keyRing(@NotNull String asciiArmored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)asciiArmored, (String)"asciiArmored");
        byte[] byArray = asciiArmored.getBytes(UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.keyRing(byArray);
    }

    @Nullable
    public final PGPPublicKeyRing publicKeyRing(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return org.pgpainless.key.parsing.KeyRingReader$Companion.readPublicKeyRing$default(Companion, inputStream, 0, 2, null);
    }

    @Nullable
    public final PGPPublicKeyRing publicKeyRing(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.publicKeyRing(new ByteArrayInputStream(bytes));
    }

    @Nullable
    public final PGPPublicKeyRing publicKeyRing(@NotNull String asciiArmored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)asciiArmored, (String)"asciiArmored");
        byte[] byArray = asciiArmored.getBytes(UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.publicKeyRing(byArray);
    }

    @NotNull
    public final PGPPublicKeyRingCollection publicKeyRingCollection(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return org.pgpainless.key.parsing.KeyRingReader$Companion.readPublicKeyRingCollection$default(Companion, inputStream, 0, 2, null);
    }

    @NotNull
    public final PGPPublicKeyRingCollection publicKeyRingCollection(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.publicKeyRingCollection(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public final PGPPublicKeyRingCollection publicKeyRingCollection(@NotNull String asciiArmored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)asciiArmored, (String)"asciiArmored");
        byte[] byArray = asciiArmored.getBytes(UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.publicKeyRingCollection(byArray);
    }

    @Nullable
    public final PGPSecretKeyRing secretKeyRing(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return org.pgpainless.key.parsing.KeyRingReader$Companion.readSecretKeyRing$default(Companion, inputStream, 0, 2, null);
    }

    @Nullable
    public final PGPSecretKeyRing secretKeyRing(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.secretKeyRing(new ByteArrayInputStream(bytes));
    }

    @Nullable
    public final PGPSecretKeyRing secretKeyRing(@NotNull String asciiArmored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)asciiArmored, (String)"asciiArmored");
        byte[] byArray = asciiArmored.getBytes(UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.secretKeyRing(byArray);
    }

    @NotNull
    public final PGPSecretKeyRingCollection secretKeyRingCollection(@NotNull InputStream inputStream) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        return org.pgpainless.key.parsing.KeyRingReader$Companion.readSecretKeyRingCollection$default(Companion, inputStream, 0, 2, null);
    }

    @NotNull
    public final PGPSecretKeyRingCollection secretKeyRingCollection(@NotNull byte[] bytes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.secretKeyRingCollection(new ByteArrayInputStream(bytes));
    }

    @NotNull
    public final PGPSecretKeyRingCollection secretKeyRingCollection(@NotNull String asciiArmored) throws IOException {
        Intrinsics.checkNotNullParameter((Object)asciiArmored, (String)"asciiArmored");
        byte[] byArray = asciiArmored.getBytes(UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.secretKeyRingCollection(byArray);
    }

    @NotNull
    public final PGPKeyRingCollection keyRingCollection(@NotNull InputStream inptStream, boolean isSilent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)inptStream, (String)"inptStream");
        return Companion.readKeyRingCollection(inptStream, isSilent);
    }

    @NotNull
    public final PGPKeyRingCollection keyRingCollection(@NotNull byte[] bytes, boolean isSilent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.keyRingCollection(new ByteArrayInputStream(bytes), isSilent);
    }

    @NotNull
    public final PGPKeyRingCollection keyRingCollection(@NotNull String asciiArmored, boolean isSilent) throws IOException {
        Intrinsics.checkNotNullParameter((Object)asciiArmored, (String)"asciiArmored");
        byte[] byArray = asciiArmored.getBytes(UTF8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.keyRingCollection(byArray, isSilent);
    }

    @NotNull
    public static final Charset getUTF8() {
        return Companion.getUTF8();
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PGPKeyRing readKeyRing(@NotNull InputStream inputStream, int maxIterations) throws IOException {
        return Companion.readKeyRing(inputStream, maxIterations);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PGPPublicKeyRing readPublicKeyRing(@NotNull InputStream inputStream, int maxIterations) throws IOException {
        return Companion.readPublicKeyRing(inputStream, maxIterations);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPPublicKeyRingCollection readPublicKeyRingCollection(@NotNull InputStream inputStream, int maxIterations) throws IOException {
        return Companion.readPublicKeyRingCollection(inputStream, maxIterations);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PGPSecretKeyRing readSecretKeyRing(@NotNull InputStream inputStream, int maxIterations) throws IOException {
        return Companion.readSecretKeyRing(inputStream, maxIterations);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPSecretKeyRingCollection readSecretKeyRingCollection(@NotNull InputStream inputStream, int maxIterations) throws IOException {
        return Companion.readSecretKeyRingCollection(inputStream, maxIterations);
    }

    @JvmStatic
    @NotNull
    public static final PGPKeyRingCollection readKeyRingCollection(@NotNull InputStream inputStream, boolean isSilent) throws IOException {
        return Companion.readKeyRingCollection(inputStream, isSilent);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PGPKeyRing readKeyRing(@NotNull InputStream inputStream) throws IOException {
        return Companion.readKeyRing(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PGPPublicKeyRing readPublicKeyRing(@NotNull InputStream inputStream) throws IOException {
        return Companion.readPublicKeyRing(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPPublicKeyRingCollection readPublicKeyRingCollection(@NotNull InputStream inputStream) throws IOException {
        return Companion.readPublicKeyRingCollection(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @Nullable
    public static final PGPSecretKeyRing readSecretKeyRing(@NotNull InputStream inputStream) throws IOException {
        return Companion.readSecretKeyRing(inputStream);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final PGPSecretKeyRingCollection readSecretKeyRingCollection(@NotNull InputStream inputStream) throws IOException {
        return Companion.readSecretKeyRingCollection(inputStream);
    }

    static {
        Charset charset = Charset.forName("UTF8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        UTF8 = charset;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007J\u001a\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0007\u0010\u0002\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001b"}, d2={"Lorg/pgpainless/key/parsing/KeyRingReader$Companion;", "", "()V", "MAX_ITERATIONS", "", "UTF8", "Ljava/nio/charset/Charset;", "getUTF8$annotations", "getUTF8", "()Ljava/nio/charset/Charset;", "readKeyRing", "Lorg/bouncycastle/openpgp/PGPKeyRing;", "inputStream", "Ljava/io/InputStream;", "maxIterations", "readKeyRingCollection", "Lorg/pgpainless/key/collection/PGPKeyRingCollection;", "isSilent", "", "readPublicKeyRing", "Lorg/bouncycastle/openpgp/PGPPublicKeyRing;", "readPublicKeyRingCollection", "Lorg/bouncycastle/openpgp/PGPPublicKeyRingCollection;", "readSecretKeyRing", "Lorg/bouncycastle/openpgp/PGPSecretKeyRing;", "readSecretKeyRingCollection", "Lorg/bouncycastle/openpgp/PGPSecretKeyRingCollection;", "pgpainless-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Charset getUTF8() {
            return UTF8;
        }

        @JvmStatic
        public static /* synthetic */ void getUTF8$annotations() {
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PGPKeyRing readKeyRing(@NotNull InputStream inputStream, int maxIterations) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(ArmorUtils.Companion.getDecoderStream(inputStream));
            try {
                Iterator iterator = objectFactory.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Object next = iterator.next();
                    if (i >= maxIterations) {
                        throw new IOException("Loop exceeded max iteration count.");
                    }
                    if (next instanceof PGPMarker) continue;
                    if (next instanceof PGPSecretKeyRing) {
                        return (PGPKeyRing)next;
                    }
                    if (!(next instanceof PGPPublicKeyRing)) continue;
                    return (PGPKeyRing)next;
                }
            }
            catch (PGPRuntimeOperationException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw throwable;
            }
            return null;
        }

        public static /* synthetic */ PGPKeyRing readKeyRing$default(Companion companion, InputStream inputStream, int n, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 10000;
            }
            return companion.readKeyRing(inputStream, n);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PGPPublicKeyRing readPublicKeyRing(@NotNull InputStream inputStream, int maxIterations) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(ArmorUtils.Companion.getDecoderStream(inputStream));
            try {
                Iterator iterator = objectFactory.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Object next = iterator.next();
                    if (i >= maxIterations) {
                        throw new IOException("Loop exceeded max iteration count.");
                    }
                    if (next instanceof PGPMarker || !(next instanceof PGPPublicKeyRing)) continue;
                    return (PGPPublicKeyRing)next;
                }
            }
            catch (PGPRuntimeOperationException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw throwable;
            }
            return null;
        }

        public static /* synthetic */ PGPPublicKeyRing readPublicKeyRing$default(Companion companion, InputStream inputStream, int n, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 10000;
            }
            return companion.readPublicKeyRing(inputStream, n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPPublicKeyRingCollection readPublicKeyRingCollection(@NotNull InputStream inputStream, int maxIterations) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(ArmorUtils.Companion.getDecoderStream(inputStream));
            List certificates = new ArrayList();
            try {
                Iterator iterator = objectFactory.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Object next = iterator.next();
                    if (i >= maxIterations) {
                        throw new IOException("Loop exceeded max iteration count.");
                    }
                    if (next instanceof PGPMarker) continue;
                    if (next instanceof PGPPublicKeyRing) {
                        certificates.add(next);
                        continue;
                    }
                    if (next instanceof PGPSecretKeyRing) {
                        certificates.add(PGPainless.Companion.extractCertificate((PGPSecretKeyRing)next));
                        continue;
                    }
                    if (!(next instanceof PGPPublicKeyRingCollection)) continue;
                    CollectionsKt.addAll((Collection)certificates, (Iterable)((Iterable)next));
                }
            }
            catch (PGPRuntimeOperationException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw throwable;
            }
            return new PGPPublicKeyRingCollection((Collection)certificates);
        }

        public static /* synthetic */ PGPPublicKeyRingCollection readPublicKeyRingCollection$default(Companion companion, InputStream inputStream, int n, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 10000;
            }
            return companion.readPublicKeyRingCollection(inputStream, n);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PGPSecretKeyRing readSecretKeyRing(@NotNull InputStream inputStream, int maxIterations) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            InputStream decoderStream = ArmorUtils.Companion.getDecoderStream(inputStream);
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(decoderStream);
            try {
                Iterator iterator = objectFactory.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Object next = iterator.next();
                    if (i >= maxIterations) {
                        throw new IOException("Loop exceeded max iteration count.");
                    }
                    if (next instanceof PGPMarker || !(next instanceof PGPSecretKeyRing)) continue;
                    Streams.drain((InputStream)decoderStream);
                    return (PGPSecretKeyRing)next;
                }
            }
            catch (PGPRuntimeOperationException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw throwable;
            }
            return null;
        }

        public static /* synthetic */ PGPSecretKeyRing readSecretKeyRing$default(Companion companion, InputStream inputStream, int n, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 10000;
            }
            return companion.readSecretKeyRing(inputStream, n);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPSecretKeyRingCollection readSecretKeyRingCollection(@NotNull InputStream inputStream, int maxIterations) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            PGPObjectFactory objectFactory = ImplementationFactory.Companion.getInstance().getPGPObjectFactory(ArmorUtils.Companion.getDecoderStream(inputStream));
            List secretKeys = new ArrayList();
            try {
                Iterator iterator = objectFactory.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int i = n++;
                    Object next = iterator.next();
                    if (i >= maxIterations) {
                        throw new IOException("Loop exceeded max iteration count.");
                    }
                    if (next instanceof PGPMarker) continue;
                    if (next instanceof PGPSecretKeyRing) {
                        secretKeys.add(next);
                        continue;
                    }
                    if (!(next instanceof PGPSecretKeyRingCollection)) continue;
                    CollectionsKt.addAll((Collection)secretKeys, (Iterable)((Iterable)next));
                }
            }
            catch (PGPRuntimeOperationException e) {
                Throwable throwable = e.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                throw throwable;
            }
            return new PGPSecretKeyRingCollection((Collection)secretKeys);
        }

        public static /* synthetic */ PGPSecretKeyRingCollection readSecretKeyRingCollection$default(Companion companion, InputStream inputStream, int n, int n2, Object object) throws IOException {
            if ((n2 & 2) != 0) {
                n = 10000;
            }
            return companion.readSecretKeyRingCollection(inputStream, n);
        }

        @JvmStatic
        @NotNull
        public final PGPKeyRingCollection readKeyRingCollection(@NotNull InputStream inputStream, boolean isSilent) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return new PGPKeyRingCollection(inputStream, isSilent);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PGPKeyRing readKeyRing(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return org.pgpainless.key.parsing.KeyRingReader$Companion.readKeyRing$default(this, inputStream, 0, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PGPPublicKeyRing readPublicKeyRing(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return org.pgpainless.key.parsing.KeyRingReader$Companion.readPublicKeyRing$default(this, inputStream, 0, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPPublicKeyRingCollection readPublicKeyRingCollection(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return org.pgpainless.key.parsing.KeyRingReader$Companion.readPublicKeyRingCollection$default(this, inputStream, 0, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @Nullable
        public final PGPSecretKeyRing readSecretKeyRing(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return org.pgpainless.key.parsing.KeyRingReader$Companion.readSecretKeyRing$default(this, inputStream, 0, 2, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final PGPSecretKeyRingCollection readSecretKeyRingCollection(@NotNull InputStream inputStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            return org.pgpainless.key.parsing.KeyRingReader$Companion.readSecretKeyRingCollection$default(this, inputStream, 0, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

