/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.signature.builder;

import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.pgpainless.algorithm.SignatureType;
import org.pgpainless.key.protection.SecretKeyRingProtector;
import org.pgpainless.signature.builder.AbstractSignatureBuilder;
import org.pgpainless.signature.subpackets.BaseSignatureSubpackets;
import org.pgpainless.signature.subpackets.RevocationSignatureSubpackets;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0013\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\f\u00a8\u0006\u001c"}, d2={"Lorg/pgpainless/signature/builder/RevocationSignatureBuilder;", "Lorg/pgpainless/signature/builder/AbstractSignatureBuilder;", "signatureType", "Lorg/pgpainless/algorithm/SignatureType;", "signingKey", "Lorg/bouncycastle/openpgp/PGPSecretKey;", "protector", "Lorg/pgpainless/key/protection/SecretKeyRingProtector;", "(Lorg/pgpainless/algorithm/SignatureType;Lorg/bouncycastle/openpgp/PGPSecretKey;Lorg/pgpainless/key/protection/SecretKeyRingProtector;)V", "hashedSubpackets", "Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets;", "getHashedSubpackets", "()Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets;", "signatureTypePredicate", "Ljava/util/function/Predicate;", "getSignatureTypePredicate", "()Ljava/util/function/Predicate;", "unhashedSubpackets", "getUnhashedSubpackets", "applyCallback", "callback", "Lorg/pgpainless/signature/subpackets/RevocationSignatureSubpackets$Callback;", "build", "Lorg/bouncycastle/openpgp/PGPSignature;", "revokeeUserId", "", "revokeeKey", "Lorg/bouncycastle/openpgp/PGPPublicKey;", "pgpainless-core"})
public final class RevocationSignatureBuilder
extends AbstractSignatureBuilder<RevocationSignatureBuilder> {
    @NotNull
    private final RevocationSignatureSubpackets hashedSubpackets;
    @NotNull
    private final RevocationSignatureSubpackets unhashedSubpackets;

    @Override
    @NotNull
    protected Predicate<SignatureType> getSignatureTypePredicate() {
        return RevocationSignatureBuilder::_get_signatureTypePredicate_$lambda$0;
    }

    public RevocationSignatureBuilder(@NotNull SignatureType signatureType, @NotNull PGPSecretKey signingKey, @NotNull SecretKeyRingProtector protector) throws PGPException {
        Intrinsics.checkNotNullParameter((Object)((Object)signatureType), (String)"signatureType");
        Intrinsics.checkNotNullParameter((Object)signingKey, (String)"signingKey");
        Intrinsics.checkNotNullParameter((Object)protector, (String)"protector");
        super(signatureType, signingKey, protector);
        this.hashedSubpackets = this.get_hashedSubpackets();
        this.unhashedSubpackets = this.get_unhashedSubpackets();
        this.hashedSubpackets.setRevocable(false);
    }

    @NotNull
    public final RevocationSignatureSubpackets getHashedSubpackets() {
        return this.hashedSubpackets;
    }

    @NotNull
    public final RevocationSignatureSubpackets getUnhashedSubpackets() {
        return this.unhashedSubpackets;
    }

    @NotNull
    public final RevocationSignatureBuilder applyCallback(@Nullable RevocationSignatureSubpackets.Callback callback2) {
        RevocationSignatureBuilder revocationSignatureBuilder;
        block0: {
            RevocationSignatureBuilder $this$applyCallback_u24lambda_u242 = revocationSignatureBuilder = this;
            boolean bl = false;
            RevocationSignatureSubpackets.Callback callback3 = callback2;
            if (callback3 == null) break block0;
            RevocationSignatureSubpackets.Callback it = callback3;
            boolean bl2 = false;
            it.modifyHashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.hashedSubpackets);
            it.modifyUnhashedSubpackets((BaseSignatureSubpackets)$this$applyCallback_u24lambda_u242.unhashedSubpackets);
        }
        return revocationSignatureBuilder;
    }

    @NotNull
    public final PGPSignature build(@NotNull PGPPublicKey revokeeKey) throws PGPException {
        PGPSignature pGPSignature;
        Intrinsics.checkNotNullParameter((Object)revokeeKey, (String)"revokeeKey");
        PGPSignatureGenerator it = this.buildAndInitSignatureGenerator();
        boolean bl = false;
        if (this.get_signatureType() == SignatureType.KEY_REVOCATION) {
            if (!revokeeKey.isMasterKey()) {
                boolean bl2 = false;
                String string = "Signature type is KEY_REVOCATION, but provided revokee does not appear to be a primary key.";
                throw new IllegalArgumentException(string.toString());
            }
            pGPSignature = it.generateCertification(revokeeKey);
        } else {
            pGPSignature = it.generateCertification(this.getPublicSigningKey(), revokeeKey);
        }
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"buildAndInitSignatureGen\u2026)\n            }\n        }");
        return pGPSignature;
    }

    @NotNull
    public final PGPSignature build(@NotNull CharSequence revokeeUserId) throws PGPException {
        PGPSignatureGenerator pGPSignatureGenerator;
        Intrinsics.checkNotNullParameter((Object)revokeeUserId, (String)"revokeeUserId");
        PGPSignatureGenerator it = pGPSignatureGenerator = this.buildAndInitSignatureGenerator();
        boolean bl = false;
        if (!(this.get_signatureType() == SignatureType.CERTIFICATION_REVOCATION)) {
            boolean bl2 = false;
            String string = "Signature type is != CERTIFICATION_REVOCATION.";
            throw new IllegalArgumentException(string.toString());
        }
        PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(((Object)revokeeUserId).toString(), this.getPublicSigningKey());
        Intrinsics.checkNotNullExpressionValue((Object)pGPSignature, (String)"buildAndInitSignatureGen\u2026ring(), publicSigningKey)");
        return pGPSignature;
    }

    private static final boolean _get_signatureTypePredicate_$lambda$0(SignatureType it) {
        SignatureType[] signatureTypeArray = new SignatureType[]{SignatureType.KEY_REVOCATION, SignatureType.SUBKEY_REVOCATION, SignatureType.CERTIFICATION_REVOCATION};
        return CollectionsKt.listOf((Object[])signatureTypeArray).contains((Object)it);
    }
}

