/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.binary;

import ambience.bson.BsonETL$;
import ambience.etl.ETLStep;
import ambience.etl.binary.CipherLogic;
import ambience.etl.binary.CipherLogic$IV$;
import ambience.etl.binary.CipherLogic$Info$;
import ambience.etl.binary.CipherLogic$Params$;
import ambience.etl.binary.CipherLogic$Secret$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.DecoderNotDeriveSum;
import io.circe.derivation.Default$;
import io.circe.derivation.EncoderNotDeriveSum;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import monix.eval.Task;
import monix.eval.Task$;
import org.apache.commons.codec.binary.Base64;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple5$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Try$;

public final class CipherLogic$
implements Serializable {
    private static final String Default;
    private static final List AlgorithmChoices;
    public static final CipherLogic$Info$ Info;
    private static final Json InfoJson;
    public static final CipherLogic$Secret$ Secret;
    public static final CipherLogic$IV$ IV;
    public static final CipherLogic$Params$ Params;
    public static final CipherLogic$ MODULE$;

    private CipherLogic$() {
    }

    static {
        MODULE$ = new CipherLogic$();
        Default = "AES/CBC/PKCS5Padding";
        AlgorithmChoices = (List)new .colon.colon((Object)Panel.SelectChoice$.MODULE$.apply(MODULE$.Default(), Json$.MODULE$.fromString(MODULE$.Default())), (List)Nil$.MODULE$);
        CipherLogic.Info info = (CipherLogic.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)CipherLogic$Info$.MODULE$.apply(CipherLogic$Info$.MODULE$.$lessinit$greater$default$1(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$2(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$3(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$4(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$5()));
        String string = "field";
        String string2 = "secretField";
        String string3 = "algorithm";
        String string4 = "ivField";
        String string5 = "result";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CipherLogic$.class);
    }

    public String Default() {
        return Default;
    }

    public List<Panel.SelectChoice> AlgorithmChoices() {
        return AlgorithmChoices;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public byte[] encrypt(String algorithm, CipherLogic.Params params, byte[] data) {
        Cipher cipher = Cipher.getInstance(algorithm);
        SecretKeySpec secretKeySpec = new SecretKeySpec(params.secret().value(), this.keyAlgorithm(algorithm));
        IvParameterSpec ivParamSpec = new IvParameterSpec(params.iv().value());
        cipher.init(1, (Key)secretKeySpec, ivParamSpec);
        return cipher.doFinal(data);
    }

    public byte[] decrypt(String algorithm, CipherLogic.Params params, byte[] data) {
        Cipher cipher = Cipher.getInstance(algorithm);
        SecretKeySpec secretKeySpec = new SecretKeySpec(params.secret().value(), this.keyAlgorithm(algorithm));
        IvParameterSpec ivParamSpec = new IvParameterSpec(params.iv().value());
        cipher.init(2, (Key)secretKeySpec, ivParamSpec);
        return cipher.doFinal(data);
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "field";
        String string2 = "secretField";
        String string3 = "algorithm";
        String string4 = "ivField";
        String string5 = "result";
        int size = 5;
        CipherLogic.Info info = (CipherLogic.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", CipherLogic$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), CipherLogic$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CipherLogic$::$anonfun$3))))).toOption().getOrElse(CipherLogic$::$anonfun$4);
        Panel.Item field = PanelItem$.MODULE$.text("field", "Bytes Field", info.field(), PanelItem$.MODULE$.text$default$4());
        Panel.Item secretField = PanelItem$.MODULE$.text("secretField", "Secret Field", info.secretField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item algorithm = PanelItem$.MODULE$.select("algorithm", "Algorithm", Json$.MODULE$.fromString(info.algorithm()), this.AlgorithmChoices(), PanelItem$.MODULE$.select$default$5());
        Panel.Item ivField = PanelItem$.MODULE$.text("ivField", "IV Field", info.ivField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item result = PanelItem$.MODULE$.text("result", "Result Field", info.result(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> CipherLogic$.buildPanel$$anonfun$1(field, secretField, algorithm, ivField, result));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> CipherLogic$.savePanel$$anonfun$1(results, step));
    }

    public Either<String, CipherLogic.Params> getParams(Document doc, CipherLogic.Info info) {
        return this.getSecretField(doc, info).flatMap((Function1 & Serializable)secret -> MODULE$.getIVField(doc, info).map((Function1 & Serializable)iv -> CipherLogic$Params$.MODULE$.apply((CipherLogic.Secret)secret, (CipherLogic.IV)iv)));
    }

    public Either<String, CipherLogic.Secret> getSecretField(Document doc, CipherLogic.Info info) {
        Option option = BsonETL$.MODULE$.get(doc, info.secretField());
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString secret = (BsonString)bsonValue;
                Either either = implicits$.MODULE$.catsSyntaxEither(Try$.MODULE$.apply(() -> CipherLogic$.getSecretField$$anonfun$1(secret)).toEither());
                return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)_$1 -> "Invalid Base64", (Function1 & Serializable)value -> CipherLogic$Secret$.MODULE$.apply((byte[])value));
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary secret = (BsonBinary)bsonValue;
                return package$.MODULE$.Right().apply((Object)CipherLogic$Secret$.MODULE$.apply(secret.getData()));
            }
            return package$.MODULE$.Left().apply((Object)("Secret field " + info.secretField() + " is not a string or bytes"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("Secret field " + info.secretField() + " does not exist"));
        }
        throw new MatchError((Object)option);
    }

    public Either<String, CipherLogic.IV> getIVField(Document doc, CipherLogic.Info info) {
        Option option = BsonETL$.MODULE$.get(doc, info.ivField());
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString iv = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)CipherLogic$IV$.MODULE$.apply(iv.getValue().getBytes("UTF-8")));
            }
            if (bsonValue instanceof BsonBinary) {
                BsonBinary iv = (BsonBinary)bsonValue;
                return package$.MODULE$.Right().apply((Object)CipherLogic$IV$.MODULE$.apply(iv.getData()));
            }
            return package$.MODULE$.Left().apply((Object)("IV field " + info.ivField() + " is not a string or bytes"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)("IV field " + info.ivField() + " does not exist"));
        }
        throw new MatchError((Object)option);
    }

    public String keyAlgorithm(String algorithm) {
        return "AES";
    }

    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        EncoderNotDeriveSum f$proxy1;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy1 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy1 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy1;
        Configuration x$2$proxy2 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy1;
        Configuration x$2$proxy3 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy1;
        Configuration x$2$proxy4 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this5 = f$proxy1;
        Configuration x$2$proxy5 = EncoderNotDeriveSum_this5.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        DecoderNotDeriveSum f$proxy2;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy2 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy6 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy2;
        Configuration x$2$proxy7 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy2;
        Configuration x$2$proxy8 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy2;
        Configuration x$2$proxy9 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy2;
        Configuration x$2$proxy10 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 $anonfun$2() {
        CipherLogic$Info$ cipherLogic$Info$ = CipherLogic$Info$.MODULE$;
        return (Function1 & Serializable)p -> (CipherLogic.Info)cipherLogic$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$5()));
    }

    private static final CipherLogic.Info $anonfun$4() {
        return CipherLogic$Info$.MODULE$.apply(CipherLogic$Info$.MODULE$.$lessinit$greater$default$1(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$2(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$3(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$4(), CipherLogic$Info$.MODULE$.$lessinit$greater$default$5());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item field$1, Panel.Item secretField$1, Panel.Item algorithm$1, Panel.Item ivField$1, Panel.Item result$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)field$1, (List)new .colon.colon((Object)secretField$1, (List)new .colon.colon((Object)algorithm$1, (List)new .colon.colon((Object)ivField$1, (List)new .colon.colon((Object)result$1, (List)Nil$.MODULE$))))));
    }

    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        DecoderNotDeriveSum f$proxy3;
        DecoderNotDeriveSum DecoderNotDeriveSum_this = f$proxy3 = new DecoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy11 = DecoderNotDeriveSum_this.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this2 = f$proxy3;
        Configuration x$2$proxy12 = DecoderNotDeriveSum_this2.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this3 = f$proxy3;
        Configuration x$2$proxy13 = DecoderNotDeriveSum_this3.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this4 = f$proxy3;
        Configuration x$2$proxy14 = DecoderNotDeriveSum_this4.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeString();
        DecoderNotDeriveSum DecoderNotDeriveSum_this5 = f$proxy3;
        Configuration x$2$proxy15 = DecoderNotDeriveSum_this5.io$circe$derivation$DecoderNotDeriveSum$$inline$x$1();
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        CipherLogic$Info$ cipherLogic$Info$ = CipherLogic$Info$.MODULE$;
        return (Function1 & Serializable)p -> (CipherLogic.Info)cipherLogic$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)CipherLogic$Info$.MODULE$.$lessinit$greater$default$5()));
    }

    private static final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        EncoderNotDeriveSum f$proxy4;
        EncoderNotDeriveSum EncoderNotDeriveSum_this = f$proxy4 = new EncoderNotDeriveSum(Configuration$.MODULE$.default());
        Configuration x$2$proxy16 = EncoderNotDeriveSum_this.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this2 = f$proxy4;
        Configuration x$2$proxy17 = EncoderNotDeriveSum_this2.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this3 = f$proxy4;
        Configuration x$2$proxy18 = EncoderNotDeriveSum_this3.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this4 = f$proxy4;
        Configuration x$2$proxy19 = EncoderNotDeriveSum_this4.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        EncoderNotDeriveSum EncoderNotDeriveSum_this5 = f$proxy4;
        Configuration x$2$proxy20 = EncoderNotDeriveSum_this5.io$circe$derivation$EncoderNotDeriveSum$$inline$config();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "field";
        String string2 = "secretField";
        String string3 = "algorithm";
        String string4 = "ivField";
        String string5 = "result";
        int size = 5;
        Either either = implicits$.MODULE$.catsSyntaxEither(MODULE$.InfoJson().deepMerge(results$1).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", CipherLogic$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), CipherLogic$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CipherLogic$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            CipherLogic.Info info2 = (CipherLogic.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "field";
            String string2 = "secretField";
            String string3 = "algorithm";
            String string4 = "ivField";
            String string5 = "result";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CipherLogic$::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string6 = step$1.copy$default$1();
            String string7 = step$1.copy$default$2();
            String string8 = step$1.copy$default$3();
            String string9 = step$1.copy$default$4();
            String string10 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string6, string7, string8, string9, string10, json, bl, bl2);
        });
    }

    private static final byte[] getSecretField$$anonfun$1(BsonString secret$2) {
        return Base64.decodeBase64((String)secret$2.getValue());
    }
}

