/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.number;

import ambience.etl.Builder;
import ambience.etl.Util$;
import ambience.etl.number.RetainOperation;
import ambience.etl.number.RetainOperation$;
import ambience.etl.package$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.MongoException;
import java.io.Serializable;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonNull$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.BaseDocument;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public abstract class PercentOperation
extends RetainOperation {
    private final int chunkSize;

    public PercentOperation() {
        this.chunkSize = 25000;
    }

    public int chunkSize() {
        return this.chunkSize;
    }

    @Override
    public String accumulator() {
        return "$sum";
    }

    public abstract BsonValue calculatePercentage(BsonValue var1, BsonValue var2);

    @Override
    public Observable<Document> run(Builder.Context cxt, RetainOperation.Info info, Observable<Document> from) {
        Observable observable;
        try {
            String colName = this.collectionName();
            RichMongoCollection col = new RichMongoCollection(RetainOperation$.MODULE$.tempDB().getCollection(colName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
            String aggName = this.aggCollectionName(colName);
            RichMongoCollection aggCollection = new RichMongoCollection(RetainOperation$.MODULE$.tempDB().getCollection(aggName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
            Observable output = this.insertToCol(col, from, info).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.buildAggregations(cxt, col, info, colName, aggName).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.fixValues(col, info).map((Function1 & Serializable)output -> output);
                });
            });
            observable = output.doOnComplete(col.dropT().flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return aggCollection.dropT().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            }));
        }
        catch (MongoException me) {
            Exception ex = this.handleMongoDBException(me);
            observable = Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply(String.valueOf(ex), (Throwable)ex))).flatMap((Function1 & Serializable)_$1 -> Observable$.MODULE$.raiseError((Throwable)ex));
        }
        catch (Exception ex) {
            observable = Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply(String.valueOf(ex), (Throwable)ex))).flatMap((Function1 & Serializable)_$2 -> Observable$.MODULE$.raiseError((Throwable)ex));
        }
        return observable;
    }

    public Observable<BoxedUnit> buildAggregations(Builder.Context cxt, RichMongoCollection col, RetainOperation.Info info, String colName, String aggName) {
        Observable result = Observable$.MODULE$.fromTask(col.aggregateO(this.buildGroupStep(info, this.aggCollectionName(colName))).toListL()).flatMap((Function1 & Serializable)x$12 -> {
            List list = x$12;
            return this.updatePercentValue(info, col, aggName).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            });
        });
        return result.onErrorHandleWith((Function1 & Serializable)x$1 -> {
            Throwable throwable = x$1;
            if (throwable instanceof MongoException) {
                MongoException me = (MongoException)throwable;
                Exception ex = this.handleMongoDBException(me);
                return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply(String.valueOf(ex), (Throwable)ex))).flatMap((Function1 & Serializable)_$3 -> Observable$.MODULE$.raiseError((Throwable)ex));
            }
            Throwable ex = throwable;
            throw ex;
        });
    }

    public Observable<Document> fixValues(RichMongoCollection col, RetainOperation.Info info) {
        String outField = (String)Util$.MODULE$.safeFieldName(info.output()).getOrElse(() -> PercentOperation.$anonfun$3(info));
        return col.findO().map((Function1 & Serializable)doc -> {
            BsonValue sum = doc.apply("elx-result-sum", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            BsonValue value = doc.apply(info.field(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
            return this.fixId((Document)((BaseDocument)doc.filter((Function1 & Serializable)_$4 -> {
                Object object = _$4._1();
                String string = "elx-result-sum";
                return object == null ? string != null : !object.equals(string);
            })).updated(outField, (Object)this.calculatePercentage(sum, value), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue()));
        });
    }

    @Override
    public Seq<Document> buildGroupStep(RetainOperation.Info info, String aggCollectionName) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)info.field());
        Object[] objectArray3 = new BsonMagnets.CanBeBsonElement[1];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"$ne");
        objectArray3[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonNull$.MODULE$.apply()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray3))), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
        Document m = package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        Document document = this.buildGroup(info.group(), info.field());
        Document document2 = this.buildOut(aggCollectionName);
        return scala.package$.MODULE$.Nil().$colon$colon((Object)document2).$colon$colon((Object)document).$colon$colon((Object)m);
    }

    public Observable<BoxedUnit> updatePercentValue(RetainOperation.Info info, RichMongoCollection col, String aggName) {
        RichMongoCollection aggCollection = new RichMongoCollection(RetainOperation$.MODULE$.tempDB().getCollection(aggName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        return Observable$.MODULE$.fromTask(aggCollection.findO().mapEval((Function1 & Serializable)doc -> {
            Bson f = Filters$.MODULE$.equal(info.group(), (Object)doc.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)));
            Bson u = Updates$.MODULE$.set("elx-result-sum", (Object)doc.apply("result", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class)));
            return col.updateManyT(f, u);
        }).toListL().map((Function1)(JProcedure1 & Serializable)_$5 -> {}));
    }

    private static final String $anonfun$3(RetainOperation.Info info$4) {
        return info$4.field();
    }
}

