/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.mqtt;

import ambience.etl.mqtt.MongoPersistence$MongoPersistable$;
import ambience.module.ProjectConfig;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Enumeration;
import monix.execution.Scheduler$;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttPersistable;
import org.eclipse.paho.client.mqttv3.MqttPersistenceException;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MongoPersistence
implements MqttClientPersistence,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MongoPersistence.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoPersistence.class.getDeclaredField("invocations$lzy1"));
    private volatile Object log$lzy1;
    private final String databaseName;
    private final MongoDatabase database;
    private volatile Object invocations$lzy1;
    private Option<RichMongoCollection> optCollection;

    public MongoPersistence(ProjectConfig projectConfig, MongoDB mongoDB) {
        this.databaseName = projectConfig.MongoDatabase() + "-mqtt";
        this.database = mongoDB.mongoClient().getDatabase(this.databaseName());
        this.log().info(this::$init$$$anonfun$1, Line$.MODULE$.apply(38), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence"));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"when");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        this.waitFor((Future)this.invocations().insertOneT(Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).runToFuture(Scheduler$.MODULE$.global()));
        this.optCollection = None$.MODULE$;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public MongoDatabase database() {
        return this.database;
    }

    public RichMongoCollection invocations() {
        Object object = this.invocations$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.invocations$lzyINIT1();
    }

    private Object invocations$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.invocations$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.database().getCollection("Invocations", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.invocations$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public void open(String clientId, String serverURI) {
        this.log().info(() -> MongoPersistence.open$$anonfun$1(clientId, serverURI), Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.open"));
        String safeName = ("elx-" + clientId + "@" + serverURI).replace("$", "<dollar>");
        this.log().info(() -> MongoPersistence.open$$anonfun$2(safeName), Line$.MODULE$.apply(47), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.open"));
        this.optCollection = Some$.MODULE$.apply((Object)new RichMongoCollection(this.database().getCollection(safeName, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))));
    }

    public void close() {
    }

    public void put(String key, MqttPersistable persistable) {
        byte[] byArray;
        byte[] header;
        this.log().info(() -> MongoPersistence.put$$anonfun$1(key, persistable), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.put"));
        byte[] fullHeader = persistable.getHeaderBytes();
        byte[] fullPayload = persistable.getPayloadBytes();
        if (persistable.getHeaderOffset() == 0 && persistable.getHeaderLength() == fullHeader.length) {
            v0 = fullHeader;
        } else {
            byte[] bytes = new byte[persistable.getHeaderLength()];
            System.arraycopy(fullHeader, persistable.getHeaderOffset(), bytes, 0, bytes.length);
            v0 = header = bytes;
        }
        if (persistable.getPayloadOffset() == 0 && persistable.getPayloadLength() == fullPayload.length) {
            byArray = fullPayload;
        } else {
            byte[] bytes = new byte[persistable.getPayloadLength()];
            System.arraycopy(fullPayload, persistable.getPayloadOffset(), bytes, 0, bytes.length);
            byArray = bytes;
        }
        byte[] payload = byArray;
        this.optCollection.foreach((Function1)(JProcedure1 & Serializable)cltn -> {
            ReplaceOptions options = new ReplaceOptions();
            options.upsert(true);
            BsonString id = BsonString$.MODULE$.apply(key);
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"header");
            objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonBinary$.MODULE$.apply(header)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"payload");
            objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonBinary$.MODULE$.apply(payload)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            Document doc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            UpdateResult data = (UpdateResult)this.waitFor((Future)cltn.replaceOneT(Filters$.MODULE$.eq("_id", (Object)id), doc, options).runToFuture(Scheduler$.MODULE$.global()));
            this.log().info(() -> MongoPersistence.put$$anonfun$2$$anonfun$1(data), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.put"));
        });
    }

    public MqttPersistable get(String key) {
        this.log().info(() -> MongoPersistence.get$$anonfun$1(key), Line$.MODULE$.apply(84), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.get"));
        Option<RichMongoCollection> option = this.optCollection;
        if (option instanceof Some) {
            RichMongoCollection cltn = (RichMongoCollection)((Some)option).value();
            return (MongoPersistable)((Option)this.waitFor((Future)cltn.findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(key))).firstOptionL().runToFuture(Scheduler$.MODULE$.global()))).flatMap((Function1 & Serializable)doc -> doc.get("header", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$1 -> _$1.getData()).flatMap((Function1 & Serializable)header -> doc.get("payload", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$2 -> _$2.getData()).map((Function1 & Serializable)payload -> MongoPersistence$MongoPersistable$.MODULE$.apply((byte[])header, (byte[])payload)))).getOrElse(MongoPersistence::get$$anonfun$3);
        }
        if (None$.MODULE$.equals(option)) {
            throw new MqttPersistenceException();
        }
        throw new MatchError(option);
    }

    public void remove(String key) {
        this.log().info(() -> MongoPersistence.remove$$anonfun$1(key), Line$.MODULE$.apply(100), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.remove"));
        this.optCollection.foreach((Function1 & Serializable)cltn -> (DeleteResult)this.waitFor((Future)cltn.deleteOneT(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(key))).runToFuture(Scheduler$.MODULE$.global())));
    }

    public Enumeration<?> keys() {
        Nil$ nil$;
        Option<RichMongoCollection> option = this.optCollection;
        if (option instanceof Some) {
            RichMongoCollection cltn = (RichMongoCollection)((Some)option).value();
            nil$ = (List)this.waitFor((Future)cltn.findO().toListL().runToFuture(Scheduler$.MODULE$.global()));
        } else if (None$.MODULE$.equals(option)) {
            nil$ = package$.MODULE$.Nil();
        } else {
            throw new MatchError(option);
        }
        Nil$ list = nil$;
        List keys = list.flatMap((Function1 & Serializable)doc -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)_$3 -> _$3.getValue());
        this.log().info(() -> MongoPersistence.keys$$anonfun$1(keys), Line$.MODULE$.apply(112), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.keys"));
        return new ItToEnum(keys.iterator());
    }

    public void clear() {
        this.log().info(MongoPersistence::clear$$anonfun$1, Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.clear"));
        this.optCollection.foreach((Function1)(JProcedure1 & Serializable)cltn -> this.waitFor((Future)cltn.dropT().runToFuture(Scheduler$.MODULE$.global())));
    }

    public boolean containsKey(String key) {
        Option<RichMongoCollection> option = this.optCollection;
        if (option instanceof Some) {
            RichMongoCollection cltn = (RichMongoCollection)((Some)option).value();
            return BoxesRunTime.unboxToBoolean(this.waitFor((Future)cltn.findO(Filters$.MODULE$.eq("_id", (Object)BsonString$.MODULE$.apply(key))).firstOptionL().map((Function1 & Serializable)_$4 -> _$4.nonEmpty()).runToFuture(Scheduler$.MODULE$.global())));
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public <T> T waitFor(Future<T> f) {
        Future ff = f.recoverWith((PartialFunction)new Serializable(this){
            private final /* synthetic */ MongoPersistence $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> MongoPersistence.ambience$etl$mqtt$MongoPersistence$$anon$1$$_$applyOrElse$$anonfun$1(ex), ex, Line$.MODULE$.apply(130), FullName$.MODULE$.apply("ambience.etl.mqtt.MongoPersistence.ff"));
                throw ex;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$etl$mqtt$MongoPersistence$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        }, (ExecutionContext)Scheduler$.MODULE$.global());
        return (T)Await$.MODULE$.result((Awaitable)ff, (Duration)FiniteDuration$.MODULE$.apply(10L, scala.concurrent.duration.package$.MODULE$.SECONDS()));
    }

    private final Object $init$$$anonfun$1() {
        return "Using database " + this.databaseName();
    }

    private static final Object open$$anonfun$1(String clientId$1, String serverURI$1) {
        return "Open " + clientId$1 + " " + serverURI$1;
    }

    private static final Object open$$anonfun$2(String safeName$1) {
        return "Using collection " + safeName$1;
    }

    private static final Object put$$anonfun$1(String key$1, MqttPersistable persistable$1) {
        return "put(" + key$1 + ") header=" + persistable$1.getHeaderLength() + " bytes payload=" + persistable$1.getPayloadLength() + " bytes";
    }

    private static final Object put$$anonfun$2$$anonfun$1(UpdateResult data$1) {
        return "put result: matched=" + data$1.getMatchedCount() + " modified=" + data$1.getModifiedCount() + " upsertedId=" + data$1.getUpsertedId();
    }

    private static final Object get$$anonfun$1(String key$3) {
        return "get(" + key$3 + ")";
    }

    private static final MongoPersistable get$$anonfun$3() {
        throw new MqttPersistenceException();
    }

    private static final Object remove$$anonfun$1(String key$4) {
        return "remove(" + key$4 + ")";
    }

    private static final Object keys$$anonfun$1(List keys$1) {
        return "keys=" + keys$1.mkString(",");
    }

    private static final Object clear$$anonfun$1() {
        return "clear";
    }

    public static final Object ambience$etl$mqtt$MongoPersistence$$anon$1$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "Error: " + ex$1;
    }

    public static class ItToEnum<T>
    implements Enumeration<T> {
        private final Iterator<T> it;

        public ItToEnum(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public T nextElement() {
            return (T)this.it.next();
        }
    }

    public static final class MongoPersistable
    implements MqttPersistable,
    Product,
    Serializable {
        private final byte[] header;
        private final byte[] payload;

        public static MongoPersistable apply(byte[] byArray, byte[] byArray2) {
            return MongoPersistence$MongoPersistable$.MODULE$.apply(byArray, byArray2);
        }

        public static MongoPersistable fromProduct(Product product) {
            return MongoPersistence$MongoPersistable$.MODULE$.fromProduct(product);
        }

        public static MongoPersistable unapply(MongoPersistable mongoPersistable) {
            return MongoPersistence$MongoPersistable$.MODULE$.unapply(mongoPersistable);
        }

        public MongoPersistable(byte[] header, byte[] payload) {
            this.header = header;
            this.payload = payload;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MongoPersistable)) return false;
            MongoPersistable mongoPersistable = (MongoPersistable)object;
            if (this.header() != mongoPersistable.header()) return false;
            if (this.payload() != mongoPersistable.payload()) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MongoPersistable;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "MongoPersistable";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "header";
            }
            if (1 == n2) {
                return "payload";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public byte[] header() {
            return this.header;
        }

        public byte[] payload() {
            return this.payload;
        }

        public byte[] getHeaderBytes() {
            return this.header();
        }

        public int getHeaderLength() {
            return this.header().length;
        }

        public int getHeaderOffset() {
            return 0;
        }

        public byte[] getPayloadBytes() {
            return this.payload();
        }

        public int getPayloadLength() {
            return this.payload().length;
        }

        public int getPayloadOffset() {
            return 0;
        }

        public MongoPersistable copy(byte[] header, byte[] payload) {
            return new MongoPersistable(header, payload);
        }

        public byte[] copy$default$1() {
            return this.header();
        }

        public byte[] copy$default$2() {
            return this.payload();
        }

        public byte[] _1() {
            return this.header();
        }

        public byte[] _2() {
            return this.payload();
        }
    }
}

