/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.mqtt.daemon;

import ambience.etl.Builder;
import ambience.etl.mqtt.MongoPersistence;
import ambience.etl.mqtt.daemon.DaemonMQTTReader;
import ambience.etl.mqtt.daemon.MQTTLogger;
import ambience.module.ProjectConfig;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import org.eclipse.paho.client.mqttv3.IMqttActionListener;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttAsyncClient;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MQTTClient
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MQTTClient.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public final DaemonMQTTReader.Info ambience$etl$mqtt$daemon$MQTTClient$$info;
    public final String ambience$etl$mqtt$daemon$MQTTClient$$clientId;
    private final MqttCallback callback;
    private final String id;
    private final MQTTLogger logger;
    private final MqttAsyncClient client;
    private final IMqttActionListener connectionListener;

    public MQTTClient(DaemonMQTTReader.Info info, Builder.Context cxt, String clientId, MqttCallback callback) {
        this.ambience$etl$mqtt$daemon$MQTTClient$$info = info;
        this.ambience$etl$mqtt$daemon$MQTTClient$$clientId = clientId;
        this.callback = callback;
        this.id = clientId;
        this.logger = new MQTTLogger(cxt);
        this.client = this.buildClient();
        this.client.setCallback(callback);
        this.connectionListener = new IMqttActionListener(this){
            private final /* synthetic */ MQTTClient $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void onSuccess(IMqttToken asyncActionToken) {
                this.$outer.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("Connected id=" + this.$outer.id() + " clientId=" + this.$outer.ambience$etl$mqtt$daemon$MQTTClient$$clientId + " QOS=" + this.$outer.ambience$etl$mqtt$daemon$MQTTClient$$info.qos() + " hasSession=" + asyncActionToken.getSessionPresent()));
            }

            public void onFailure(IMqttToken asyncActionToken, Throwable exception) {
                this.$outer.logger().log((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Connection failure", exception));
            }
        };
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String id() {
        return this.id;
    }

    public MQTTLogger logger() {
        return this.logger;
    }

    public IMqttActionListener connectionListener() {
        return this.connectionListener;
    }

    public void connect() {
        try {
            this.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("Connecting to " + this.ambience$etl$mqtt$daemon$MQTTClient$$info.broker()));
            MqttConnectOptions connOpts = new MqttConnectOptions();
            connOpts.setCleanSession(false);
            this.client.connect(connOpts, (Object)"context", this.connectionListener()).waitForCompletion();
            this.client.subscribe(this.ambience$etl$mqtt$daemon$MQTTClient$$info.topic(), this.ambience$etl$mqtt$daemon$MQTTClient$$info.qos());
            this.log().info(this::connect$$anonfun$1, Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTClient.connect"));
        }
        catch (Throwable ex) {
            this.log().error(() -> this.connect$$anonfun$2(ex), Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTClient.connect"));
            this.callback.connectionLost(ex);
        }
    }

    public void disconnect() {
        try {
            if (this.client.isConnected()) {
                this.client.disconnect().waitForCompletion();
                this.log().info(this::disconnect$$anonfun$1, Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTClient.disconnect"));
                this.client.close();
            }
        }
        catch (Throwable ex) {
            this.log().error(() -> MQTTClient.disconnect$$anonfun$2(ex), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTClient.disconnect"));
            throw new Exception("disconnect error:", ex);
        }
    }

    public void messageArrivedComplete(int messageId, int qos) {
        this.client.messageArrivedComplete(messageId, qos);
    }

    private MqttAsyncClient buildClient() {
        MqttAsyncClient mqttAsyncClient;
        try {
            ProjectConfig projectConfig = (ProjectConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ProjectConfig.class));
            MongoDB mongoDB = (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
            MongoPersistence persistence = new MongoPersistence(projectConfig, mongoDB);
            MqttAsyncClient client = new MqttAsyncClient(this.ambience$etl$mqtt$daemon$MQTTClient$$info.broker(), this.ambience$etl$mqtt$daemon$MQTTClient$$clientId, (MqttClientPersistence)persistence);
            client.setManualAcks(true);
            mqttAsyncClient = client;
        }
        catch (Throwable ex) {
            this.log().error(() -> MQTTClient.buildClient$$anonfun$1(ex), Line$.MODULE$.apply(80), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTClient.buildClient"));
            throw ex;
        }
        return mqttAsyncClient;
    }

    private final Object connect$$anonfun$1() {
        return "connected id:" + this.id();
    }

    private final Object connect$$anonfun$2(Throwable ex$1) {
        return "connected error id:" + this.id() + " connected:" + this.client.isConnected() + ": " + ex$1;
    }

    private final Object disconnect$$anonfun$1() {
        return "client disconnect id=" + this.id();
    }

    private static final Object disconnect$$anonfun$2(Throwable ex$2) {
        return "disconnect error: " + ex$2;
    }

    private static final Object buildClient$$anonfun$1(Throwable ex$3) {
        return "buildClient error: " + ex$3;
    }
}

