/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.mqtt.daemon;

import ambience.SystemScheduler$;
import ambience.etl.Builder;
import ambience.etl.mqtt.daemon.DaemonMQTTReader;
import ambience.etl.mqtt.daemon.MQTTClient;
import ambience.etl.mqtt.daemon.MQTTLogger;
import ambience.etl.package$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import java.util.UUID;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.reactive.Observable;
import monix.reactive.OverflowStrategy;
import monix.reactive.observers.Subscriber;
import monix.reactive.subjects.ConcurrentSubject;
import monix.reactive.subjects.ConcurrentSubject$;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class MQTTSubject
extends Observable<Document>
implements MqttCallback,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MQTTSubject.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MQTTSubject.class.getDeclaredField("clientId$lzy1"));
    private volatile Object log$lzy1;
    private final Builder.Context cxt;
    private final DaemonMQTTReader.Info info;
    private volatile Object clientId$lzy1;
    private final ConcurrentSubject<Document, Document> underlying;
    private Subscriber<Document> subscriber;
    private Cancelable cancelable;
    private Option<MQTTClient> client;
    private final MQTTLogger logger;

    public MQTTSubject(Builder.Context cxt, DaemonMQTTReader.Info info) {
        this.cxt = cxt;
        this.info = info;
        this.underlying = ConcurrentSubject$.MODULE$.replay((Seq)scala.package$.MODULE$.Nil(), (OverflowStrategy.Synchronous)OverflowStrategy.Unbounded$.MODULE$, SystemScheduler$.MODULE$.global());
        this.client = None$.MODULE$;
        this.logger = new MQTTLogger(cxt);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String clientId() {
        Object object = this.clientId$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.clientId$lzyINIT1();
    }

    private Object clientId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clientId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = (String)this.cxt.get("elx-daemonId").map((Function1 & Serializable)_$1 -> _$1.asString().getValue()).getOrElse(MQTTSubject::clientId$lzyINIT1$$anonfun$2);
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clientId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public MQTTLogger logger() {
        return this.logger;
    }

    public void connect() {
        this.client = Some$.MODULE$.apply((Object)this.buildClient());
        this.log().info(this::connect$$anonfun$1, Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTSubject.connect"));
        this.client.foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.connect());
        this.cancelable = this.underlying.unsafeSubscribeFn(this.subscriber);
    }

    public void disconnect() {
        this.client.foreach((Function1)(JProcedure1 & Serializable)_$6 -> _$6.disconnect());
    }

    public void messageArrivedComplete(int messageId, int qos) {
        this.client.foreach((Function1)(JProcedure1 & Serializable)_$7 -> _$7.messageArrivedComplete(messageId, qos));
    }

    public Cancelable unsafeSubscribeFn(Subscriber<Document> subscriber) {
        this.subscriber = subscriber;
        return Cancelable$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Option$.MODULE$.apply((Object)this.cancelable).foreach((Function1)(JProcedure1 & Serializable)_$8 -> _$8.cancel());
            this.disconnect();
        });
    }

    public void messageArrived(String topic, MqttMessage message) {
        MQTTSubject mQTTSubject = this;
        synchronized (mQTTSubject) {
            this.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("Message arrived " + message.getId()));
            this.log().info(() -> MQTTSubject.messageArrived$$anonfun$1(message), Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.etl.mqtt.daemon.MQTTSubject.messageArrived"));
            this.underlying.onNext((Object)this.buildDocument(topic, message));
        }
    }

    public void connectionLost(Throwable cause) {
        this.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("connectionLost called " + cause));
        this.subscriber.onError(cause);
    }

    public void deliveryComplete(IMqttDeliveryToken token) {
        this.logger().log((LogMessage)LogMessage.Info$.MODULE$.apply("deliveryComplete id:" + token.getMessageId()));
    }

    public MQTTClient buildClient() {
        return new MQTTClient(this.info, this.cxt, this.clientId(), this);
    }

    public Document buildDocument(String topic, MqttMessage message) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBinary$.MODULE$.apply(message.getPayload())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"topic");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(topic)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msgQos");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt32$.MODULE$.apply(message.getQos())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msgId");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonInt32$.MODULE$.apply(message.getId())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final String clientId$lzyINIT1$$anonfun$2() {
        return UUID.randomUUID().toString();
    }

    private final Object connect$$anonfun$1() {
        return "Connecting to client id:" + this.client.map((Function1 & Serializable)_$4 -> _$4.id());
    }

    private static final Object messageArrived$$anonfun$1(MqttMessage message$1) {
        return "messageArrived: " + message$1.getId();
    }
}

