/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.arch.job;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.job.JobAuthentication;
import com.elixirtech.arch.job.JobByteCount;
import com.elixirtech.arch.job.JobCancelled;
import com.elixirtech.arch.job.JobDebug;
import com.elixirtech.arch.job.JobDescription;
import com.elixirtech.arch.job.JobEnded;
import com.elixirtech.arch.job.JobEntry;
import com.elixirtech.arch.job.JobError;
import com.elixirtech.arch.job.JobException;
import com.elixirtech.arch.job.JobInfo;
import com.elixirtech.arch.job.JobLog;
import com.elixirtech.arch.job.JobLog$;
import com.elixirtech.arch.job.JobMimeType;
import com.elixirtech.arch.job.JobPageCount;
import com.elixirtech.arch.job.JobProgress;
import com.elixirtech.arch.job.JobReceived;
import com.elixirtech.arch.job.JobRecordCount;
import com.elixirtech.arch.job.JobReference;
import com.elixirtech.arch.job.JobResult;
import com.elixirtech.arch.job.JobResultUnzipped;
import com.elixirtech.arch.job.JobStarted;
import com.elixirtech.arch.job.JobTimeout;
import com.elixirtech.arch.job.JobUnableToComplete;
import com.elixirtech.arch.job.JobWarn;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.repository.RMLFileUtil$;
import java.io.Serializable;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.ShortTypeHints$;
import org.json4s.TypeHints;
import org.json4s.native.Document;
import org.json4s.native.JsonMethods$;
import org.json4s.native.JsonParser$;
import org.json4s.native.Printer$;
import org.json4s.native.Serialization$;
import scala.Char$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class JsonJobLogging$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JsonJobLogging$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final List jobStatusTypes;
    private static final List jobLogTypes;
    private static final List jobResultTypes;
    private static final List allJobEntryTypes;
    private static final Object formats;
    public static final JsonJobLogging$ MODULE$;

    private JsonJobLogging$() {
    }

    static {
        MODULE$ = new JsonJobLogging$();
        jobStatusTypes = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Class[]{JobReceived.class, JobAuthentication.class, JobStarted.class, JobDescription.class, JobReference.class, JobProgress.class, JobCancelled.class, JobTimeout.class, JobUnableToComplete.class, JobEnded.class, JobException.class}));
        jobLogTypes = (List)new .colon.colon(JobDebug.class, (List)new .colon.colon(JobInfo.class, (List)new .colon.colon(JobWarn.class, (List)new .colon.colon(JobError.class, (List)Nil$.MODULE$))));
        jobResultTypes = (List)new .colon.colon(JobResult.class, (List)new .colon.colon(JobResultUnzipped.class, (List)new .colon.colon(JobPageCount.class, (List)new .colon.colon(JobRecordCount.class, (List)new .colon.colon(JobByteCount.class, (List)new .colon.colon(JobMimeType.class, (List)Nil$.MODULE$))))));
        allJobEntryTypes = MODULE$.jobResultTypes().$colon$colon$colon(MODULE$.jobLogTypes()).$colon$colon$colon(MODULE$.jobStatusTypes());
        formats = Serialization$.MODULE$.formats((TypeHints)ShortTypeHints$.MODULE$.apply(MODULE$.allJobEntryTypes(), ShortTypeHints$.MODULE$.$lessinit$greater$default$2()));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JsonJobLogging$.class);
    }

    public List<Class<?>> jobStatusTypes() {
        return jobStatusTypes;
    }

    public List<Class<?>> jobLogTypes() {
        return jobLogTypes;
    }

    public List<Class<?>> jobResultTypes() {
        return jobResultTypes;
    }

    public List<Class<?>> allJobEntryTypes() {
        return allJobEntryTypes;
    }

    public Object formats() {
        return formats;
    }

    public String toJson(JobEntry entry) {
        JobEntry jobEntry = entry;
        if (jobEntry instanceof JobReceived) {
            JobReceived e = (JobReceived)jobEntry;
            return "{\"jsonClass\":\"JobReceived\"," + this.quote("engine", e.engine()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobStarted) {
            JobStarted e = (JobStarted)jobEntry;
            return "{\"jsonClass\":\"JobStarted\",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobDescription) {
            JobDescription e = (JobDescription)jobEntry;
            return "{\"jsonClass\":\"JobDescription\"," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobReference) {
            JobReference e = (JobReference)jobEntry;
            return "{\"jsonClass\":\"JobReference\"," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobProgress) {
            JobProgress e = (JobProgress)jobEntry;
            return "{\"jsonClass\":\"JobProgress\"," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobCancelled) {
            JobCancelled e = (JobCancelled)jobEntry;
            return "{\"jsonClass\":\"JobCancelled\",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobTimeout) {
            JobTimeout e = (JobTimeout)jobEntry;
            return "{\"jsonClass\":\"JobTimeout\",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobUnableToComplete) {
            JobUnableToComplete e = (JobUnableToComplete)jobEntry;
            return "{\"jsonClass\":\"JobUnableToComplete\"," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobEnded) {
            JobEnded e = (JobEnded)jobEntry;
            return "{\"jsonClass\":\"JobEnded\",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobResult) {
            JobResult e = (JobResult)jobEntry;
            return "{\"jsonClass\":\"JobResult\"," + this.quote("location", e.location()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobResultUnzipped) {
            JobResultUnzipped e = (JobResultUnzipped)jobEntry;
            return "{\"jsonClass\":\"JobResultUnzipped\"," + this.quote("location", e.location()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobMimeType) {
            JobMimeType e = (JobMimeType)jobEntry;
            return "{\"jsonClass\":\"JobMimeType\",\"mimeType\":{" + this.quote("value", e.mimeType().value()) + "},\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobPageCount) {
            JobPageCount e = (JobPageCount)jobEntry;
            return "{\"jsonClass\":\"JobPageCount\",\"pages\":" + e.pages() + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobRecordCount) {
            JobRecordCount e = (JobRecordCount)jobEntry;
            return "{\"jsonClass\":\"JobRecordCount\",\"records\":" + e.records() + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobByteCount) {
            JobByteCount e = (JobByteCount)jobEntry;
            return "{\"jsonClass\":\"JobByteCount\",\"bytes\":" + e.bytes() + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobDebug) {
            JobDebug e = (JobDebug)jobEntry;
            return "{\"jsonClass\":\"JobDebug\"," + this.quote("category", e.category()) + "," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobInfo) {
            JobInfo e = (JobInfo)jobEntry;
            return "{\"jsonClass\":\"JobInfo\"," + this.quote("category", e.category()) + "," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        if (jobEntry instanceof JobWarn) {
            JobWarn e = (JobWarn)jobEntry;
            return "{\"jsonClass\":\"JobWarn\"," + this.quote("category", e.category()) + "," + this.quote("text", e.text()) + ",\"timestamp\":" + e.timestamp() + "}";
        }
        JValue json = Extraction$.MODULE$.decompose((Object)entry, (Formats)this.formats());
        Document doc = JsonMethods$.MODULE$.render(json, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3());
        return Printer$.MODULE$.compact(doc);
    }

    public final String quote(String name, String value) {
        StringBuilder buf = new StringBuilder();
        buf.append('\"');
        buf.append(name);
        buf.append('\"');
        buf.append(':');
        buf.append('\"');
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c;
            char c2 = c = value.charAt(i);
            buf.append(switch (c2) {
                case '\"' -> "\\\"";
                case '\\' -> "\\\\";
                case '\b' -> "\\b";
                case '\f' -> "\\f";
                case '\n' -> "\\n";
                case '\r' -> "\\r";
                case '\t' -> "\\t";
                default -> {
                    char c = c2;
                    if (c >= '\u0000' && c < '\u001f' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        yield StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)Char$.MODULE$.char2int(c))}));
                    }
                    char c = c2;
                    yield BoxesRunTime.boxToCharacter((char)c);
                }
            });
        }
        buf.append('\"');
        return buf.toString();
    }

    public String toJson(Seq<JobEntry> entries) {
        JValue json = Extraction$.MODULE$.decompose(entries, (Formats)this.formats());
        Document doc = JsonMethods$.MODULE$.render(json, JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3());
        return Printer$.MODULE$.compact(doc);
    }

    public JobLog fromFile(RMLFileObject fo) {
        return JobLog$.MODULE$.apply(this.jobEntries(RMLFileUtil$.MODULE$.getString(fo)));
    }

    public JobEntry jobEntry(String json) {
        return (JobEntry)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(JsonParser$.MODULE$.parse(json)), (Formats)this.formats(), ManifestFactory$.MODULE$.classType(JobEntry.class));
    }

    public List<JobEntry> jobEntries(String json) {
        return (List)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(JsonParser$.MODULE$.parse(json)), (Formats)this.formats(), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(JobEntry.class), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
    }
}

