/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.awt;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.awt.ITextHolder;
import com.elixirtech.awt.KeyTool;
import com.elixirtech.awt.Text;
import com.elixirtech.awt.TextBlock;
import com.elixirtech.canvas.geometry.RectangleEx;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;

public final class MultiLineStringEditor
extends KeyTool {
    boolean m_Selected;
    Component m_Component;
    Point m_Point;
    ITextHolder m_TextHolder;
    String m_OriginalString;
    StringBuffer m_StringBuffer;
    TextBlock m_TextBlock;
    RectangleEx m_Rect;
    int m_Down;
    int m_Up;
    int m_Align;
    static final int GAP = 5;
    static final int SHADOW = 3;
    static final int LEFTINSET = 2;
    static final int TOPINSET = 2;
    static final int RIGHTINSET = 6;
    static final int BOTTOMINSET = 4;
    static final int MIN_CHAR = 28;

    public MultiLineStringEditor(Component component, Point point, ITextHolder iTextHolder, int n) {
        this.m_Component = component;
        this.m_Point = point;
        this.m_Rect = new RectangleEx(point);
        this.m_TextHolder = iTextHolder;
        this.m_OriginalString = this.m_TextHolder.getText();
        this.m_StringBuffer = new StringBuffer();
        if (this.m_OriginalString != null) {
            this.m_StringBuffer.append(this.m_OriginalString);
        }
        this.m_Align = n;
        this.m_Down = 0;
        this.m_Up = this.m_StringBuffer.length();
        this.buildRect();
        Graphics graphics = this.m_Component.getGraphics();
        this.draw(graphics);
        graphics.dispose();
        this.assertValid();
    }

    @Override
    public void gotFocus() {
        this.m_Selected = true;
    }

    @Override
    public void lostFocus() {
        this.m_Selected = false;
    }

    public RectangleEx getPaintRect() {
        return this.m_Rect;
    }

    public void setPoint(Point point) {
        if (this.m_Point.x == point.x && this.m_Point.y == point.y) {
            return;
        }
        int n = point.x - this.m_Point.x;
        int n2 = point.y - this.m_Point.y;
        this.m_Point.x = point.x;
        this.m_Point.y = point.y;
        this.m_Rect.move(n, n2);
    }

    public void selDown(Point point) {
        int n = this.indexFromPixelPoint(point);
        if (n != this.m_Down || n != this.m_Up) {
            this.m_Up = this.m_Down = n;
            this.updateDisplay();
            this.assertValid();
        }
    }

    public void selUp(Point point) {
        int n = this.indexFromPixelPoint(point);
        if (n != this.m_Up) {
            this.m_Up = n;
            this.updateDisplay();
            this.assertValid();
        }
    }

    public void selAll() {
        this.m_Down = 0;
        this.m_Up = this.m_StringBuffer.length();
        this.updateDisplay();
        this.assertValid();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        switch (n) {
            case 37: {
                if (this.m_Up > 0) {
                    --this.m_Up;
                }
                if (!keyEvent.isShiftDown()) {
                    this.m_Down = this.m_Up;
                }
                this.updateDisplay();
                break;
            }
            case 39: {
                if (this.m_Up < this.m_StringBuffer.length()) {
                    ++this.m_Up;
                }
                if (!keyEvent.isShiftDown()) {
                    this.m_Down = this.m_Up;
                }
                this.updateDisplay();
                break;
            }
            case 38: {
                Point point = this.pixelPointFromIndex(this.m_Up);
                point.y -= this.m_TextBlock.fontHeight();
                int n2 = this.indexFromPixelPoint(point);
                if (n2 < 0) break;
                this.m_Up = n2;
                if (!keyEvent.isShiftDown()) {
                    this.m_Down = this.m_Up;
                }
                this.updateDisplay();
                break;
            }
            case 40: {
                Point point = this.pixelPointFromIndex(this.m_Up);
                point.y += this.m_TextBlock.fontHeight();
                int n3 = this.indexFromPixelPoint(point);
                if (n3 < 0) break;
                this.m_Up = n3;
                if (!keyEvent.isShiftDown()) {
                    this.m_Down = this.m_Up;
                }
                this.updateDisplay();
                break;
            }
            case 36: {
                this.m_Up = 0;
                if (!keyEvent.isShiftDown()) {
                    this.m_Down = this.m_Up;
                }
                this.updateDisplay();
                break;
            }
            case 35: {
                this.m_Up = this.m_StringBuffer.length();
                if (!keyEvent.isShiftDown()) {
                    this.m_Down = this.m_Up;
                }
                this.updateDisplay();
                break;
            }
            case 8: {
                if (this.m_Up == this.m_Down) {
                    if (this.m_Up == 0) {
                        return;
                    }
                    --this.m_Up;
                }
                String string = this.getBeginString();
                String string2 = this.getEndString();
                this.m_StringBuffer = new StringBuffer();
                this.m_StringBuffer.append(string);
                this.m_StringBuffer.append(string2);
                this.m_Down = this.m_Up = string.length();
                this.buildRect();
                this.updateDisplay();
                break;
            }
            case 127: {
                if (keyEvent.isShiftDown()) {
                    this.copyToClipboard();
                }
                if (this.m_Up == this.m_Down) {
                    if (this.m_Up == this.m_StringBuffer.length()) break;
                    ++this.m_Up;
                }
                String string = this.getBeginString();
                String string3 = this.getEndString();
                this.m_StringBuffer = new StringBuffer();
                this.m_StringBuffer.append(string);
                this.m_StringBuffer.append(string3);
                this.m_Down = this.m_Up = string.length();
                this.buildRect();
                this.updateDisplay();
                break;
            }
            case 27: {
                this.m_StringBuffer = new StringBuffer();
                if (this.m_OriginalString != null) {
                    this.m_StringBuffer.append(this.m_OriginalString);
                }
                this.m_Down = 0;
                this.m_Up = this.m_StringBuffer.length();
                this.buildRect();
                this.updateDisplay();
                break;
            }
            case 10: {
                String string = this.getBeginString();
                String string4 = this.getEndString();
                this.m_StringBuffer = new StringBuffer();
                this.m_StringBuffer.append(string);
                this.m_StringBuffer.append('\n');
                this.m_StringBuffer.append(string4);
                this.m_Down = this.m_Up = string.length() + 1;
                this.buildRect();
                this.updateDisplay();
                break;
            }
            case 155: {
                if (keyEvent.isShiftDown()) {
                    this.pasteFromClipboard();
                }
                if (!keyEvent.isControlDown()) break;
                this.copyToClipboard();
            }
        }
        this.assertValid();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (!this.acceptChar(c)) {
            return;
        }
        if (this.m_Down != this.m_Up) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getBeginString());
            stringBuffer.append(this.getEndString());
            this.m_StringBuffer = stringBuffer;
            this.m_Up = Math.min(this.m_Down, this.m_Up);
        }
        this.m_StringBuffer.insert(this.m_Up, c);
        ++this.m_Up;
        this.m_Down = this.m_Up;
        this.buildRect();
        this.updateDisplay();
        this.assertValid();
    }

    public void draw(Graphics graphics) {
        if (!this.m_Selected) {
            this.drawOutline(graphics);
        } else {
            this.drawEditor(graphics);
        }
    }

    boolean acceptChar(char c) {
        return c >= '\u001c';
    }

    void drawOutline(Graphics graphics) {
        graphics.setColor(Color.lightGray);
        graphics.drawRect(this.m_Rect.left, this.m_Rect.top, this.m_Rect.width() - 3, this.m_Rect.height() - 3);
    }

    void drawEditor(Graphics graphics) {
        RectangleEx rectangleEx = (RectangleEx)this.m_Rect.clone();
        graphics.setColor(Color.gray);
        graphics.fillRect(rectangleEx.left + 3, rectangleEx.top + 3, rectangleEx.width() - 3, rectangleEx.height() - 3);
        graphics.setColor(Color.white);
        graphics.fillRect(rectangleEx.left, rectangleEx.top, rectangleEx.width() - 3, rectangleEx.height() - 3);
        graphics.setColor(Color.black);
        graphics.drawRect(rectangleEx.left, rectangleEx.top, rectangleEx.width() - 3, rectangleEx.height() - 3);
        if (this.m_Align == 1) {
            this.m_TextBlock.drawCenter(graphics, this.m_Point);
        } else {
            this.m_TextBlock.drawTop(graphics, this.m_Point);
        }
        if (this.m_StringBuffer.length() == 0) {
            return;
        }
        if (this.m_Down == this.m_Up) {
            Point point = this.pixelPointFromIndex(this.m_Up);
            graphics.setColor(Color.blue);
            graphics.drawLine(point.x, point.y, point.x, point.y + this.m_TextBlock.fontHeight());
        } else {
            Point point = this.textPointFromIndex(this.selStart());
            Point point2 = this.textPointFromIndex(this.selStop());
            if (point.y == point2.y) {
                Text text = this.m_TextBlock.getLine(point.y);
                this.drawSelectedLine(graphics, text, point.x, point2.x);
            } else {
                Text text = this.m_TextBlock.getLine(point.y);
                this.drawSelectedLine(graphics, text, point.x, text.m_Text.length());
                for (int i = point.y + 1; i <= point2.y - 1; ++i) {
                    text = this.m_TextBlock.getLine(i);
                    this.drawSelectedLine(graphics, text, 0, text.m_Text.length());
                }
                text = this.m_TextBlock.getLine(point2.y);
                this.drawSelectedLine(graphics, text, 0, point2.x);
            }
        }
    }

    void drawSelectedLine(Graphics graphics, Text text, int n, int n2) {
        String string = text.m_Text;
        Point point = this.getTextOrigin();
        int n3 = point.y + text.m_StartPoint.y;
        int n4 = point.x + text.m_StartPoint.x + this.m_TextBlock.stringWidth(string.substring(0, n));
        int n5 = point.x + text.m_StartPoint.x + this.m_TextBlock.stringWidth(string.substring(0, n2));
        graphics.setColor(Color.blue);
        graphics.fillRect(n4, n3 - this.m_TextBlock.fontAscent(), n5 - n4, this.m_TextBlock.fontHeight());
        graphics.setColor(Color.white);
        String string2 = string.substring(n, n2);
        if (string2.length() > 0) {
            graphics.drawString(string2, n4, n3);
        }
    }

    Point getTextOrigin() {
        return new Point(this.m_Rect.left + 2, this.m_Rect.top + 2);
    }

    Point pixelPointFromIndex(int n) {
        Point point = this.textPointFromIndex(n);
        Text text = this.m_TextBlock.getLine(point.y);
        String string = text.m_Text;
        Point point2 = this.getTextOrigin();
        point2.y += this.m_TextBlock.fontHeight() * point.y;
        point2.x += text.m_StartPoint.x + this.m_TextBlock.stringWidth(string.substring(0, point.x));
        return point2;
    }

    int indexFromPixelPoint(Point point) {
        Point point2 = this.getTextOrigin();
        point.x -= point2.x;
        point.y -= point2.y;
        if (point.y < 0) {
            return 0;
        }
        int n = point.y / this.m_TextBlock.fontHeight();
        if (n >= this.m_TextBlock.getNoLines()) {
            return this.m_StringBuffer.length();
        }
        Text text = this.m_TextBlock.getLine(n);
        point.x -= text.m_StartPoint.x;
        int n2 = Text.getIndexFromPixelPos(text.m_Text, this.m_TextBlock, point.x);
        return this.indexFromTextPoint(new Point(n2, n));
    }

    Point textPointFromIndex(int n) {
        return this.m_TextBlock.getPos(n);
    }

    int indexFromTextPoint(Point point) {
        int n = 0;
        for (int i = 0; i < point.y; ++i) {
            n += this.m_TextBlock.getLine((int)i).m_Text.length() + 1;
        }
        return n += point.x;
    }

    void copyToClipboard() {
        if (this.m_Down != this.m_Up) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection stringSelection = new StringSelection(this.getSelectedString());
            clipboard.setContents(stringSelection, stringSelection);
        }
    }

    void pasteFromClipboard() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this);
        if (transferable != null) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.m_Down = this.selStart();
                this.m_Up = this.selStop();
                String string2 = this.getBeginString() + string + this.getEndString();
                this.m_Up = this.m_Down + string.length();
                this.m_StringBuffer = new StringBuffer(string2);
                this.buildRect();
                this.updateDisplay();
                this.assertValid();
            }
            catch (Exception exception) {
                ElxLoggerJ.getLogger(MultiLineStringEditor.class).warn((Object)("MultiLineStringEditor: Couldn't get clipboard contents in format: " + DataFlavor.stringFlavor.getHumanPresentableName()), (Throwable)exception);
            }
        }
    }

    protected String getString() {
        return this.m_StringBuffer.toString();
    }

    protected String getBeginString() {
        int n = Math.min(this.m_StringBuffer.length(), this.selStart());
        if (n == 0) {
            return "";
        }
        String string = this.m_StringBuffer.toString();
        String string2 = string.substring(0, n);
        return string2;
    }

    protected String getSelectedString() {
        if (this.m_Down == this.m_Up) {
            return "";
        }
        String string = this.m_StringBuffer.toString();
        String string2 = string.substring(this.selStart(), this.selStop());
        return string2;
    }

    protected String getEndString() {
        String string = this.m_StringBuffer.toString();
        int n = this.selStop();
        if (n >= string.length()) {
            return "";
        }
        return string.substring(n);
    }

    protected String getDisplayString() {
        return this.getString();
    }

    protected void updateDisplay() {
        this.m_TextHolder.setText(this.getString());
        Graphics graphics = this.m_Component.getGraphics();
        this.draw(graphics);
        graphics.dispose();
    }

    protected void invalidateRect() {
        Graphics2D graphics2D = (Graphics2D)this.m_Component.getGraphics();
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.dispose();
        Rectangle rectangle = new Rectangle(this.m_Rect.left, this.m_Rect.top, this.m_Rect.width(), this.m_Rect.height());
        Rectangle rectangle2 = affineTransform.createTransformedShape(rectangle).getBounds();
        this.m_Component.repaint(rectangle2.x - 1, rectangle2.y - 1, rectangle2.width + 1, rectangle2.height + 1);
    }

    protected void buildRect() {
        String string = this.getDisplayString();
        this.m_TextBlock = TextBlock.buildTextBlock(string);
        RectangleEx rectangleEx = this.m_Align == 1 ? this.m_TextBlock.getPaintRectCenter(this.m_Point) : this.m_TextBlock.getPaintRectTop(this.m_Point);
        if (rectangleEx.width() == 0) {
            rectangleEx.left -= 2;
            rectangleEx.right += 2;
        }
        rectangleEx.left -= 2;
        rectangleEx.top -= 2;
        rectangleEx.right += 6;
        rectangleEx.bottom += 4;
        if (this.m_Rect.left < rectangleEx.left || this.m_Rect.bottom > rectangleEx.bottom) {
            this.invalidateRect();
        }
        this.m_Rect = rectangleEx;
        this.assertValid();
    }

    protected int selStart() {
        return Math.min(this.m_Down, this.m_Up);
    }

    protected int selStop() {
        return Math.max(this.m_Down, this.m_Up);
    }

    void assertValid() {
        int n = this.m_StringBuffer.length();
        assert (this.m_Down >= 0);
        assert (this.m_Up >= 0);
        assert (this.m_Down <= n);
        assert (this.m_Up <= n);
    }
}

