/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode.strategy;

import com.dragontechnology.barcode.BarcodeElement;
import com.dragontechnology.barcode.BarcodeException;
import com.dragontechnology.barcode.BarcodeStrategy;
import com.dragontechnology.barcode.EncodedBarcode;
import com.elixirtech.arch.ElxLoggerJ;
import java.io.Serializable;
import java.util.ArrayList;

public class EAN13
implements BarcodeStrategy,
Serializable {
    public static final String[] RULE = new String[]{"OOOOOO", "OOEOEE", "OOEEOE", "OOEEEO", "OEOOEE", "OEEOOE", "OEEEOO", "OEOEOE", "OEOEEO", "OEEOEO"};
    public static final String[] LEFT_ODD = new String[]{"0001101", "0011001", "0010011", "0111101", "0100011", "0110001", "0101111", "0111011", "0110111", "0001011"};
    public static final String[] LEFT_EVEN = new String[]{"0100111", "0110011", "0011011", "0100001", "0011101", "0111001", "0000101", "0010001", "0001001", "0010111"};
    public static final String[] RIGHT = new String[]{"1110010", "1100110", "1101100", "1000010", "1011100", "1001110", "1010000", "1000100", "1001000", "1110100"};
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(EAN13.class);

    @Override
    public int requiresChecksum() {
        return 1;
    }

    protected String augmentWithChecksum(String object) throws BarcodeException {
        int n;
        int n2 = this.checksum((String)object);
        int n3 = ((String)object).length();
        if (n3 == (n = this.getCodeLength()) - 1) {
            object = (String)object + n2;
        } else if (n3 == n) {
            int n4 = ((String)object).charAt(n3 - 1) - 48;
            if (n2 != n4) {
                m_Log.warn((Object)("Invalid check digit: " + n4));
                throw new BarcodeException("Invalid check digit: " + n4);
            }
        } else {
            m_Log.warn((Object)("Invalid length: " + n3));
            throw new BarcodeException("Invalid length: " + n3);
        }
        return object;
    }

    protected int getCodeLength() {
        return 13;
    }

    public int checksum(String string) throws BarcodeException {
        int n = this.getCodeLength();
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n2 = 0;
        for (int i = n - 2; i >= 0; --i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                m_Log.warn((Object)("Invalid character: '" + c + "'"));
                throw new BarcodeException("Invalid character: '" + c + "'");
            }
            int n3 = c - 48;
            n2 += n3;
            if (bl) {
                n2 += n3;
                n2 += n3;
            }
            bl = !bl;
        }
        return n2 % 10 == 0 ? 0 : 10 - n2 % 10;
    }

    protected byte getMarginWidth() {
        return 11;
    }

    protected String getBarcodeLabelText(String string) {
        return string.substring(1);
    }

    protected void checkLength(String string) throws BarcodeException {
        if (string.length() != this.getCodeLength()) {
            m_Log.warn((Object)("Invalid length: " + string.length()));
            throw new BarcodeException("Invalid length: " + string.length());
        }
    }

    @Override
    public EncodedBarcode encode(String string, boolean bl) throws BarcodeException {
        int n;
        int n2 = string.length();
        if (n2 < (n = this.getCodeLength()) - 1) {
            throw new BarcodeException("Invalid length: " + n2);
        }
        if (bl) {
            string = this.augmentWithChecksum(string);
        }
        this.checkLength(string);
        ArrayList<BarcodeElement> arrayList = new ArrayList<BarcodeElement>();
        arrayList.add(this.be(this.getMarginWidth(), false));
        BarcodeElement[] barcodeElementArray = this.getLeftGuard();
        for (int i = 0; i < barcodeElementArray.length; ++i) {
            arrayList.add(barcodeElementArray[i]);
        }
        BarcodeElement[] barcodeElementArray2 = this.getLeft(string);
        for (int i = 0; i < barcodeElementArray2.length; ++i) {
            arrayList.add(barcodeElementArray2[i]);
        }
        BarcodeElement[] barcodeElementArray3 = this.getCentreGuard();
        for (int i = 0; i < barcodeElementArray3.length; ++i) {
            arrayList.add(barcodeElementArray3[i]);
        }
        BarcodeElement[] barcodeElementArray4 = this.getRight(string);
        for (int i = 0; i < barcodeElementArray4.length; ++i) {
            arrayList.add(barcodeElementArray4[i]);
        }
        BarcodeElement[] barcodeElementArray5 = this.getRightGuard();
        for (int i = 0; i < barcodeElementArray5.length; ++i) {
            arrayList.add(barcodeElementArray5[i]);
        }
        arrayList.add(this.be(this.getMarginWidth(), false));
        BarcodeElement[] barcodeElementArray6 = new BarcodeElement[arrayList.size()];
        arrayList.toArray(barcodeElementArray6);
        String string2 = this.getLeftLabel(string);
        String string3 = this.getCenterLabel(string);
        String string4 = this.getRightLabel(string);
        return new EncodedBarcode(barcodeElementArray6, string2, string3, string4);
    }

    protected BarcodeElement[] getLeftGuard() {
        return this.elements("101");
    }

    protected BarcodeElement[] getLeft(String string) {
        int n = string.charAt(0) - 48;
        String string2 = RULE[n];
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < 7; ++i) {
            n = string.charAt(i) - 48;
            if (string2.charAt(i - 1) == 'E') {
                stringBuffer.append(LEFT_EVEN[n]);
                continue;
            }
            stringBuffer.append(LEFT_ODD[n]);
        }
        return this.elements(stringBuffer.toString());
    }

    protected BarcodeElement[] getCentreGuard() {
        return this.elements("01010");
    }

    protected BarcodeElement[] getRight(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 7; i < 13; ++i) {
            int n = string.charAt(i) - 48;
            stringBuffer.append(RIGHT[n]);
        }
        return this.elements(stringBuffer.toString());
    }

    protected BarcodeElement[] getRightGuard() {
        return this.elements("101");
    }

    protected String getLeftLabel(String string) {
        return string.substring(0, 1);
    }

    protected String getCenterLabel(String string) {
        String string2 = string.substring(1);
        return string2.substring(0, 6) + " " + string2.substring(6);
    }

    protected String getRightLabel(String string) {
        return null;
    }

    protected BarcodeElement[] elements(String string) {
        ArrayList<BarcodeElement> arrayList = new ArrayList<BarcodeElement>();
        int n = string.length();
        BarcodeElement barcodeElement = this.be((byte)1, string.charAt(0) == '1');
        arrayList.add(barcodeElement);
        for (int i = 1; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = string.charAt(i) == '1';
            if (bl == barcodeElement.bar) {
                barcodeElement.width = (byte)(barcodeElement.width + 1);
                continue;
            }
            barcodeElement = this.be((byte)1, bl);
            arrayList.add(barcodeElement);
        }
        BarcodeElement[] barcodeElementArray = new BarcodeElement[arrayList.size()];
        arrayList.toArray(barcodeElementArray);
        return barcodeElementArray;
    }

    protected BarcodeElement be(byte by, boolean bl) {
        BarcodeElement barcodeElement = new BarcodeElement();
        barcodeElement.width = by;
        barcodeElement.bar = bl;
        return barcodeElement;
    }

    public static int testChecksum(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = 0;
        for (int i = cArray.length - 1; i >= 0; --i) {
            int n2 = cArray[i] - 48;
            n += n2;
            if (bl) {
                n += n2;
                n += n2;
            }
            bl = !bl;
        }
        return n % 10 == 0 ? 0 : 10 - n % 10;
    }
}

