/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.barcode.strategy;

import com.dragontechnology.barcode.BarcodeElement;
import com.dragontechnology.barcode.BarcodeException;
import com.dragontechnology.barcode.BarcodeStrategy;
import com.dragontechnology.barcode.EncodedBarcode;
import com.elixirtech.arch.ElxLoggerJ;
import java.io.Serializable;
import java.util.ArrayList;

public class UPCE
implements BarcodeStrategy,
Serializable {
    public static final String[] NS_0 = new String[]{"EEEOOO", "EEOEOO", "EEOOEO", "EEOOOE", "EOEEOO", "EOOEEO", "EOOOEE", "EOEOEO", "EOEOOE", "EOOEOE"};
    public static final String[] NS_1 = new String[]{"OOOEEE", "OOEOEE", "OOEEOE", "OOEEEO", "OEOOEE", "OEEOOE", "OEEEOO", "OEOEOE", "OEOEEO", "OEEOEO"};
    public static final String[] LEFT_ODD = new String[]{"0001101", "0011001", "0010011", "0111101", "0100011", "0110001", "0101111", "0111011", "0110111", "0001011"};
    public static final String[] LEFT_EVEN = new String[]{"0100111", "0110011", "0011011", "0100001", "0011101", "0111001", "0000101", "0010001", "0001001", "0010111"};
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(UPCE.class);

    @Override
    public int requiresChecksum() {
        return 1;
    }

    protected String augmentWithChecksum(String object) throws BarcodeException {
        int n;
        int n2 = this.checksum((String)object);
        int n3 = ((String)object).length();
        if (n3 == (n = this.getCodeLength()) - 1) {
            object = (String)object + n2;
        } else if (n3 == n) {
            int n4 = ((String)object).charAt(n3 - 1) - 48;
            if (n2 != n4) {
                m_Log.warn((Object)("Invalid check digit: " + n4));
                throw new BarcodeException("Invalid check digit: " + n4);
            }
        } else {
            m_Log.warn((Object)("Invalid length: " + n3));
            throw new BarcodeException("Invalid length: " + n3);
        }
        return object;
    }

    public int checksum(String string) throws BarcodeException {
        int n = this.getCodeLength();
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n2 = 0;
        for (int i = n - 2; i >= 0; --i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                m_Log.warn((Object)("Invalid character: '" + c + "'"));
                throw new BarcodeException("Invalid character: '" + c + "'");
            }
            int n3 = c - 48;
            n2 += n3;
            if (bl) {
                n2 += n3;
                n2 += n3;
            }
            bl = !bl;
        }
        return n2 % 10 == 0 ? 0 : 10 - n2 % 10;
    }

    protected byte getMarginWidth() {
        return 11;
    }

    protected String getBarcodeLabelText(String string) {
        return string.substring(1);
    }

    protected void checkLength(String string) throws BarcodeException {
        if (string.length() != this.getCodeLength()) {
            m_Log.warn((Object)("Invalid length: " + string.length()));
            throw new BarcodeException("Invalid length: " + string.length());
        }
    }

    protected int getCodeLength() {
        return 12;
    }

    @Override
    public EncodedBarcode encode(String string, boolean bl) throws BarcodeException {
        int n;
        int n2 = string.length();
        if (n2 < (n = this.getCodeLength()) - 1) {
            throw new BarcodeException("Invalid length: " + n2);
        }
        if (bl) {
            string = this.augmentWithChecksum(string);
        }
        this.checkLength(string);
        String string2 = this.convertToUPCE(string);
        int n3 = string.charAt(0) - 48;
        int n4 = string.charAt(11) - 48;
        String string3 = n3 == 0 ? NS_0[n4] : NS_1[n4];
        ArrayList<BarcodeElement> arrayList = new ArrayList<BarcodeElement>();
        arrayList.add(this.be(this.getMarginWidth(), false));
        BarcodeElement[] barcodeElementArray = this.getLeftGuard();
        for (int i = 0; i < barcodeElementArray.length; ++i) {
            arrayList.add(barcodeElementArray[i]);
        }
        BarcodeElement[] barcodeElementArray2 = this.getLeft(string2, string3);
        for (int i = 0; i < barcodeElementArray2.length; ++i) {
            arrayList.add(barcodeElementArray2[i]);
        }
        BarcodeElement[] barcodeElementArray3 = this.getRightGuard();
        for (int i = 0; i < barcodeElementArray3.length; ++i) {
            arrayList.add(barcodeElementArray3[i]);
        }
        arrayList.add(this.be(this.getMarginWidth(), false));
        BarcodeElement[] barcodeElementArray4 = new BarcodeElement[arrayList.size()];
        arrayList.toArray(barcodeElementArray4);
        String string4 = this.getLeftLabel(string, string2);
        String string5 = this.getCenterLabel(string, string2);
        String string6 = this.getRightLabel(string, string2);
        return new EncodedBarcode(barcodeElementArray4, string4, string5, string6);
    }

    protected BarcodeElement[] getLeftGuard() {
        return this.elements("101");
    }

    protected BarcodeElement[] getLeft(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 6; ++i) {
            int n = string.charAt(i) - 48;
            if (string2.charAt(i) == 'E') {
                stringBuffer.append(LEFT_EVEN[n]);
                continue;
            }
            stringBuffer.append(LEFT_ODD[n]);
        }
        return this.elements(stringBuffer.toString());
    }

    protected BarcodeElement[] getRightGuard() {
        return this.elements("010101");
    }

    protected String getLeftLabel(String string, String string2) {
        return string.substring(0, 1);
    }

    protected String getCenterLabel(String string, String string2) {
        return string2;
    }

    protected String getRightLabel(String string, String string2) {
        return string.substring(11, 12);
    }

    protected BarcodeElement[] elements(String string) {
        int n = string.length();
        if (n == 0) {
            return new BarcodeElement[0];
        }
        ArrayList<BarcodeElement> arrayList = new ArrayList<BarcodeElement>();
        BarcodeElement barcodeElement = this.be((byte)1, string.charAt(0) == '1');
        arrayList.add(barcodeElement);
        for (int i = 1; i < n; ++i) {
            boolean bl;
            boolean bl2 = bl = string.charAt(i) == '1';
            if (bl == barcodeElement.bar) {
                barcodeElement.width = (byte)(barcodeElement.width + 1);
                continue;
            }
            barcodeElement = this.be((byte)1, bl);
            arrayList.add(barcodeElement);
        }
        BarcodeElement[] barcodeElementArray = new BarcodeElement[arrayList.size()];
        arrayList.toArray(barcodeElementArray);
        return barcodeElementArray;
    }

    protected BarcodeElement be(byte by, boolean bl) {
        BarcodeElement barcodeElement = new BarcodeElement();
        barcodeElement.width = by;
        barcodeElement.bar = bl;
        return barcodeElement;
    }

    protected String convertToUPCE(String string) throws BarcodeException {
        int n;
        int n2 = string.charAt(0) - 48;
        if (n2 > 1) {
            throw new BarcodeException("Number system not supported");
        }
        String string2 = string.substring(1, 6);
        String string3 = string.substring(6, 11);
        if ((string2.endsWith("000") || string2.endsWith("100") || string2.endsWith("200")) && string3.startsWith("00")) {
            return string2.substring(0, 2) + string3.substring(2, 5) + string2.substring(2, 3);
        }
        if (string2.endsWith("00") && string3.startsWith("000")) {
            return string2.substring(0, 3) + string3.substring(3, 5) + "3";
        }
        if (string2.endsWith("0") && string3.startsWith("0000")) {
            return string2.substring(0, 4) + string3.charAt(4) + "4";
        }
        if (!string2.endsWith("0") && string3.startsWith("0000") && (n = string3.charAt(4) - 48) >= 5 && n <= 9) {
            return string2 + n;
        }
        throw new BarcodeException(string + " can't be represented in UPCE");
    }

    public static int testChecksum(String string) {
        char[] cArray = string.toCharArray();
        boolean bl = true;
        int n = 0;
        for (int i = cArray.length - 1; i >= 0; --i) {
            int n2 = cArray[i] - 48;
            n += n2;
            if (bl) {
                n += n2;
                n += n2;
            }
            bl = !bl;
        }
        return n % 10 == 0 ? 0 : 10 - n % 10;
    }
}

