/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.corego;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.corego.GO;
import com.elixirtech.canvas.corego.INestedDiagramHolder;
import com.elixirtech.canvas.corego.IParentGO;
import com.elixirtech.canvas.graph.ContainerNode;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.graph.RelCol;
import com.elixirtech.canvas.graph.RelType;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class Diagram
extends ContainerNode
implements IParentGO {
    protected String m_Name;
    protected static final String NAME = "name";
    protected static final String POLICY = "policy";
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Diagram.class);

    public Diagram() {
    }

    public Diagram(String string) {
    }

    @Override
    public List<GO> getChildGOs() {
        Node[] nodeArray = this.getChildArray();
        ArrayList<GO> arrayList = new ArrayList<GO>();
        for (int i = 0; i < nodeArray.length; ++i) {
            arrayList.add((GO)nodeArray[i]);
        }
        return arrayList;
    }

    public List<Node> shapes() {
        return Arrays.asList(this.getChildArray());
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.put(NAME, "Ensemble");
        map.put(POLICY, "com.elixirtech.ensemble.canvas.EnsemblePolicy");
        return map;
    }

    public GO shapeAtPoint(Point point) {
        Node[] nodeArray = this.getChildArray();
        for (int i = nodeArray.length - 1; i >= 0; --i) {
            GO gO = (GO)nodeArray[i];
            if (!gO.contains(point)) continue;
            return gO;
        }
        return null;
    }

    public String getNodeId(Node node) {
        RelCol relCol = this.getOutRelCol(RelType.Owns);
        int n = relCol.getCount();
        for (int i = 0; i < n; ++i) {
            if (relCol.getItem(i).getDestination() != node) continue;
            return String.valueOf(i);
        }
        List<Node> list = relCol.getTargetElements();
        n = list.size();
        for (int i = 0; i < n; ++i) {
            Diagram diagram;
            String string;
            Node node2 = list.get(i);
            if (!(node2 instanceof INestedDiagramHolder) || (string = (diagram = ((INestedDiagramHolder)((Object)node2)).getNestedDiagram()).getNodeId(node)) == null) continue;
            return String.valueOf(i) + "." + string;
        }
        return null;
    }

    public Node getNode(String string) {
        return this.getNode(string.split("\\."), 0);
    }

    protected final Node getNode(String[] stringArray, int n) {
        try {
            int n2 = Integer.parseInt(stringArray[n]);
            RelCol relCol = this.getOutRelCol(RelType.Owns);
            Node node = relCol.getItem(n2).getDestination();
            int n3 = n + 1;
            if (n3 < stringArray.length) {
                Diagram diagram = ((INestedDiagramHolder)((Object)node)).getNestedDiagram();
                return diagram.getNode(stringArray, n3);
            }
            return node;
        }
        catch (NumberFormatException numberFormatException) {
            m_Log.error((Object)("call to getNode failed because " + stringArray[n] + " is not an integer"));
            return null;
        }
    }
}

