/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.canvas.xml;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.canvas.corego.Diagram;
import com.elixirtech.canvas.graph.Node;
import com.elixirtech.canvas.xml.JDOMReader;
import com.elixirtech.canvas.xml.JDOMWriter;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.XMLOutputter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public final class XmlUtil {
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(XmlUtil.class);

    private XmlUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveDiagram(Diagram diagram, File file) throws IOException {
        Element element = XmlUtil.saveDiagramToJDOM(diagram);
        XMLOutputter xMLOutputter = new XMLOutputter();
        try (FileOutputStream fileOutputStream = null;){
            fileOutputStream = new FileOutputStream(file);
            xMLOutputter.output(element, (OutputStream)fileOutputStream);
        }
    }

    public static Diagram loadDiagram(File file) throws IOException {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            return XmlUtil.loadDiagramFromJDOM(document.getRootElement(), new HashMap<String, String>());
        }
        catch (JDOMException jDOMException) {
            IOException iOException = new IOException("JDOM Exception: " + String.valueOf(jDOMException));
            iOException.initCause(jDOMException);
            throw iOException;
        }
    }

    public static Element saveDiagramToJDOM(Diagram diagram) {
        JDOMWriter jDOMWriter = new JDOMWriter();
        jDOMWriter.writeNode(diagram);
        jDOMWriter.close();
        return jDOMWriter.getRoot();
    }

    public static Diagram loadDiagramFromJDOM(Element element, Map<String, String> map) throws IOException {
        JDOMReader jDOMReader = new JDOMReader(element, map);
        Node[] nodeArray = jDOMReader.readNodes();
        return (Diagram)nodeArray[0];
    }
}

