/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.cell;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.cell.Cell;
import com.elixirtech.cell.CellId;
import com.elixirtech.cell.NullCell$;
import com.elixirtech.cell.Row;
import com.elixirtech.cell.RowSpanCell$;
import com.elixirtech.cell.SpanCell$;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CellStructure
implements SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CellStructure.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final String name;
    private final int columns;
    private final ListBuffer rows;
    private final HashMap properties;

    public CellStructure(String name, int columns) {
        this.name = name;
        this.columns = columns;
        Predef$.MODULE$.require(columns >= 0);
        this.rows = new ListBuffer();
        this.properties = new HashMap();
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String name() {
        return this.name;
    }

    public int columns() {
        return this.columns;
    }

    public ListBuffer<Row> rows() {
        return this.rows;
    }

    public HashMap<String, Object> properties() {
        return this.properties;
    }

    public void addRow(Object[] data) {
        Row row = this.emptyRow();
        this.rows().$plus$eq((Object)row);
        for (int col = 0; col < data.length; ++col) {
            Cell cell = new Cell(1, 1, data[col]);
            row.update(col, cell);
        }
    }

    public Cell addCell(int row, int col, int rowSpan, int colSpan, Object data) {
        Predef$.MODULE$.require(row >= 0);
        Predef$.MODULE$.require(col >= 0);
        Predef$.MODULE$.require(col < this.columns(), () -> this.addCell$$anonfun$1(col));
        Predef$.MODULE$.require(rowSpan > 0);
        Predef$.MODULE$.require(colSpan > 0);
        Predef$.MODULE$.require(col + colSpan <= this.columns(), () -> this.addCell$$anonfun$2(col, colSpan));
        while (row + rowSpan > this.rows().size()) {
            this.rows().$plus$eq((Object)this.emptyRow());
        }
        Cell cell = this.getCell(row, col);
        NullCell$ nullCell$ = NullCell$.MODULE$;
        if (cell == null ? nullCell$ != null : !cell.equals(nullCell$)) {
            Cell existingCell = this.getCell(row, col);
            this.info(() -> CellStructure.addCell$$anonfun$3(row, col), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("com.elixirtech.cell.CellStructure.addCell"));
            this.info(() -> CellStructure.addCell$$anonfun$4(existingCell), Line$.MODULE$.apply(41), FullName$.MODULE$.apply("com.elixirtech.cell.CellStructure.addCell"));
            this.info(() -> CellStructure.addCell$$anonfun$5(existingCell), Line$.MODULE$.apply(42), FullName$.MODULE$.apply("com.elixirtech.cell.CellStructure.addCell"));
            this.info(() -> CellStructure.addCell$$anonfun$6(data), Line$.MODULE$.apply(43), FullName$.MODULE$.apply("com.elixirtech.cell.CellStructure.addCell"));
            throw new RuntimeException("Cell col=" + col + ", row=" + row + " already used.");
        }
        Cell cell2 = new Cell(rowSpan, colSpan, data);
        ((Row)this.rows().apply(row)).update(col, cell2);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(col + 1), col + colSpan).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x -> ((Row)this.rows().apply(row)).update(x, SpanCell$.MODULE$));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(row + 1), row + rowSpan).foreach((Function1)(JFunction1.mcVI.sp & Serializable)y -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(col), col + colSpan).foreach((Function1)(JFunction1.mcVI.sp & Serializable)x -> ((Row)this.rows().apply(y)).update(x, RowSpanCell$.MODULE$)));
        return cell2;
    }

    public Row emptyRow() {
        Cell[] array = new Cell[this.columns()];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columns()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            array$1[i] = NullCell$.MODULE$;
        });
        return new Row(array);
    }

    public Cell getCell(int row, int col) {
        return ((Row)this.rows().apply(row)).apply(col);
    }

    public Option<CellId> getCellId(int row, int col) {
        Cell cell;
        Cell cell2 = cell = ((Row)this.rows().apply(row)).apply(col);
        NullCell$ nullCell$ = NullCell$.MODULE$;
        if (!(cell2 != null ? !cell2.equals(nullCell$) : nullCell$ != null)) {
            return None$.MODULE$;
        }
        if (cell.isColSpan()) {
            return this.getCellId(row, col - 1);
        }
        if (cell.isRowSpan()) {
            return this.getCellId(row - 1, col);
        }
        return Some$.MODULE$.apply((Object)new CellId(row, col, cell.rowSpan(), cell.colSpan(), cell.data()));
    }

    public Seq<Tuple2<Object, Object>> cellIndexes() {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows().size()).flatMap((Function1 & Serializable)r -> this.cellIndexes$$anonfun$1(BoxesRunTime.unboxToInt((Object)r)));
    }

    public Seq<Cell> cellsInRow(int row) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columns()).map((Function1 & Serializable)col -> this.cellsInRow$$anonfun$1(row, BoxesRunTime.unboxToInt((Object)col))).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Cell cell;
                int col = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Cell cell2 = cell = (Cell)tuple2._2();
                NullCell$ nullCell$ = NullCell$.MODULE$;
                return cell2 == null ? nullCell$ != null : !cell2.equals(nullCell$);
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int col = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Cell cell = (Cell)tuple2._2();
                return cell;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Seq<Cell> cellsInColumn(int col) {
        return (Seq)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows().size()).map((Function1 & Serializable)row -> this.cellsInColumn$$anonfun$1(col, BoxesRunTime.unboxToInt((Object)row))).withFilter((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Cell cell;
                int row = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Cell cell2 = cell = (Cell)tuple2._2();
                NullCell$ nullCell$ = NullCell$.MODULE$;
                return cell2 == null ? nullCell$ != null : !cell2.equals(nullCell$);
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int row = BoxesRunTime.unboxToInt((Object)tuple2._1());
                Cell cell = (Cell)tuple2._2();
                return cell;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public String mkString(Function1<Object, String> code) {
        StringBuilder sb = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows().size()).foreach((Function1 & Serializable)r -> this.mkString$$anonfun$1(sb, code, BoxesRunTime.unboxToInt((Object)r)));
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.rows().size()).foreach((Function1 & Serializable)r -> this.toString$$anonfun$1(sb, BoxesRunTime.unboxToInt((Object)r)));
        return sb.toString();
    }

    private final Object addCell$$anonfun$1(int col$1) {
        return "col=" + col$1 + ">=" + this.columns();
    }

    private final Object addCell$$anonfun$2(int col$2, int colSpan$1) {
        return "col=" + col$2 + " + colSpan=" + colSpan$1 + " > " + this.columns();
    }

    private static final Object addCell$$anonfun$3(int row$1, int col$3) {
        return "row=" + row$1 + ",col=" + col$3;
    }

    private static final Object addCell$$anonfun$4(Cell existingCell$1) {
        return "currCell=" + existingCell$1.getClass().getName();
    }

    private static final Object addCell$$anonfun$5(Cell existingCell$2) {
        return "currData=" + existingCell$2.data();
    }

    private static final Object addCell$$anonfun$6(Object data$1) {
        return "newData=" + data$1;
    }

    private static final /* synthetic */ Tuple2 cellIndexes$$anonfun$1$$anonfun$1(int r$1, int c) {
        return new Tuple2.mcII.sp(r$1, c);
    }

    private final /* synthetic */ IterableOnce cellIndexes$$anonfun$1(int r) {
        return RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columns()).map((Function1 & Serializable)c -> CellStructure.cellIndexes$$anonfun$1$$anonfun$1(r, BoxesRunTime.unboxToInt((Object)c)));
    }

    private final /* synthetic */ Tuple2 cellsInRow$$anonfun$1(int row$3, int col) {
        Cell cell = this.getCell(row$3, col);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)col), (Object)cell);
    }

    private final /* synthetic */ Tuple2 cellsInColumn$$anonfun$1(int col$5, int row) {
        Cell cell = this.getCell(row, col$5);
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)row), (Object)cell);
    }

    private final /* synthetic */ StringBuilder mkString$$anonfun$1$$anonfun$1(StringBuilder sb$2, int r$2, Function1 code$2, int c) {
        Cell cellValue;
        Cell cell = this.getCell(r$2, c);
        String string = NullCell$.MODULE$.equals(cell) ? "-" : (!(cellValue = cell).isSpan() ? (String)code$2.apply(cellValue.data()) : "X");
        return sb$2.append(string);
    }

    private final /* synthetic */ StringBuilder mkString$$anonfun$1(StringBuilder sb$1, Function1 code$1, int r) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columns()).foreach((Function1 & Serializable)c -> this.mkString$$anonfun$1$$anonfun$1(sb$1, r, code$1, BoxesRunTime.unboxToInt((Object)c)));
        return sb$1.append("\n");
    }

    private final /* synthetic */ StringBuilder toString$$anonfun$1$$anonfun$1(StringBuilder sb$4, int r$3, int c) {
        Cell cellValue;
        Cell cell = this.getCell(r$3, c);
        Object object = NullCell$.MODULE$.equals(cell) ? "-" : ((cellValue = cell).isSpan() ? BoxesRunTime.boxToCharacter((char)'S') : BoxesRunTime.boxToCharacter((char)'X'));
        return sb$4.append(object);
    }

    private final /* synthetic */ StringBuilder toString$$anonfun$1(StringBuilder sb$3, int r) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.columns()).foreach((Function1 & Serializable)c -> this.toString$$anonfun$1$$anonfun$1(sb$3, r, BoxesRunTime.unboxToInt((Object)c)));
        return sb$3.append("\n");
    }
}

