/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.chart2.LimnAreaValues;
import com.elixirtech.chart2.LimnColumnValues;
import com.elixirtech.chart2.LimnDrawingSupplier;
import com.elixirtech.chart2.LimnLineValues;
import com.elixirtech.chart2.LimnPlot$;
import com.elixirtech.chart2.LimnPlot$LAxis$;
import com.elixirtech.chart2.LimnScatterValues;
import com.elixirtech.chart2.LimnSurfaceValues;
import com.elixirtech.chart2.data.ScatterDataset;
import com.elixirtech.chart2.data.ScatterSeries;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.Category3dType;
import com.elixirtech.chart2.model.Category3dUi;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.Label;
import com.elixirtech.chart2.model.Scatter3dType;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.Camera;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.chart.BaseAxisOverlay;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.LeftAxisOverlay;
import com.elixirtech.limn.chart.NumberAxisValues;
import com.elixirtech.limn.chart.RightAxisOverlay;
import com.elixirtech.limn.chart.StringAxisValues;
import com.elixirtech.ui.StandardColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Locale;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.slf4j.Logger;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple3$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class LimnPlot
extends Plot
implements SLF4J,
LoggingHelper {
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(LimnPlot.class.getDeclaredField("logger$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(LimnPlot.class.getDeclaredField("legendItemCollection$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LimnPlot.class.getDeclaredField("world$lzy1"));
    private volatile Object logger$lzy1;
    private final Chart chart;
    private final DatasetHolder datasetHolder;
    private final ChartType ctype;
    private final Category3dUi ui;
    private volatile Object world$lzy1;
    private volatile Object legendItemCollection$lzy1;
    private Angle3d cameraAngle;
    private Option paints;
    private Point firstYTickLabelOffset;
    private final boolean xIsNumeric;
    private final boolean zIsNumeric;

    public static int Alpha() {
        return LimnPlot$.MODULE$.Alpha();
    }

    public static Angle3d DefaultCameraAngle() {
        return LimnPlot$.MODULE$.DefaultCameraAngle();
    }

    public static Color[] DefaultPaintColors() {
        return LimnPlot$.MODULE$.DefaultPaintColors();
    }

    public static BasicStroke OutlineStroke() {
        return LimnPlot$.MODULE$.OutlineStroke();
    }

    public static Angle3d StandardCameraAngle() {
        return LimnPlot$.MODULE$.StandardCameraAngle();
    }

    public static ShadedColor White() {
        return LimnPlot$.MODULE$.White();
    }

    public LimnPlot(Chart chart, DatasetHolder datasetHolder) {
        boolean bl;
        boolean bl2;
        Category3dUi category3dUi;
        this.chart = chart;
        this.datasetHolder = datasetHolder;
        this.ctype = chart.getChartType();
        ChartType chartType = this.ctype();
        if (chartType instanceof Scatter3dType) {
            Scatter3dType c = (Scatter3dType)chartType;
            category3dUi = c.getCategory3dUi();
        } else if (chartType instanceof Category3dType) {
            Category3dType c = (Category3dType)chartType;
            category3dUi = c.getCategory3dUi();
        } else {
            throw new IllegalStateException("Unknown chart type: " + this.ctype());
        }
        this.ui = category3dUi;
        this.setDrawingSupplier(new LimnDrawingSupplier(LimnPlot$.MODULE$.DefaultPaintColors()));
        this.cameraAngle = LimnPlot$.MODULE$.DefaultCameraAngle();
        this.paints = None$.MODULE$;
        this.firstYTickLabelOffset = new Point(-3, -3);
        Dataset dataset = datasetHolder.getDataset();
        if (dataset instanceof CategoryDataset) {
            CategoryDataset catds = (CategoryDataset)dataset;
            bl2 = CollectionConverters$.MODULE$.ListHasAsScala(catds.getColumnKeys()).asScala().find((Function1 & Serializable)k -> !(k instanceof Number)).isEmpty();
        } else if (dataset instanceof ScatterDataset) {
            ScatterDataset sds = (ScatterDataset)dataset;
            bl2 = true;
        } else {
            Dataset x = dataset;
            throw new IllegalStateException("Unknown dataset type: " + x);
        }
        this.xIsNumeric = bl2;
        Dataset dataset2 = datasetHolder.getDataset();
        if (dataset2 instanceof CategoryDataset) {
            CategoryDataset catds = (CategoryDataset)dataset2;
            bl = CollectionConverters$.MODULE$.ListHasAsScala(catds.getRowKeys()).asScala().find((Function1 & Serializable)k -> !(k instanceof Number)).isEmpty();
        } else if (dataset2 instanceof ScatterDataset) {
            ScatterDataset sds = (ScatterDataset)dataset2;
            bl = true;
        } else {
            Dataset x = dataset2;
            throw new IllegalStateException("Unknown dataset type: " + x);
        }
        this.zIsNumeric = bl;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public ChartType ctype() {
        return this.ctype;
    }

    public Category3dUi ui() {
        return this.ui;
    }

    public ChartWorld world() {
        Object object = this.world$lzy1;
        if (object instanceof ChartWorld) {
            return (ChartWorld)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ChartWorld)this.world$lzyINIT1();
    }

    private Object world$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.world$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ChartWorld chartWorld = null;
                    try {
                        chartWorld = this.createWorld();
                        object2 = chartWorld == null ? LazyVals.NullValue$.MODULE$ : chartWorld;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.world$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return chartWorld;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public LegendItemCollection legendItemCollection() {
        Object object = this.legendItemCollection$lzy1;
        if (object instanceof LegendItemCollection) {
            return (LegendItemCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LegendItemCollection)this.legendItemCollection$lzyINIT1();
    }

    private Object legendItemCollection$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.legendItemCollection$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LegendItemCollection legendItemCollection = null;
                    try {
                        legendItemCollection = this.buildLegendItems();
                        object2 = legendItemCollection == null ? LazyVals.NullValue$.MODULE$ : legendItemCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.legendItemCollection$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return legendItemCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Angle3d cameraAngle() {
        return this.cameraAngle;
    }

    public void cameraAngle_$eq(Angle3d x$1) {
        this.cameraAngle = x$1;
    }

    public Option<ShadedColor[]> paints() {
        return this.paints;
    }

    public void paints_$eq(Option<ShadedColor[]> x$1) {
        this.paints = x$1;
    }

    public Point firstYTickLabelOffset() {
        return this.firstYTickLabelOffset;
    }

    public void firstYTickLabelOffset_$eq(Point x$1) {
        this.firstYTickLabelOffset = x$1;
    }

    public boolean xIsNumeric() {
        return this.xIsNumeric;
    }

    public boolean zIsNumeric() {
        return this.zIsNumeric;
    }

    public Object clone() {
        return super.clone();
    }

    public void setCameraAngle(Angle3d angle) {
        this.cameraAngle_$eq(angle.makeClone());
    }

    public Angle3d getCameraAngle() {
        return this.cameraAngle().makeClone();
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        this.debug(LimnPlot::draw$$anonfun$1, Line$.MODULE$.apply(115), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.draw"));
        this.updateWorld();
        int zv = 100;
        double width = area.getWidth();
        double height = area.getHeight();
        Point3d cameraPos = new Point3d(0.0, 0.0, Int$.MODULE$.int2double(zv));
        Camera camera = new Camera(this.world(), 1.0471975511965976, cameraPos, this.cameraAngle());
        camera.setScreenSize((int)width, (int)height);
        camera.updateMatrix();
        Rectangle2D bb = camera.getBoundingBox();
        while (bb.getWidth() > width) {
            cameraPos.z = Int$.MODULE$.int2double(zv += 20);
            camera.setOrientation(cameraPos, this.cameraAngle());
            camera.updateMatrix();
            bb = camera.getBoundingBox();
        }
        while (bb.getHeight() > height) {
            cameraPos.z = Int$.MODULE$.int2double(zv += 20);
            camera.setOrientation(cameraPos, this.cameraAngle());
            camera.updateMatrix();
            bb = camera.getBoundingBox();
        }
        double xOffset = area.getX() - bb.getX() + (width - bb.getWidth()) / (double)2;
        double yOffset = area.getY() - bb.getY() + (height - bb.getHeight()) / (double)2;
        g2.translate(xOffset, yOffset);
        this.debug(LimnPlot::draw$$anonfun$2, Line$.MODULE$.apply(143), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.draw"));
        camera.paint(g2);
        this.debug(this::draw$$anonfun$3, Line$.MODULE$.apply(145), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.draw"));
    }

    public ShadedColor[] getPaints(int count) {
        ShadedColor[] p;
        DrawingSupplier supplier = this.getDrawingSupplier();
        Option<ShadedColor[]> option = this.paints();
        if (option instanceof Some && (p = (ShadedColor[])((Some)option).value()).length == count) {
            return p;
        }
        ShadedColor[] p2 = (ShadedColor[])LimnPlot.paintStream$1(supplier).take(count).toArray(ClassTag$.MODULE$.apply(ShadedColor.class));
        this.paints_$eq((Option<ShadedColor[]>)Some$.MODULE$.apply((Object)p2));
        return p2;
    }

    public Point getFirstYTickLabelOffset() {
        return new Point(this.firstYTickLabelOffset().x, this.firstYTickLabelOffset().y);
    }

    public void setFirstYTickLabelOffset(int x, int y) {
        this.firstYTickLabelOffset_$eq(new Point(x, y));
    }

    public LegendItemCollection getLegendItems() {
        return this.legendItemCollection();
    }

    private LegendItemCollection buildLegendItems() {
        this.debug(LimnPlot::buildLegendItems$$anonfun$1, Line$.MODULE$.apply(170), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.buildLegendItems"));
        String string = this.chart.getType();
        LegendItemCollection ret = "3D-Surface".equals(string) ? this.getYLegendItems() : ("3D-Scatter".equals(string) ? this.getScatterLegendItems() : this.getZLegendItems());
        this.debug(LimnPlot::buildLegendItems$$anonfun$2, Line$.MODULE$.apply(176), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.buildLegendItems"));
        return ret;
    }

    private LegendItem buildLegendItem(String label, ShadedColor shade) {
        Color paint = shade.getColor();
        if (paint.getAlpha() != 255) {
            paint = new Color(paint.getRed(), paint.getGreen(), paint.getBlue());
        }
        return new LegendItem(label, null, null, null, AbstractRenderer.DEFAULT_SHAPE, (Paint)paint, (Stroke)LimnPlot$.MODULE$.OutlineStroke(), (Paint)Color.black);
    }

    public LegendItemCollection getScatterLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        ScatterDataset ds = (ScatterDataset)this.datasetHolder.getDataset();
        Object[] paints = this.getPaints(ds.series().size());
        ((List)ds.series().zip((IterableOnce)Predef$.MODULE$.wrapRefArray(paints))).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                ScatterSeries s = (ScatterSeries)((Object)((Object)tuple2._1()));
                ShadedColor p = (ShadedColor)tuple2._2();
                result.add(this.buildLegendItem(String.valueOf(s.key()), p));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return result;
    }

    private Comparable<?>[] comparable(java.util.List<?> list) {
        return (Comparable[])((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(list).asScala().map((Function1 & Serializable)_$1 -> (Comparable)_$1)).toArray(ClassTag$.MODULE$.apply(Comparable.class));
    }

    private Object[] objects(Comparable<?>[] a) {
        Object[] ret = new Object[a.length];
        System.arraycopy(a, 0, ret, 0, a.length);
        return ret;
    }

    public LegendItemCollection getYLegendItems() {
        CategoryDataset ds = (CategoryDataset)this.datasetHolder.getDataset();
        Object[] colKeys = this.comparable(ds.getColumnKeys());
        Comparable[] rowKeys = this.comparable(ds.getRowKeys());
        Object object = Predef$.MODULE$.refArrayOps(colKeys);
        Object[] values = (Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])rowKeys);
            return (Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)y -> ds.getValue(y, x), ClassTag$.MODULE$.apply(Object.class));
        }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray(xs), ClassTag$.MODULE$.apply(Object.class));
        NumberAxisValues yAxis = this.buildNumberAxisValues(values, this.ui().getYAxis(), true, true, this.isPadY());
        int count = yAxis.getPositionCount();
        ShadedColor[] paints = this.getPaints(count);
        ListBuffer items = new ListBuffer();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count - 2).foreach((Function1 & Serializable)i -> this.getYLegendItems$$anonfun$1(yAxis, items, paints, BoxesRunTime.unboxToInt((Object)i)));
        LegendItemCollection result = new LegendItemCollection();
        String anchor = this.chart.getChartType().getLegend().getAnchor();
        if (anchor.equals("East") || anchor.equals("West")) {
            ((IterableOnceOps)items.reverse()).foreach((Function1)(JProcedure1 & Serializable)x$0 -> result.add(x$0));
        } else {
            items.foreach((Function1)(JProcedure1 & Serializable)x$0 -> result.add(x$0));
        }
        return result;
    }

    public LegendItemCollection getZLegendItems() {
        LegendItemCollection result = new LegendItemCollection();
        Tick zTick = this.ui().getZAxis().getTick();
        ObjectRef nf = ObjectRef.create((Object)None$.MODULE$);
        if (this.zIsNumeric()) {
            Format format = (Format)zTick.getFormat();
            nf.elem = Some$.MODULE$.apply((Object)Formatter.buildNumberFormatter(format, this.getLocale(format)));
        }
        CategoryDataset ds = (CategoryDataset)this.datasetHolder.getDataset();
        Object[] paints = this.getPaints(ds.getRowCount());
        Buffer rowKeys = (Buffer)((SeqOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(ds.getRowKeys()).asScala().map((Function1 & Serializable)_$2 -> _$2)).zip((IterableOnce)Predef$.MODULE$.wrapRefArray(paints))).reverse();
        rowKeys.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string;
                Object rowKey = tuple2._1();
                ShadedColor paint = (ShadedColor)tuple2._2();
                Option option = (Option)nf$1.elem;
                if (option instanceof Some) {
                    NumberFormat f = (NumberFormat)((Some)option).value();
                    string = f.format(rowKey);
                } else if (None$.MODULE$.equals(option)) {
                    string = String.valueOf(rowKey);
                } else {
                    throw new MatchError((Object)option);
                }
                String label = string;
                result.add(this.buildLegendItem(label, paint));
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ChartWorld createWorld() {
        ChartWorld world;
        block14: {
            this.debug(LimnPlot::createWorld$$anonfun$1, Line$.MODULE$.apply(251), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.createWorld"));
            ObjectRef rowKeys = ObjectRef.create((Object)new Comparable[0]);
            Object[] colKeys = new Comparable[]{};
            Object[] values = new Object[]{};
            Dataset dataset = this.datasetHolder.getDataset();
            if (dataset instanceof CategoryDataset) {
                CategoryDataset catds = (CategoryDataset)dataset;
                rowKeys.elem = this.comparable(catds.getRowKeys());
                colKeys = this.comparable(catds.getColumnKeys());
                Object object = Predef$.MODULE$.refArrayOps(colKeys);
                values = (Object[])ArrayOps$.MODULE$.flatMap$extension(object, (Function1 & Serializable)x -> {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])((Comparable[])rowKeys$2.elem));
                    return (Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)y -> catds.getValue(y, x), ClassTag$.MODULE$.apply(Object.class));
                }, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapRefArray(xs), ClassTag$.MODULE$.apply(Object.class));
                v0 = Tuple3$.MODULE$.apply((Object)((Comparable[])rowKeys.elem), (Object)colKeys, (Object)values);
            } else {
                if (!(dataset instanceof ScatterDataset)) {
                    Dataset x2 = dataset;
                    throw new IllegalStateException("Unknown dataset type: " + x2);
                }
                ScatterDataset sds = (ScatterDataset)dataset;
                rowKeys.elem = sds.getZValues();
                colKeys = sds.getXValues();
                values = sds.getYValues();
                v0 = BoxedUnit.UNIT;
            }
            NumberAxisValues left = this.buildNumberAxisValues(values, this.ui().getYAxis(), true, true, this.isPadY());
            NumberAxisValues right = left.makeClone();
            if (this.cameraAngle().y > 0.0) {
                right.setShowAxis(false);
            } else {
                left.setShowAxis(false);
            }
            StringAxisValues bottomLeft = this.xIsNumeric() ? this.buildNumberAxisValues(this.objects((Comparable<?>[])colKeys), this.ui().getXAxis(), false, true, this.isPadX()) : this.buildStringAxisValues(this.objects((Comparable<?>[])colKeys), this.ui().getXAxis(), true);
            StringAxisValues bottomRight = this.zIsNumeric() ? this.buildNumberAxisValues(this.objects((Comparable[])rowKeys.elem), this.ui().getZAxis(), false, true, this.isPadZ()) : this.buildStringAxisValues(this.objects((Comparable[])rowKeys.elem), this.ui().getZAxis(), true);
            world = new ChartWorld(left, right, bottomLeft, bottomRight);
            Paint paint = this.getBackgroundPaint();
            if (paint instanceof Color) {
                Color paint2 = (Color)paint;
                world.setAxesColor(paint2);
            }
            world.build();
            Color gridColor = Color.GRAY;
            LAxis y = LimnPlot$LAxis$.MODULE$.apply(this.ui().getYAxis());
            LeftAxisOverlay leftOverlay = world.getLeftAxisOverlay();
            leftOverlay.setTickUi(gridColor, StandardColor.lookup(y.tickFont().getFontColor()), y.tickFont().getAWTFont());
            leftOverlay.setLabelUi(y.label().getText(), StandardColor.lookup(y.labelFont().getFontColor()), y.labelFont().getAWTFont());
            if (this.xIsNumeric()) {
                leftOverlay.setFirstTickLabelOffset(this.firstYTickLabelOffset());
            }
            RightAxisOverlay rightOverlay = world.getRightAxisOverlay();
            rightOverlay.setTickUi(gridColor, StandardColor.lookup(y.tickFont().getFontColor()), y.tickFont().getAWTFont());
            rightOverlay.setLabelUi(y.label().getText(), StandardColor.lookup(y.labelFont().getFontColor()), y.labelFont().getAWTFont());
            LAxis x3 = LimnPlot$LAxis$.MODULE$.apply(this.ui().getXAxis());
            LAxis z = LimnPlot$LAxis$.MODULE$.apply(this.ui().getZAxis());
            BaseAxisOverlay baseOverlay = world.getBaseAxisOverlay();
            baseOverlay.setLeftTickUi(gridColor, StandardColor.lookup(x3.tickFont().getFontColor()), x3.tickFont().getAWTFont());
            baseOverlay.setLeftLabelUi(x3.label().getText(), StandardColor.lookup(x3.labelFont().getFontColor()), x3.labelFont().getAWTFont());
            baseOverlay.setRightTickUi(gridColor, StandardColor.lookup(z.tickFont().getFontColor()), z.tickFont().getAWTFont());
            baseOverlay.setRightLabelUi(z.label().getText(), StandardColor.lookup(z.labelFont().getFontColor()), z.labelFont().getAWTFont());
            this.debug(LimnPlot::createWorld$$anonfun$4, Line$.MODULE$.apply(317), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.createWorld"));
            String string = this.chart.getType();
            switch (string == null ? 0 : string.hashCode()) {
                case -426888622: {
                    if (!"3D-Column".equals(string)) break;
                    Object object = new LimnColumnValues(this, world, this.datasetHolder);
                    break block14;
                }
                case 8437385: {
                    if (!"3D-Area".equals(string)) break;
                    Object object = new LimnAreaValues(this, world, this.datasetHolder);
                    break block14;
                }
                case 8756720: {
                    if (!"3D-Line".equals(string)) break;
                    Object object = new LimnLineValues(this, world, this.datasetHolder);
                    break block14;
                }
                case 612779842: {
                    if (!"3D-Scatter".equals(string)) break;
                    Object object = new LimnScatterValues(this, world, this.datasetHolder);
                    break block14;
                }
                case 1143369009: {
                    if (!"3D-Surface".equals(string)) break;
                    Object object = new LimnSurfaceValues(this, world, this.datasetHolder);
                    break block14;
                }
            }
            String x4 = string;
            throw new IllegalStateException("Unknown chart type: " + x4);
        }
        this.debug(LimnPlot::createWorld$$anonfun$5, Line$.MODULE$.apply(326), FullName$.MODULE$.apply("com.elixirtech.chart2.LimnPlot.createWorld"));
        return world;
    }

    private void updateWorld() {
        NumberAxisValues left = (NumberAxisValues)this.world().getLeftAxisValues();
        NumberAxisValues right = (NumberAxisValues)this.world().getRightAxisValues();
        if (this.cameraAngle().y > 0.0) {
            left.setShowAxis(true);
            right.setShowAxis(false);
            return;
        }
        left.setShowAxis(false);
        right.setShowAxis(true);
    }

    private NumberAxisValues buildNumberAxisValues(Object[] values, Axis axis, boolean startAtZero, boolean showLabels, boolean pad) {
        boolean isShowLabels = axis.getTick().isTickMarkVisible() && showLabels;
        NumberAxisValues ret = new NumberAxisValues(values, startAtZero, isShowLabels);
        Format format = (Format)axis.getTick().getFormat();
        NumberFormat ynf = Formatter.buildNumberFormatter(format, this.getLocale(format));
        ret.setFormat(ynf);
        if (pad) {
            ret.setPaddingPercent(8);
        }
        return ret;
    }

    private StringAxisValues buildStringAxisValues(Object[] values, Axis axis, boolean showLabels) {
        boolean isShowLabels = axis.getTick().isTickMarkVisible() && showLabels;
        return new StringAxisValues(values, false, isShowLabels);
    }

    private boolean isPadX() {
        return "3D-Column".equals(this.chart.getType());
    }

    private boolean isPadY() {
        return "3D-Line".equals(this.chart.getType());
    }

    private boolean isPadZ() {
        return !"3D-Scatter".equals(this.chart.getType());
    }

    private Locale getLocale(Format f2) {
        return (Locale)Option$.MODULE$.apply((Object)f2).flatMap((Function1 & Serializable)f -> Option$.MODULE$.apply((Object)f.getLocale())).orElse(this::getLocale$$anonfun$2).getOrElse(LimnPlot::getLocale$$anonfun$3);
    }

    public String getPlotType() {
        return "LimnPlot";
    }

    private static final Object draw$$anonfun$1() {
        return "draw-begin";
    }

    private static final Object draw$$anonfun$2() {
        return "draw-camera-paint";
    }

    private final Object draw$$anonfun$3() {
        return "draw-end " + this.cameraAngle().x + "," + this.cameraAngle().y + "," + this.cameraAngle().z;
    }

    private static final ShadedColor shaded$1(Paint p) {
        Paint paint = p;
        if (paint instanceof Color) {
            Color c = (Color)paint;
            return new ShadedColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), LimnPlot$.MODULE$.Alpha()));
        }
        return LimnPlot$.MODULE$.White();
    }

    private static final ShadedColor paintStream$1$$anonfun$1(DrawingSupplier supplier$2) {
        return LimnPlot.shaded$1(supplier$2.getNextPaint());
    }

    private static final LazyList paintStream$1$$anonfun$2(DrawingSupplier supplier$3) {
        return LimnPlot.paintStream$1(supplier$3);
    }

    private static final LazyList paintStream$1(DrawingSupplier supplier$1) {
        package$.MODULE$.LazyList();
        return LazyList.cons$.MODULE$.apply(() -> LimnPlot.paintStream$1$$anonfun$1(supplier$1), () -> LimnPlot.paintStream$1$$anonfun$2(supplier$1));
    }

    private static final Object buildLegendItems$$anonfun$1() {
        return "buildLegendItems-begin";
    }

    private static final Object buildLegendItems$$anonfun$2() {
        return "buildLegendItems-end";
    }

    private final /* synthetic */ ListBuffer getYLegendItems$$anonfun$1(NumberAxisValues yAxis$1, ListBuffer items$1, ShadedColor[] paints$1, int i) {
        String label1 = yAxis$1.getPosition((int)i).label;
        String label2 = yAxis$1.getPosition((int)(i + 1)).label;
        String label = label1 + "-" + label2;
        return (ListBuffer)items$1.$plus$eq((Object)this.buildLegendItem(label, paints$1[i]));
    }

    private static final Object createWorld$$anonfun$1() {
        return "createWorld-begin";
    }

    private static final Object createWorld$$anonfun$4() {
        return "createWorld-buildValues-begin";
    }

    private static final Object createWorld$$anonfun$5() {
        return "createWorld-end";
    }

    private final Option getLocale$$anonfun$2() {
        return Option$.MODULE$.apply((Object)this.chart.getLocale());
    }

    private static final Locale getLocale$$anonfun$3() {
        return Locale.getDefault();
    }

    public static class LAxis
    implements Product,
    Serializable {
        private final Axis a;
        private final Tick tick;
        private final Font tickFont;
        private final Label label;
        private final Font labelFont;

        public static LAxis apply(Axis axis) {
            return LimnPlot$LAxis$.MODULE$.apply(axis);
        }

        public static LAxis fromProduct(Product product) {
            return LimnPlot$LAxis$.MODULE$.fromProduct(product);
        }

        public static LAxis unapply(LAxis lAxis) {
            return LimnPlot$LAxis$.MODULE$.unapply(lAxis);
        }

        public LAxis(Axis a) {
            this.a = a;
            this.tick = a.getTick();
            this.tickFont = this.tick().getFont();
            this.label = a.getLabel();
            this.labelFont = this.label().getFont();
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LAxis)) return false;
            LAxis lAxis = (LAxis)object;
            Axis axis = this.a();
            Axis axis2 = lAxis.a();
            if (axis == null) {
                if (axis2 != null) {
                    return false;
                }
            } else if (!axis.equals(axis2)) return false;
            if (!lAxis.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LAxis;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LAxis";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "a";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Axis a() {
            return this.a;
        }

        public Tick tick() {
            return this.tick;
        }

        public Font tickFont() {
            return this.tickFont;
        }

        public Label label() {
            return this.label;
        }

        public Font labelFont() {
            return this.labelFont;
        }

        public LAxis copy(Axis a) {
            return new LAxis(a);
        }

        public Axis copy$default$1() {
            return this.a();
        }

        public Axis _1() {
            return this.a();
        }
    }
}

