/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2;

import com.elixirtech.chart2.LimnPlot;
import com.elixirtech.chart2.LimnScatterValues$;
import com.elixirtech.chart2.data.ScatterDataset;
import com.elixirtech.chart2.data.ScatterSeries;
import com.elixirtech.chart2.data.XYZ;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class LimnScatterValues {
    private final ChartWorld world;
    private final ScatterDataset dataset;
    private final ShadedColor[] paints;

    public static int Width() {
        return LimnScatterValues$.MODULE$.Width();
    }

    public LimnScatterValues(LimnPlot plot, ChartWorld world, DatasetHolder ds) {
        this.world = world;
        this.dataset = (ScatterDataset)ds.getDataset();
        this.paints = plot.getPaints(this.dataset().series().size());
        ((List)this.dataset().series().zipWithIndex()).foreach(((Function2 & Serializable)(Function2 & Serializable)(v1, v2) -> {
            this.$init$$$anonfun$1((ScatterSeries)((Object)((Object)v1)), BoxesRunTime.unboxToInt((Object)v2));
            return BoxedUnit.UNIT;
        }).tupled());
    }

    public ScatterDataset dataset() {
        return this.dataset;
    }

    public ShadedColor[] paints() {
        return this.paints;
    }

    private void buildSeries(ScatterSeries s, int idx) {
        IAxisValues xAxis = this.world.getBottomLeftAxisValues();
        IAxisValues yAxis = this.world.getLeftAxisValues();
        IAxisValues zAxis = this.world.getBottomRightAxisValues();
        ((IterableOnceOps)s.items().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                XYZ xyz = (XYZ)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                int xPos = this.scale(xAxis.getLocation(BoxesRunTime.boxToDouble((double)xyz.x())));
                int yPos = this.scale(yAxis.getLocation(BoxesRunTime.boxToDouble((double)xyz.y())));
                int zPos = this.scale(zAxis.getLocation(BoxesRunTime.boxToDouble((double)xyz.z())));
                this.buildValue("v." + s.key() + "." + i, xPos, yPos, zPos, this.paints()[idx]);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public int scale(double d) {
        return (int)(d * (double)200);
    }

    public void buildValue(String id, int xPos, int yPos, int zPos, ShadedColor color) {
        Polyhedron poly = this.buildPoly(id, xPos, yPos, zPos, color);
        Value value = new Value(this.world, new Point3d(0.0, 0.0, 0.0), new Angle3d(), poly);
        value.setId(id);
    }

    public Polyhedron buildPoly(String id, int xPos, int yPos, int zPos, ShadedColor color) {
        int noPoints = 8;
        double hw = (double)LimnScatterValues$.MODULE$.Width() / 2.0;
        double xa = (double)xPos - hw;
        double xb = (double)xPos + hw;
        double[] x = new double[]{xa, xa, xa, xa, xb, xb, xb, xb};
        double ya = (double)yPos - hw;
        double yb = (double)yPos + hw;
        double[] y = new double[]{ya, yb, yb, ya, ya, yb, yb, ya};
        double za = (double)zPos - hw;
        double zb = (double)zPos + hw;
        double[] z = new double[]{za, za, zb, zb, za, za, zb, zb};
        ArrayOf3dPoints pts = new ArrayOf3dPoints(x, y, z, noPoints);
        int noSides = 6;
        IndexingPolygon[] polygons = new IndexingPolygon[noSides];
        polygons[0] = new RenderedPolygon(id + ".0", new int[]{0, 1, 5, 4}, color);
        polygons[1] = new RenderedPolygon(id + ".1", new int[]{1, 2, 6, 5}, color);
        polygons[2] = new RenderedPolygon(id + ".2", new int[]{2, 3, 7, 6}, color);
        polygons[3] = new RenderedPolygon(id + ".3", new int[]{3, 0, 4, 7}, color);
        polygons[4] = new RenderedPolygon(id + ".4", new int[]{2, 1, 0, 3}, color);
        polygons[5] = new RenderedPolygon(id + ".5", new int[]{4, 5, 6, 7}, color);
        return new Polyhedron(pts, polygons);
    }

    private final /* synthetic */ void $init$$$anonfun$1(ScatterSeries s, int idx) {
        this.buildSeries(s, idx);
    }

    public class Value
    extends Object3d {
        public Value(World world, Point3d pos, Angle3d angle, Polyhedron poly) {
            if (LimnScatterValues.this == null) {
                throw new NullPointerException();
            }
            super(world, pos, angle);
            this.setPolyhedron(poly, new Point3d(1.0, 1.0, 1.0));
        }

        public final /* synthetic */ LimnScatterValues com$elixirtech$chart2$LimnScatterValues$Value$$$outer() {
            return LimnScatterValues.this;
        }
    }
}

