/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.LimnPlot;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.limn.ArrayOf3dPoints;
import com.elixirtech.limn.IndexingPolygon;
import com.elixirtech.limn.Object3d;
import com.elixirtech.limn.Point3d;
import com.elixirtech.limn.Polyhedron;
import com.elixirtech.limn.RangeD;
import com.elixirtech.limn.RenderedPolygon;
import com.elixirtech.limn.ShadedColor;
import com.elixirtech.limn.World;
import com.elixirtech.limn.chart.ChartWorld;
import com.elixirtech.limn.chart.IAxisValues;
import com.elixirtech.limn.chart.NumberAxisValues;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.CategoryDataset;

public class LimnSurfaceValues {
    private LimnPlot m_Plot;
    private ChartWorld m_World;
    private DatasetHolder m_DatasetHolder;
    private CategoryDataset m_Dataset;
    private ShadedColor[] m_Paints;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LimnSurfaceValues.class);

    public LimnSurfaceValues(LimnPlot limnPlot, ChartWorld chartWorld, DatasetHolder datasetHolder) {
        this.m_Plot = limnPlot;
        this.m_World = chartWorld;
        this.m_DatasetHolder = datasetHolder;
        this.m_Dataset = (CategoryDataset)this.m_DatasetHolder.getDataset();
        int n = this.m_Dataset.getRowCount();
        int n2 = this.m_Dataset.getColumnCount();
        IAxisValues iAxisValues = this.m_World.getBottomLeftAxisValues();
        IAxisValues iAxisValues2 = this.m_World.getLeftAxisValues();
        IAxisValues iAxisValues3 = this.m_World.getBottomRightAxisValues();
        this.m_Paints = this.m_Plot.getPaints(iAxisValues2.getPositionCount());
        ArrayList<Value> arrayList = new ArrayList<Value>();
        for (int i = 0; i < n - 1; ++i) {
            Comparable comparable = this.m_Dataset.getRowKey(i);
            Comparable comparable2 = this.m_Dataset.getRowKey(i + 1);
            double d = iAxisValues3.getLocation(comparable) * 200.0;
            double d2 = iAxisValues3.getLocation(comparable2) * 200.0;
            for (int j = 0; j < n2 - 1; ++j) {
                Comparable comparable3 = this.m_Dataset.getColumnKey(j);
                Comparable comparable4 = this.m_Dataset.getColumnKey(j + 1);
                double d3 = iAxisValues.getLocation(comparable3) * 200.0;
                double d4 = iAxisValues.getLocation(comparable4) * 200.0;
                double d5 = this.value(iAxisValues2, comparable, comparable3);
                double d6 = this.value(iAxisValues2, comparable, comparable4);
                double d7 = this.value(iAxisValues2, comparable2, comparable3);
                double d8 = this.value(iAxisValues2, comparable2, comparable4);
                int n3 = 4;
                double[] dArray = new double[n3];
                double[] dArray2 = new double[n3];
                double[] dArray3 = new double[n3];
                dArray3[0] = d;
                dArray[0] = d3;
                dArray2[0] = d5;
                dArray3[1] = d;
                dArray[1] = d4;
                dArray2[1] = d6;
                dArray3[2] = d2;
                dArray[2] = d4;
                dArray2[2] = d8;
                dArray3[3] = d2;
                dArray[3] = d3;
                dArray2[3] = d7;
                ArrayOf3dPoints arrayOf3dPoints = new ArrayOf3dPoints(dArray, dArray2, dArray3, n3);
                IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[]{new RenderedPolygon(new int[]{2, 1, 0, 3}, this.m_Paints[0])};
                Polyhedron polyhedron = new Polyhedron(arrayOf3dPoints, indexingPolygonArray);
                arrayList.add(new Value(this.m_World, new Point3d(), new Angle3d(), polyhedron));
            }
        }
        this.paintValues(arrayList);
    }

    protected void paintValues(List<Value> list) {
        IAxisValues iAxisValues = this.m_World.getLeftAxisValues();
        for (int i = 1; i < this.m_Paints.length - 1; ++i) {
            IAxisValues.Position position = ((NumberAxisValues)iAxisValues).getPosition(i);
            double d = 200.0 * position.location;
            m_Log.debug((Object)("Splitting surface at " + d));
            for (Value value : list) {
                this.splitValueIfNecessary(value, d, this.m_Paints[i]);
            }
        }
    }

    protected void splitValueIfNecessary(Value value, double d, ShadedColor shadedColor) {
        Polyhedron polyhedron = value.getPolyhedron();
        ArrayOf3dPoints arrayOf3dPoints = polyhedron.getVertices();
        int n = polyhedron.getPolygonCount();
        for (int i = 0; i < n; ++i) {
            IndexingPolygon indexingPolygon = polyhedron.getPolygon(i);
            int[] nArray = indexingPolygon.getIndices();
            RangeD rangeD = this.getYRange(nArray, arrayOf3dPoints);
            if (rangeD.max <= d) continue;
            if (rangeD.min >= d) {
                indexingPolygon.setShadedColor(shadedColor.makeClone());
                continue;
            }
            this.splitPolygon(value, indexingPolygon, i, d, shadedColor);
        }
    }

    protected void splitPolygon(Value value, IndexingPolygon indexingPolygon, int n, double d, ShadedColor shadedColor) {
        Polyhedron polyhedron = value.getPolyhedron();
        ArrayOf3dPoints arrayOf3dPoints = polyhedron.getVertices();
        int[] nArray = indexingPolygon.getIndices();
        double d2 = arrayOf3dPoints.y[nArray[0]];
        if (d2 <= d) {
            int n2;
            int n3 = this.firstYAbove(arrayOf3dPoints, nArray, 1, d);
            if (n3 < 0) {
                m_Log.error((Object)"Can't split - firstYAbove is -ve");
                return;
            }
            int n4 = this.firstYBelow(arrayOf3dPoints, nArray, n3 + 1, d);
            if (n4 < 0) {
                n4 = 0;
            }
            Point3d point3d = LimnSurfaceValues.getYPoint(arrayOf3dPoints.getPoint(nArray[n3 - 1]), arrayOf3dPoints.getPoint(nArray[n3]), d);
            Point3d point3d2 = LimnSurfaceValues.getYPoint(arrayOf3dPoints.getPoint(nArray[LimnSurfaceValues.wrap(n4 - 1, nArray)]), arrayOf3dPoints.getPoint(nArray[n4]), d);
            ArrayOf3dPoints arrayOf3dPoints2 = new ArrayOf3dPoints(2);
            arrayOf3dPoints2.setPoint(0, point3d);
            arrayOf3dPoints2.setPoint(1, point3d2);
            IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[polyhedron.getPolygonCount() + 1];
            for (n2 = 0; n2 < n; ++n2) {
                indexingPolygonArray[n2] = polyhedron.getPolygon(n2).makeClone();
            }
            for (n2 = n + 1; n2 < polyhedron.getPolygonCount(); ++n2) {
                indexingPolygonArray[n2 + 1] = polyhedron.getPolygon(n2).makeClone();
            }
            int[] nArray2 = LimnSurfaceValues.buildFirstLoop(nArray, n3, n4, arrayOf3dPoints.npoints);
            int[] nArray3 = LimnSurfaceValues.buildLastLoop(nArray, n3, n4, arrayOf3dPoints.npoints);
            indexingPolygonArray[n] = new RenderedPolygon(nArray2, indexingPolygon.getShadedColor().makeClone());
            indexingPolygonArray[n + 1] = new RenderedPolygon(nArray3, shadedColor.makeClone());
            Polyhedron polyhedron2 = new Polyhedron(new ArrayOf3dPoints(arrayOf3dPoints, arrayOf3dPoints2), indexingPolygonArray);
            value.setPolyhedron(polyhedron2);
        } else {
            int n5;
            int n6 = this.firstYBelow(arrayOf3dPoints, nArray, 1, d);
            if (n6 < 0) {
                m_Log.error((Object)"Can't split - firstYBelow is -ve");
                return;
            }
            int n7 = this.firstYAbove(arrayOf3dPoints, nArray, n6 + 1, d);
            if (n7 < 0) {
                n7 = 0;
            }
            Point3d point3d = LimnSurfaceValues.getYPoint(arrayOf3dPoints.getPoint(nArray[n6 - 1]), arrayOf3dPoints.getPoint(nArray[n6]), d);
            Point3d point3d3 = LimnSurfaceValues.getYPoint(arrayOf3dPoints.getPoint(nArray[LimnSurfaceValues.wrap(n7 - 1, nArray)]), arrayOf3dPoints.getPoint(nArray[n7]), d);
            ArrayOf3dPoints arrayOf3dPoints3 = new ArrayOf3dPoints(2);
            arrayOf3dPoints3.setPoint(0, point3d);
            arrayOf3dPoints3.setPoint(1, point3d3);
            IndexingPolygon[] indexingPolygonArray = new IndexingPolygon[polyhedron.getPolygonCount() + 1];
            for (n5 = 0; n5 < n; ++n5) {
                indexingPolygonArray[n5] = polyhedron.getPolygon(n5).makeClone();
            }
            for (n5 = n + 1; n5 < polyhedron.getPolygonCount(); ++n5) {
                indexingPolygonArray[n5 + 1] = polyhedron.getPolygon(n5).makeClone();
            }
            int[] nArray4 = LimnSurfaceValues.buildFirstLoop(nArray, n6, n7, arrayOf3dPoints.npoints);
            int[] nArray5 = LimnSurfaceValues.buildLastLoop(nArray, n6, n7, arrayOf3dPoints.npoints);
            indexingPolygonArray[n] = new RenderedPolygon(nArray4, shadedColor.makeClone());
            indexingPolygonArray[n + 1] = new RenderedPolygon(nArray5, indexingPolygon.getShadedColor().makeClone());
            Polyhedron polyhedron3 = new Polyhedron(new ArrayOf3dPoints(arrayOf3dPoints, arrayOf3dPoints3), indexingPolygonArray);
            value.setPolyhedron(polyhedron3);
        }
    }

    private static int[] buildFirstLoop(int[] nArray, int n, int n2, int n3) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n4 = 0;
        while (n4 < n) {
            arrayList.add(nArray[n4++]);
        }
        arrayList.add(n3);
        arrayList.add(n3 + 1);
        if (n2 > 0) {
            n4 = n2;
            while (n4 < nArray.length) {
                arrayList.add(nArray[n4++]);
            }
        }
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        if (nArray2.length < 3) {
            throw new IllegalArgumentException("buildFirstLoop first=" + n + " last=" + n2);
        }
        return nArray2;
    }

    private static int[] buildLastLoop(int[] nArray, int n, int n2, int n3) {
        if (n2 == 0) {
            n2 = nArray.length;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(n3);
        int n4 = n;
        while (n4 < n2) {
            arrayList.add(nArray[n4++]);
        }
        arrayList.add(n3 + 1);
        int[] nArray2 = new int[arrayList.size()];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[i] = (Integer)arrayList.get(i);
        }
        if (nArray2.length < 3) {
            throw new IllegalArgumentException("buildLastLoop first=" + n + " last=" + n2);
        }
        return nArray2;
    }

    private static int wrap(int n, int[] nArray) {
        while (n < 0) {
            n += nArray.length;
        }
        while (n >= nArray.length) {
            n -= nArray.length;
        }
        return n;
    }

    protected static Point3d getYPoint(Point3d point3d, Point3d point3d2, double d) {
        double d2 = point3d2.y - point3d.y;
        double d3 = d - point3d.y;
        double d4 = d3 / d2;
        double d5 = point3d.x + (point3d2.x - point3d.x) * d4;
        double d6 = point3d.z + (point3d2.z - point3d.z) * d4;
        return new Point3d(d5, d, d6);
    }

    protected int firstYAbove(ArrayOf3dPoints arrayOf3dPoints, int[] nArray, int n, double d) {
        for (int i = n; i < nArray.length; ++i) {
            double d2 = arrayOf3dPoints.y[nArray[i]];
            if (!(d2 >= d)) continue;
            return i;
        }
        return -1;
    }

    protected int firstYBelow(ArrayOf3dPoints arrayOf3dPoints, int[] nArray, int n, double d) {
        for (int i = n; i < nArray.length; ++i) {
            double d2 = arrayOf3dPoints.y[nArray[i]];
            if (!(d2 <= d)) continue;
            return i;
        }
        return -1;
    }

    protected RangeD getYRange(int[] nArray, ArrayOf3dPoints arrayOf3dPoints) {
        double d;
        double d2 = d = arrayOf3dPoints.y[nArray[0]];
        for (int i = 1; i < nArray.length; ++i) {
            double d3 = arrayOf3dPoints.y[nArray[i]];
            if (d3 < d) {
                d = d3;
                continue;
            }
            if (!(d3 > d2)) continue;
            d2 = d3;
        }
        return new RangeD(d, d2);
    }

    private double value(IAxisValues iAxisValues, Comparable comparable, Comparable comparable2) {
        try {
            Number number = this.m_Dataset.getValue(comparable, comparable2);
            if (number != null) {
                return iAxisValues.getLocation(number) * 200.0;
            }
        }
        catch (UnknownKeyException unknownKeyException) {
            // empty catch block
        }
        return 0.0;
    }

    private static class Value
    extends Object3d {
        public Value(World world, Point3d point3d, Angle3d angle3d, Polyhedron polyhedron) {
            super(world, point3d, angle3d);
            this.setPolyhedron(polyhedron);
        }

        public void setPolyhedron(Polyhedron polyhedron) {
            super.setPolyhedron(polyhedron, new Point3d(1.0, 1.0, 1.0));
        }
    }
}

