/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.custom;

import com.elixirtech.chart2.custom.ITickUnit;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class TickUnitFactory {
    private static ITickUnit MONTH0 = new MonthTU(Locale.getDefault(), true, false);
    private static ITickUnit MONTH1 = new MonthTU(Locale.getDefault(), false, false);
    private static ITickUnit SMONTH0 = new MonthTU(Locale.getDefault(), true, true);
    private static ITickUnit SMONTH1 = new MonthTU(Locale.getDefault(), false, true);
    private static ITickUnit DAY0 = new DayTU(Locale.getDefault(), true, false);
    private static ITickUnit DAY1 = new DayTU(Locale.getDefault(), false, false);
    private static ITickUnit SDAY0 = new DayTU(Locale.getDefault(), true, true);
    private static ITickUnit SDAY1 = new DayTU(Locale.getDefault(), false, true);

    public static ITickUnit getMonths(boolean bl) {
        if (bl) {
            return MONTH0;
        }
        return MONTH1;
    }

    public static ITickUnit getShortMonths(boolean bl) {
        if (bl) {
            return SMONTH0;
        }
        return SMONTH1;
    }

    public static ITickUnit getWeekdays(boolean bl) {
        if (bl) {
            return DAY0;
        }
        return DAY1;
    }

    public static ITickUnit getShortWeekdays(boolean bl) {
        if (bl) {
            return SDAY0;
        }
        return SDAY1;
    }

    public static ITickUnit getMonths(boolean bl, Locale locale) {
        return new MonthTU(locale, bl, false);
    }

    public static ITickUnit getShortMonths(boolean bl, Locale locale) {
        return new MonthTU(locale, bl, true);
    }

    public static ITickUnit getWeekdays(boolean bl, Locale locale) {
        return new DayTU(locale, bl, false);
    }

    public static ITickUnit getShortWeekdays(boolean bl, Locale locale) {
        return new MonthTU(locale, bl, true);
    }

    private static class MonthTU
    implements ITickUnit {
        private Locale m_Locale;
        private boolean m_ZeroBased;
        private boolean m_Short;

        public MonthTU(Locale locale, boolean bl, boolean bl2) {
            this.m_Locale = locale;
            this.m_ZeroBased = bl;
            this.m_Short = bl2;
        }

        @Override
        public String valueToString(double d) {
            if (!this.m_ZeroBased) {
                d -= 1.0;
            }
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.m_Locale);
            int n = (int)(d % 12.0);
            if (this.m_Short) {
                return dateFormatSymbols.getShortMonths()[n];
            }
            return dateFormatSymbols.getMonths()[n];
        }
    }

    private static class DayTU
    implements ITickUnit {
        private Locale m_Locale;
        private boolean m_ZeroBased;
        private boolean m_Short;

        public DayTU(Locale locale, boolean bl, boolean bl2) {
            this.m_Locale = locale;
            this.m_ZeroBased = bl;
            this.m_Short = bl2;
        }

        @Override
        public String valueToString(double d) {
            if (!this.m_ZeroBased) {
                d -= 1.0;
            }
            DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.m_Locale);
            int n = (int)(d % 7.0) + 1;
            if (this.m_Short) {
                return dateFormatSymbols.getShortWeekdays()[n];
            }
            return dateFormatSymbols.getWeekdays()[n];
        }
    }
}

