/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.CategoryDatasetAdapter;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.data.FunctionHolder;
import com.elixirtech.chart2.model.ControlSourceList;
import com.elixirtech.chart2.model.PieType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.function.First;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.raw.model.ControlSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DefaultPieDataset;
import org.mozilla.javascript.Scriptable;

public class PieDatasetAdapter {
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getPieData(DataTable dataTable, PieType pieType, String string) {
        if ("Pie".equals(string) || "Pie-Ring".equals(string) || "Pie-3D".equals(string)) {
            return PieDatasetAdapter.getPieData(dataTable, pieType);
        }
        return CategoryDatasetAdapter.getCategoryData(dataTable, pieType);
    }

    private static DatasetHolder getPieData(DataTable dataTable, PieType pieType) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n;
        Object object5;
        Object object6;
        Object object7;
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataRecord[] dataRecordArray = dataTable.getRecords();
        DataSchema dataSchema = dataTable.getSchema();
        ControlSource controlSource = pieType.getKeySource();
        ControlSourceList controlSourceList = pieType.getValueSource();
        ControlSource controlSource2 = controlSourceList.getControlSource(0);
        int n2 = -1;
        int n3 = -1;
        CompiledScript compiledScript = null;
        Function function = new First();
        CompiledScript compiledScript2 = null;
        if ("Field".equals(controlSource.getType())) {
            n2 = dataSchema.getColumnIndex(controlSource.getField());
        } else if ("Script".equals(controlSource.getType())) {
            object7 = controlSource.getText();
            if (((String)object7).startsWith("=")) {
                object7 = ((String)object7).substring(1);
            }
            compiledScript = javaScriptEngine.compile("key script", (String)object7);
        }
        if ("Field".equals(controlSource2.getType())) {
            n3 = dataSchema.getColumnIndex(controlSource2.getField());
        } else if ("Operation".equals(controlSource2.getType())) {
            object7 = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
            function = object7.getFunction((DataType)(object6 = dataSchema.getColumnType(n3 = dataSchema.getColumnIndex(controlSource2.getField()))), controlSource2.getOperation());
            if (function instanceof RangedFunction) {
                object5 = (RangedFunction)function;
                dataTable.setRange((RangedFunction)object5, dataTable.getGroups(), n3);
            }
        } else if ("Script".equals(controlSource2.getType())) {
            object7 = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
            object6 = controlSource2.getText();
            if (((String)object6).startsWith("=")) {
                object6 = ((String)object6).substring(1);
            }
            compiledScript2 = javaScriptEngine.compile("value script", (String)object6);
            function = object7.getFunction(ControlSourceProcessor.SCRIPT_DATA_TYPE, controlSource2.getOperation());
        }
        object7 = new ArrayList();
        object6 = new HashMap();
        object5 = new ChartData(dataTable);
        RecordScope recordScope = DataUtil.createRecordScope((ChartData)object5);
        boolean bl = false;
        for (n = 0; n < dataRecordArray.length; ++n) {
            block26: {
                block25: {
                    ((ChartData)object5).setRecordIndex(n);
                    object4 = dataRecordArray[n].getData();
                    recordScope.setData((Object[])object4);
                    object3 = null;
                    if (n2 >= 0) {
                        object3 = object4[n2];
                    } else if (compiledScript != null) {
                        try {
                            object3 = compiledScript.eval((Scriptable)recordScope);
                        }
                        catch (ScriptException scriptException) {
                            if (bl) break block25;
                            m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                            bl = true;
                        }
                    }
                }
                if (object3 == null) continue;
                object2 = null;
                if (n3 >= 0) {
                    object2 = object4[n3];
                } else if (compiledScript2 != null) {
                    try {
                        object2 = compiledScript2.eval((Scriptable)recordScope);
                    }
                    catch (ScriptException scriptException) {
                        if (bl) break block26;
                        m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                        bl = true;
                    }
                }
            }
            object = (FunctionHolder)object6.get(object3);
            if (object == null) {
                object = new FunctionHolder((Function)function.clone());
                object6.put(object3, object);
                object7.add(object3);
            }
            ((FunctionHolder)object).update(dataRecordArray[n], object2);
        }
        int n4 = n = !pieType.isRetainKeyOrder() ? 1 : 0;
        if (n != 0) {
            Collections.sort(object7, new SafeComparator());
        }
        object4 = new HashMap();
        object3 = new DefaultPieDataset();
        object2 = object7.iterator();
        while (object2.hasNext()) {
            object = object2.next();
            FunctionHolder functionHolder = (FunctionHolder)object6.get(object);
            Object object8 = functionHolder.getResult();
            if (!(object instanceof Comparable) || !(object8 instanceof Number)) continue;
            object3.setValue((Comparable)object, (Number)object8);
            ((HashMap)object4).put(object, functionHolder.getRecords());
        }
        object = new DatasetHolder((Dataset)object3);
        ((DatasetHolder)object).setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, pieType.getTitle()));
        ((DatasetHolder)object).setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, pieType.getLegend()));
        ((DatasetHolder)object).setReverseMapping((Map)object4);
        ((DatasetHolder)object).setSchema(dataTable.getSchema());
        ((DatasetHolder)object).setKeyIndex(n2);
        return object;
    }

    private static class SafeComparator
    implements Comparator<Object> {
        private SafeComparator() {
        }

        @Override
        public int compare(Object object, Object object2) {
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return ((Comparable)object).compareTo(object2);
        }
    }
}

