/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.data.ChartData;
import com.elixirtech.chart2.data.DataUtil;
import com.elixirtech.chart2.model.WindRoseType;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.windrose.BeaufortScale;
import com.elixirtech.chart2.windrose.WindRoseDataset;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.RecordScope;
import com.elixirtech.data2.function.First;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.data2.function.RangedFunction;
import com.elixirtech.js.CompiledScript;
import com.elixirtech.js.JavaScriptEngine;
import com.elixirtech.js.ScriptException;
import com.elixirtech.report2.raw.model.ControlSource;
import java.util.ArrayList;
import org.jfree.data.general.Dataset;
import org.mozilla.javascript.Scriptable;

public class WindRoseDatasetAdapter {
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    public static DatasetHolder getWindData(DataTable dataTable, WindRoseType windRoseType) {
        JavaScriptEngine javaScriptEngine = JavaScriptEngine.getInstance();
        DataRecord[] dataRecordArray = dataTable.getRecords();
        Value value = WindRoseDatasetAdapter.buildValue(javaScriptEngine, dataTable, windRoseType.getDirectionSource());
        Value value2 = WindRoseDatasetAdapter.buildValue(javaScriptEngine, dataTable, windRoseType.getForceSource());
        ChartData chartData = new ChartData(dataTable);
        RecordScope recordScope = DataUtil.createRecordScope(chartData);
        BeaufortScale beaufortScale = new BeaufortScale();
        ArrayList<WindRoseDataset.Datum> arrayList = new ArrayList<WindRoseDataset.Datum>();
        for (int i = 0; i < dataRecordArray.length; ++i) {
            chartData.setRecordIndex(i);
            Object[] objectArray = dataRecordArray[i].getData();
            recordScope.setData(objectArray);
            Object object = value.getValue(recordScope);
            Object object2 = value2.getValue(recordScope);
            if (!(object instanceof Number) || !(object2 instanceof Number)) continue;
            int n = ((Number)object).intValue() % 360;
            double d = ((Number)object2).doubleValue();
            WindRoseDataset.Datum datum = new WindRoseDataset.Datum(beaufortScale, d, n);
            arrayList.add(datum);
        }
        DatasetHolder datasetHolder = new DatasetHolder((Dataset)new WindRoseDataset(arrayList));
        datasetHolder.setTitle(DataUtil.buildChartText(javaScriptEngine, dataTable, windRoseType.getTitle()));
        datasetHolder.setLegend(DataUtil.buildChartText(javaScriptEngine, dataTable, windRoseType.getLegend()));
        datasetHolder.setSchema(dataTable.getSchema());
        return datasetHolder;
    }

    private static Value buildValue(JavaScriptEngine javaScriptEngine, DataTable dataTable, ControlSource controlSource) {
        Value value = new Value();
        DataSchema dataSchema = dataTable.getSchema();
        if ("Field".equals(controlSource.getType())) {
            value.valueIdx = dataSchema.getColumnIndex(controlSource.getField());
        } else if ("Operation".equals(controlSource.getType())) {
            IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
            value.valueIdx = dataSchema.getColumnIndex(controlSource.getField());
            DataType dataType = dataSchema.getColumnType(value.valueIdx);
            value.valueFn = iFunctionFactory.getFunction(dataType, controlSource.getOperation());
            if (value.valueFn instanceof RangedFunction) {
                RangedFunction rangedFunction = (RangedFunction)value.valueFn;
                dataTable.setRange(rangedFunction, dataTable.getGroups(), value.valueIdx);
            }
        } else if ("Script".equals(controlSource.getType())) {
            String string = controlSource.getText();
            if (string.startsWith("=")) {
                string = string.substring(1);
            }
            value.valueScript = javaScriptEngine.compile("value script", string);
        }
        return value;
    }

    private static class Value {
        public int valueIdx = -1;
        public String displayName;
        public Function valueFn = new First();
        public CompiledScript valueScript;
        private boolean m_WarnedOfScriptError = false;

        private Value() {
        }

        public Object getValue(RecordScope recordScope) {
            block4: {
                if (this.valueIdx >= 0) {
                    return recordScope.getData(this.valueIdx);
                }
                if (this.valueScript != null) {
                    try {
                        return this.valueScript.eval((Scriptable)recordScope);
                    }
                    catch (ScriptException scriptException) {
                        if (this.m_WarnedOfScriptError) break block4;
                        m_JSLog.warn((Object)("Script error: " + String.valueOf(scriptException)));
                        this.m_WarnedOfScriptError = true;
                    }
                }
            }
            return null;
        }
    }
}

