/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.custom.CylinderRenderer;
import com.elixirtech.chart2.data.ElxCategoryDataset;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.CategoryType;
import com.elixirtech.chart2.model.CategoryUi;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Label;
import com.elixirtech.chart2.model.Legend;
import com.elixirtech.chart2.model.Painter;
import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.model.Value;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.ElxCategoryPlot;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.chart2.renderer.ItemAnchorUtil;
import com.elixirtech.chart2.renderer.TextAnchorUtil;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.StandardPaint;
import java.awt.Color;
import java.awt.Paint;
import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryAxis3D;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberAxis3D;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarPainter;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.renderer.category.StackedAreaRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.renderer.category.StandardBarPainter;
import org.jfree.chart.renderer.category.WaterfallBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;
import org.jfree.util.SortOrder;

public class CategoryRenderer
extends Abstract2DChartRenderer {
    protected boolean m_CustomedPaint;
    protected CategoryType m_CategoryType;

    public CategoryRenderer(IChart iChart) {
        super(iChart);
        this.m_CategoryType = (CategoryType)iChart.getChartType();
        this.m_CustomedPaint = this.m_CategoryType.getLegend().isCustomPaint();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        ElxCategoryPlot elxCategoryPlot = this.getPlot(object, datasetHolder);
        JFreeChart jFreeChart = new JFreeChart((Plot)elxCategoryPlot);
        CategoryRenderer.setLegend(jFreeChart, this.m_CategoryType.getLegend(), datasetHolder.getLegend());
        CategoryRenderer.setTitle(jFreeChart, this.m_CategoryType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        CategoryRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }

    public ElxCategoryPlot getPlot(Object object, DatasetHolder datasetHolder) throws ChartException {
        ElxCategoryPlot elxCategoryPlot = null;
        String string = this.m_Chart.getType();
        CategoryUi categoryUi = this.m_CategoryType.getCategoryUi();
        if (string.startsWith("Column")) {
            elxCategoryPlot = this.getColumn(string, (CategoryDataset)datasetHolder.getDataset(), this.m_CustomedPaint);
            if (string.indexOf("Stacked") < 0) {
                this.setSubCategory(elxCategoryPlot, datasetHolder, categoryUi.getKeyAxis());
            }
        } else if (string.startsWith("3DColumn")) {
            elxCategoryPlot = this.getColumn(string, (CategoryDataset)datasetHolder.getDataset(), this.m_CustomedPaint);
        } else if (string.startsWith("Bar")) {
            elxCategoryPlot = this.getBar(string, (CategoryDataset)datasetHolder.getDataset(), this.m_CustomedPaint);
            if (string.indexOf("Stacked") < 0) {
                this.setSubCategory(elxCategoryPlot, datasetHolder, categoryUi.getKeyAxis());
            }
        } else if (string.startsWith("Area")) {
            elxCategoryPlot = this.getArea(string, (CategoryDataset)datasetHolder.getDataset());
        } else if (string.startsWith("3DArea")) {
            elxCategoryPlot = this.getArea(string, (CategoryDataset)datasetHolder.getDataset());
        } else if (string.startsWith("Line")) {
            elxCategoryPlot = this.getLine(string, (CategoryDataset)datasetHolder.getDataset());
        } else if (string.startsWith("3DLine")) {
            elxCategoryPlot = this.getLine(string, (CategoryDataset)datasetHolder.getDataset());
        } else if (string.startsWith("Waterfall")) {
            elxCategoryPlot = this.getWaterfall(string, (CategoryDataset)datasetHolder.getDataset(), this.m_CustomedPaint, this.m_CategoryType.getLegend());
        } else {
            throw new ChartException("No such chart type, " + string);
        }
        elxCategoryPlot.setBackgroundPaint(StandardColor.lookup(categoryUi.getPlotBackground(), (Color)null));
        this.setRangeAxis(elxCategoryPlot, categoryUi.getValueAxis());
        this.setDomainAxis(elxCategoryPlot, categoryUi.getKeyAxis());
        elxCategoryPlot.setDomainGridlinesVisible(categoryUi.isDomainGridlinesVisible());
        elxCategoryPlot.setRangeGridlinesVisible(categoryUi.isRangeGridlinesVisible());
        CategoryRenderer.setValue(this.m_Chart, elxCategoryPlot, categoryUi);
        return elxCategoryPlot;
    }

    public void setSubCategory(ElxCategoryPlot elxCategoryPlot, DatasetHolder datasetHolder, Axis axis) {
        Object object2;
        Map<Object, Object> map = datasetHolder.getGroupValues();
        if (map == null || map.size() < 1) {
            return;
        }
        SubCategoryAxis subCategoryAxis = new SubCategoryAxis("");
        Collection<Object> collection = map.values();
        for (Object object2 : collection) {
            subCategoryAxis.addSubCategory((Comparable)((Object)object2.toString()));
        }
        Tick tick = axis.getTick();
        object2 = tick.getFont();
        if (object2 != null && ((Font)object2).getFontFamily() != null) {
            subCategoryAxis.setSubLabelFont(((Font)object2).getAWTFont());
            subCategoryAxis.setSubLabelPaint((Paint)StandardColor.lookup(((Font)object2).getFontColor(), Color.BLACK));
        }
        elxCategoryPlot.setDomainAxis((CategoryAxis)subCategoryAxis);
    }

    public void setIntervalMarker(ElxCategoryPlot elxCategoryPlot, CategoryType categoryType) {
        if (this.m_CategoryType.getIntervalMarkerCount() < 1) {
            return;
        }
        List<com.elixirtech.chart2.model.IntervalMarker> list = categoryType.getIntervalMarkerList();
        for (com.elixirtech.chart2.model.IntervalMarker intervalMarker : list) {
            if (!intervalMarker.isEnabled()) continue;
            IntervalMarker intervalMarker2 = new IntervalMarker((double)intervalMarker.getStart(), (double)intervalMarker.getEnd());
            intervalMarker2.setAlpha(intervalMarker.getAlpha());
            Label label = intervalMarker.getLabel();
            String string = label.getText();
            Color color = StandardColor.lookup(intervalMarker.getPaint());
            intervalMarker2.setPaint((Paint)color);
            if (!StringUtil.isEmpty(string)) {
                intervalMarker2.setLabel(string);
                this.setLabelAnchor((Marker)intervalMarker2, intervalMarker.getLabelAnchor());
                Color color2 = StandardColor.lookup(label.getFont().getFontColor());
                intervalMarker2.setLabelPaint((Paint)color2);
                Font font = intervalMarker.getLabel().getFont();
                intervalMarker2.setLabelFont(font.getAWTFont());
            }
            elxCategoryPlot.addRangeMarker((Marker)intervalMarker2);
        }
    }

    private void setLabelAnchor(Marker marker, String string) {
        if ("Northwest".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            marker.setLabelTextAnchor(TextAnchor.TOP_LEFT);
        } else if ("Northeast".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        } else if ("North".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.TOP);
            marker.setLabelTextAnchor(TextAnchor.TOP_CENTER);
        } else if ("West".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.LEFT);
            marker.setLabelTextAnchor(TextAnchor.CENTER_LEFT);
        } else if ("East".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.RIGHT);
            marker.setLabelTextAnchor(TextAnchor.CENTER_RIGHT);
        } else if ("Southwest".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.BOTTOM_LEFT);
            marker.setLabelTextAnchor(TextAnchor.BOTTOM_LEFT);
        } else if ("South".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.BOTTOM);
            marker.setLabelTextAnchor(TextAnchor.BOTTOM_CENTER);
        } else if ("Southeast".equals(string)) {
            marker.setLabelAnchor(RectangleAnchor.BOTTOM_RIGHT);
            marker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        }
    }

    public static void setValue(IChart iChart, ElxCategoryPlot elxCategoryPlot, CategoryUi categoryUi) {
        Serializable serializable;
        Serializable serializable2;
        String string = iChart.getType();
        Value value = categoryUi.getValue();
        if (value == null) {
            return;
        }
        if (!value.isVisible()) {
            return;
        }
        CategoryItemRenderer categoryItemRenderer = elxCategoryPlot.getRenderer();
        Format format = (Format)value.getFormat();
        NumberFormat numberFormat = null;
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = null;
        if (Formatter.notNone(format)) {
            numberFormat = Formatter.buildNumberFormatter(format, CategoryRenderer.getLocale(iChart, format));
            standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", numberFormat);
        } else {
            standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator();
        }
        Font font = value.getFont();
        if (font != null) {
            serializable2 = font.getAWTFont();
            categoryItemRenderer.setBaseItemLabelFont(serializable2);
            serializable = StandardColor.lookup(font.getFontColor());
            categoryItemRenderer.setBaseItemLabelPaint((Paint)((Object)serializable));
        }
        categoryItemRenderer.setBaseItemLabelGenerator((CategoryItemLabelGenerator)standardCategoryItemLabelGenerator);
        serializable2 = categoryUi.getPositivePosition();
        if (serializable2 == null) {
            serializable2 = CategoryRenderer.getPositivePosition(string);
        }
        categoryItemRenderer.setBasePositiveItemLabelPosition(CategoryRenderer.build((Position)serializable2));
        serializable = categoryUi.getNegativePosition();
        if (serializable == null) {
            serializable = CategoryRenderer.getNegativePosition(string);
        }
        categoryItemRenderer.setBaseNegativeItemLabelPosition(CategoryRenderer.build((Position)serializable));
        categoryItemRenderer.setBaseItemLabelsVisible(true);
    }

    public static ItemLabelPosition build(Position position) {
        ItemLabelAnchor itemLabelAnchor = ItemAnchorUtil.lookup(position.getPosition());
        TextAnchor textAnchor = TextAnchorUtil.lookup(position.getAnchor());
        TextAnchor textAnchor2 = TextAnchorUtil.lookup(position.getPivot());
        double d = Math.PI * 2 * (double)position.getAngle() / 360.0;
        return new ItemLabelPosition(itemLabelAnchor, textAnchor, textAnchor2, d);
    }

    public static Position getPositivePosition(String string) {
        Position position = new Position();
        if (string.startsWith("Column")) {
            position.setPosition("Outside1");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else if (string.startsWith("Bar")) {
            position.setPosition("Outside3");
            position.setAnchor("Half Ascent Left");
            position.setPivot("Half Ascent Left");
        } else if (string.startsWith("Area")) {
            position.setPosition("Outside1");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else if (string.startsWith("Line")) {
            position.setPosition("Outside1");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else if (string.startsWith("Waterfall")) {
            position.setPosition("Outside1");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else {
            position.setPosition("Outside1");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        }
        return position;
    }

    public static Position getNegativePosition(String string) {
        Position position = new Position();
        if (string.startsWith("Column")) {
            position.setPosition("Outside6");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else if (string.startsWith("Bar")) {
            position.setPosition("Outside9");
            position.setAnchor("Half Ascent Right");
            position.setPivot("Half Ascent Right");
        } else if (string.startsWith("Area")) {
            position.setPosition("Outside6");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else if (string.startsWith("Line")) {
            position.setPosition("Outside6");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else if (string.startsWith("Waterfall")) {
            position.setPosition("Outside6");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        } else {
            position.setPosition("Outside6");
            position.setAnchor("Baseline");
            position.setPivot("Baseline");
        }
        return position;
    }

    private ElxCategoryPlot getColumn(String string, CategoryDataset categoryDataset, boolean bl) throws ChartException {
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE12, TextAnchor.BOTTOM_CENTER);
        ItemLabelPosition itemLabelPosition2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE6, TextAnchor.TOP_CENTER);
        Object object = null;
        CategoryAxis categoryAxis = null;
        NumberAxis numberAxis = null;
        if ("Column".equals(string)) {
            object = new BarRenderer();
            object.setBasePositiveItemLabelPosition(itemLabelPosition);
            object.setBaseNegativeItemLabelPosition(itemLabelPosition2);
            categoryAxis = new CategoryAxis();
            numberAxis = new NumberAxis();
        } else if ("Column-3D".equals(string) || "Column-Cylinder".equals(string)) {
            object = "Column-Cylinder".equals(string) ? new CylinderRenderer() : new BarRenderer3D();
            object.setBasePositiveItemLabelPosition(itemLabelPosition);
            object.setBaseNegativeItemLabelPosition(itemLabelPosition2);
            categoryAxis = new CategoryAxis3D();
            numberAxis = new NumberAxis3D();
        } else if ("Column-Stacked".equals(string)) {
            object = new StackedBarRenderer();
            categoryAxis = new CategoryAxis();
            numberAxis = new NumberAxis();
        } else if ("Column-Stacked-Percentage".equals(string)) {
            categoryDataset = this.getCumulativePercentage((Dataset)categoryDataset);
            object = new StackedBarRenderer();
            categoryAxis = new CategoryAxis();
            numberAxis = new NumberAxis();
        } else {
            throw new ChartException("Unable to locate chart type, " + string);
        }
        object.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        if (bl) {
            object.setBarPainter((BarPainter)new StandardBarPainter());
        }
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot(categoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)object);
        this.setIntervalMarker(elxCategoryPlot, this.m_CategoryType);
        if ("Column-3D".equals(string)) {
            elxCategoryPlot.setForegroundAlpha(0.75f);
        }
        elxCategoryPlot.setOrientation(PlotOrientation.VERTICAL);
        return elxCategoryPlot;
    }

    private ElxCategoryPlot getBar(String string, CategoryDataset categoryDataset, boolean bl) throws ChartException {
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE3, TextAnchor.CENTER_LEFT);
        ItemLabelPosition itemLabelPosition2 = new ItemLabelPosition(ItemLabelAnchor.OUTSIDE9, TextAnchor.CENTER_RIGHT);
        Object object = null;
        CategoryAxis categoryAxis = null;
        NumberAxis numberAxis = null;
        if ("Bar".equals(string)) {
            object = new BarRenderer();
            object.setBasePositiveItemLabelPosition(itemLabelPosition);
            object.setBaseNegativeItemLabelPosition(itemLabelPosition2);
            categoryAxis = new CategoryAxis();
            numberAxis = new NumberAxis();
        } else if ("Bar-3D".equals(string) || "Bar-Cylinder".equals(string)) {
            object = "Bar-Cylinder".equals(string) ? new CylinderRenderer() : new BarRenderer3D();
            object.setBasePositiveItemLabelPosition(itemLabelPosition);
            object.setBaseNegativeItemLabelPosition(itemLabelPosition2);
            categoryAxis = new CategoryAxis3D();
            numberAxis = new NumberAxis3D();
        } else if ("Bar-Stacked".equals(string)) {
            object = new StackedBarRenderer();
            categoryAxis = new CategoryAxis();
            numberAxis = new NumberAxis();
        } else if ("Bar-Stacked-Percentage".equals(string)) {
            categoryDataset = this.getCumulativePercentage((Dataset)categoryDataset);
            object = new StackedBarRenderer();
            categoryAxis = new CategoryAxis();
            numberAxis = new NumberAxis();
        } else {
            throw new ChartException("Unable to locate chart type, " + string);
        }
        object.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        if (bl) {
            object.setBarPainter((BarPainter)new StandardBarPainter());
        }
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot(categoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)object);
        this.setIntervalMarker(elxCategoryPlot, this.m_CategoryType);
        if ("Bar-3D".equals(string)) {
            elxCategoryPlot.setForegroundAlpha(0.75f);
        }
        elxCategoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        elxCategoryPlot.setRowRenderingOrder(SortOrder.DESCENDING);
        elxCategoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        return elxCategoryPlot;
    }

    private ElxCategoryPlot getArea(String string, CategoryDataset categoryDataset) throws ChartException {
        AreaRenderer areaRenderer = null;
        CategoryAxis categoryAxis = null;
        NumberAxis numberAxis = null;
        if ("Area".equals(string)) {
            categoryAxis = new CategoryAxis();
            categoryAxis.setCategoryMargin(0.0);
            numberAxis = new NumberAxis();
            areaRenderer = new AreaRenderer();
        } else if ("Area-Stacked".equals(string)) {
            categoryAxis = new CategoryAxis();
            categoryAxis.setCategoryMargin(0.0);
            numberAxis = new NumberAxis();
            areaRenderer = new StackedAreaRenderer();
        } else if ("Area-Stacked-Percentage".equals(string)) {
            categoryDataset = this.getCumulativePercentage((Dataset)categoryDataset);
            categoryAxis = new CategoryAxis();
            categoryAxis.setCategoryMargin(0.0);
            numberAxis = new NumberAxis();
            areaRenderer = new StackedAreaRenderer();
        } else {
            throw new ChartException("Unable to locate chart type, " + string);
        }
        areaRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot(categoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)areaRenderer);
        this.setIntervalMarker(elxCategoryPlot, this.m_CategoryType);
        if ("Area".equals(string)) {
            elxCategoryPlot.setForegroundAlpha(0.5f);
        }
        elxCategoryPlot.setOrientation(PlotOrientation.VERTICAL);
        return elxCategoryPlot;
    }

    private ElxCategoryPlot getLine(String string, CategoryDataset categoryDataset) throws ChartException {
        CategoryAxis categoryAxis = new CategoryAxis();
        NumberAxis numberAxis = new NumberAxis();
        LineAndShapeRenderer lineAndShapeRenderer = null;
        if ("Line".equals(string)) {
            lineAndShapeRenderer = new LineAndShapeRenderer(true, false);
        } else if ("Line-Shape".equals(string)) {
            lineAndShapeRenderer = new LineAndShapeRenderer(true, true);
        } else {
            throw new ChartException("Unable to locate chart type, " + string);
        }
        lineAndShapeRenderer.setBaseToolTipGenerator((CategoryToolTipGenerator)new StandardCategoryToolTipGenerator());
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot(categoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)lineAndShapeRenderer);
        this.setIntervalMarker(elxCategoryPlot, this.m_CategoryType);
        elxCategoryPlot.setOrientation(PlotOrientation.VERTICAL);
        return elxCategoryPlot;
    }

    private Paint getPaint(Painter painter) {
        String string = painter.getColor();
        String string2 = painter.getPattern();
        Paint paint = null;
        paint = string2 == null || "None".equals(string2) ? StandardColor.lookup(string) : StandardPaint.lookup(string2);
        return paint;
    }

    private ElxCategoryPlot getWaterfall(String string, CategoryDataset categoryDataset, boolean bl, Legend legend) {
        Painter painter;
        CategoryAxis categoryAxis = new CategoryAxis();
        categoryAxis.setCategoryMargin(0.0);
        NumberAxis numberAxis = new NumberAxis();
        WaterfallBarRenderer waterfallBarRenderer = new WaterfallBarRenderer();
        if (bl) {
            waterfallBarRenderer.setBarPainter((BarPainter)new StandardBarPainter());
            int n = legend.getPainterCount();
            for (int i = 0; i < n && i < 4; ++i) {
                painter = legend.getPainter(i);
                if (!painter.isEnabled().booleanValue()) continue;
                Paint paint = this.getPaint(painter);
                if (i == 0) {
                    waterfallBarRenderer.setFirstBarPaint(paint);
                    continue;
                }
                if (i == 1) {
                    waterfallBarRenderer.setPositiveBarPaint(paint);
                    continue;
                }
                if (i == 2) {
                    waterfallBarRenderer.setNegativeBarPaint(paint);
                    continue;
                }
                if (i != 3) continue;
                waterfallBarRenderer.setLastBarPaint(paint);
            }
        }
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER, TextAnchor.CENTER, 0.0);
        waterfallBarRenderer.setBasePositiveItemLabelPosition(itemLabelPosition);
        waterfallBarRenderer.setBaseNegativeItemLabelPosition(itemLabelPosition);
        ElxCategoryPlot elxCategoryPlot = new ElxCategoryPlot(categoryDataset, categoryAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)waterfallBarRenderer);
        elxCategoryPlot.clearRangeMarkers();
        painter = new ValueMarker(0.0);
        painter.setPaint(Color.black);
        elxCategoryPlot.addRangeMarker((Marker)painter, Layer.FOREGROUND);
        elxCategoryPlot.setOrientation(PlotOrientation.VERTICAL);
        return elxCategoryPlot;
    }

    private CategoryDataset getCumulativePercentage(Dataset dataset) {
        CategoryDataset categoryDataset = (CategoryDataset)dataset;
        int n = categoryDataset.getColumnCount();
        int n2 = categoryDataset.getRowCount();
        for (int i = 0; i < n; ++i) {
            Comparable comparable;
            int n3;
            Comparable comparable2 = categoryDataset.getColumnKey(i);
            double d = 0.0;
            for (n3 = 0; n3 < n2; ++n3) {
                comparable = categoryDataset.getRowKey(n3);
                d += categoryDataset.getValue(comparable, comparable2).doubleValue();
            }
            for (n3 = 0; n3 < n2; ++n3) {
                comparable = categoryDataset.getRowKey(n3);
                double d2 = categoryDataset.getValue(comparable, comparable2).doubleValue();
                double d3 = d2 / d * 100.0;
                ((ElxCategoryDataset)categoryDataset).setValue(d3, comparable, comparable2);
            }
        }
        return categoryDataset;
    }
}

