/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.CandlestickRenderer;
import com.elixirtech.chart2.renderer.CategoryRenderer;
import com.elixirtech.chart2.renderer.GanttRenderer;
import com.elixirtech.chart2.renderer.HighLowRenderer;
import com.elixirtech.chart2.renderer.LimnCategoryRenderer;
import com.elixirtech.chart2.renderer.LimnScatterRenderer;
import com.elixirtech.chart2.renderer.MeterRenderer;
import com.elixirtech.chart2.renderer.PieRenderer;
import com.elixirtech.chart2.renderer.PolarRenderer;
import com.elixirtech.chart2.renderer.ThermometerRenderer;
import com.elixirtech.chart2.renderer.WindRenderer;
import com.elixirtech.chart2.renderer.WindRoseRenderer;
import com.elixirtech.chart2.renderer.XYRenderer;
import com.elixirtech.chart2.renderer.XYZRenderer;

public class ChartRenderFactory {
    public static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ChartRenderFactory.class);

    public static AbstractChartRenderer getRenderer(IChart iChart) {
        String string = iChart.getType();
        if (string != null) {
            if (string.startsWith("Pie")) {
                return new PieRenderer(iChart);
            }
            if (string.startsWith("Column")) {
                return new CategoryRenderer(iChart);
            }
            if (string.startsWith("Bar")) {
                return new CategoryRenderer(iChart);
            }
            if (string.startsWith("Bubble")) {
                return new XYZRenderer(iChart);
            }
            if (string.startsWith("Area")) {
                return new CategoryRenderer(iChart);
            }
            if (string.startsWith("Line")) {
                return new CategoryRenderer(iChart);
            }
            if (string.startsWith("WindRose")) {
                return new WindRoseRenderer(iChart);
            }
            if (string.startsWith("Wind")) {
                return new WindRenderer(iChart);
            }
            if (string.startsWith("Waterfall")) {
                return new CategoryRenderer(iChart);
            }
            if (string.startsWith("XY")) {
                return new XYRenderer(iChart);
            }
            if (string.equals("HeatMapXY")) {
                return new XYZRenderer(iChart);
            }
            if (string.startsWith("Stocks-High-Low")) {
                return new HighLowRenderer(iChart);
            }
            if (string.equals("Meter-Thermometer")) {
                return new ThermometerRenderer(iChart);
            }
            if (string.startsWith("Meter")) {
                return new MeterRenderer(iChart);
            }
            if (string.startsWith("Polar")) {
                return new PolarRenderer(iChart);
            }
            if (string.startsWith("Stocks-Candlestick")) {
                return new CandlestickRenderer(iChart);
            }
            if (string.startsWith("3D-Column")) {
                return new LimnCategoryRenderer(iChart);
            }
            if (string.startsWith("3D-Area")) {
                return new LimnCategoryRenderer(iChart);
            }
            if (string.startsWith("3D-Line")) {
                return new LimnCategoryRenderer(iChart);
            }
            if (string.startsWith("3D-Scatter")) {
                return new LimnScatterRenderer(iChart);
            }
            if (string.startsWith("3D-Surface")) {
                return new LimnCategoryRenderer(iChart);
            }
            if (string.startsWith("Gantt")) {
                return new GanttRenderer(iChart);
            }
            m_Log.error((Object)("Unable to locate chart type: " + iChart.getCategory() + ":" + iChart.getType()));
        }
        return null;
    }
}

