/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.LimnPlot;
import com.elixirtech.chart2.model.Category3dType;
import com.elixirtech.chart2.model.Category3dUi;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.limn.Angle3d;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class LimnCategoryRenderer
extends AbstractChartRenderer {
    private Category3dType m_CategoryType;

    public LimnCategoryRenderer(IChart iChart) {
        super(iChart);
        ChartType chartType = iChart.getChartType();
        assert (chartType instanceof Category3dType);
        this.m_CategoryType = (Category3dType)chartType;
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        Category3dUi category3dUi = this.m_CategoryType.getCategory3dUi();
        LimnPlot limnPlot = new LimnPlot((Chart)this.m_Chart, datasetHolder);
        JFreeChart jFreeChart = new JFreeChart((Plot)limnPlot);
        LimnCategoryRenderer.setLegend(jFreeChart, this.m_CategoryType.getLegend(), datasetHolder.getLegend());
        LimnCategoryRenderer.setTitle(jFreeChart, this.m_CategoryType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        limnPlot.setBackgroundPaint(StandardColor.lookup(category3dUi.getPlotBackground(), (Color)null));
        LimnCategoryRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        limnPlot.setCameraAngle(new Angle3d(category3dUi.getCameraX(), category3dUi.getCameraY(), category3dUi.getCameraZ()));
        return jFreeChart;
    }
}

