/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.MeterType;
import com.elixirtech.chart2.model.MeterUi;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.ui.StandardColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.data.Range;
import org.jfree.data.general.ValueDataset;

public class MeterRenderer
extends AbstractChartRenderer {
    private MeterType m_MeterType;
    public static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MeterRenderer.class);

    public MeterRenderer(IChart iChart) {
        super(iChart);
        this.m_MeterType = (MeterType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        MeterUi meterUi = this.m_MeterType.getMeterUi();
        JFreeChart jFreeChart = this.getMeter((ValueDataset)datasetHolder.getDataset(), meterUi);
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        MeterRenderer.setLegend(jFreeChart, this.m_MeterType.getLegend(), datasetHolder.getLegend());
        MeterRenderer.setTitle(jFreeChart, this.m_MeterType.getTitle(), datasetHolder.getTitle());
        MeterRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }

    private JFreeChart getMeter(ValueDataset valueDataset, MeterUi meterUi) {
        Range range;
        String string = this.m_Chart.getType();
        MyMeterPlot myMeterPlot = new MyMeterPlot(valueDataset);
        String string2 = meterUi.getUnit();
        if (string2 == null) {
            string2 = "";
        }
        myMeterPlot.setUnits(string2);
        myMeterPlot.setValuePaint(StandardColor.lookup(meterUi.getValueColor()));
        myMeterPlot.setNeedlePaint(StandardColor.lookup(meterUi.getNeedleColor()));
        myMeterPlot.setDialBackgroundPaint(StandardColor.lookup(meterUi.getPlotBackground()));
        if (string.equals("Meter-Pie-Ending")) {
            myMeterPlot.setDialShape(DialShape.PIE);
        } else if (string.equals("Meter-Full-Circle")) {
            myMeterPlot.setDialShape(DialShape.CIRCLE);
        } else if (string.equals("Meter-Half-Chord")) {
            myMeterPlot.setDialShape(DialShape.CHORD);
        }
        try {
            range = new Range(meterUi.getRangeMin(), meterUi.getRangeMax());
            myMeterPlot.setRange(range);
            Iterator<com.elixirtech.chart2.model.MeterInterval> iterator = meterUi.getIntervalIterator();
            while (iterator.hasNext()) {
                com.elixirtech.chart2.model.MeterInterval meterInterval = iterator.next();
                Range range2 = new Range(meterInterval.getMin(), meterInterval.getMax());
                Color color = meterInterval.getFillColor();
                Color color2 = StandardColor.TRANSPARENT;
                BasicStroke basicStroke = null;
                int n = meterInterval.getLineWidth();
                if (n > 0) {
                    basicStroke = new BasicStroke((float)n / 20.0f);
                    color2 = meterInterval.getLineColor();
                }
                MeterInterval meterInterval2 = new MeterInterval(meterInterval.getName(), range2, (Paint)color2, (Stroke)basicStroke, (Paint)color);
                myMeterPlot.addInterval(meterInterval2);
            }
        }
        catch (RuntimeException runtimeException) {
            m_Log.error((Object)("Range Error: " + runtimeException.toString()), (Throwable)runtimeException);
        }
        range = new JFreeChart(null, null, (Plot)myMeterPlot, false);
        range.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        return range;
    }

    protected static class MyMeterPlot
    extends MeterPlot {
        private int m_NumberOfTicks = 20;

        public MyMeterPlot(ValueDataset valueDataset) {
            super(valueDataset);
        }

        protected void drawTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, double d2) {
            if (this.m_NumberOfTicks > 0) {
                double d3 = (d2 - d) / (double)this.m_NumberOfTicks;
                for (double d4 = d; d4 <= d2; d4 += d3) {
                    this.drawTick(graphics2D, rectangle2D, d4);
                }
            }
        }

        public void setNumberOfTicks(int n) {
            this.m_NumberOfTicks = n;
        }

        public int getNumberOfTicks() {
            return this.m_NumberOfTicks;
        }
    }
}

