/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.Axis;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.Font;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Label;
import com.elixirtech.chart2.model.PolarType;
import com.elixirtech.chart2.model.PolarUi;
import com.elixirtech.chart2.model.Tick;
import com.elixirtech.chart2.renderer.AbstractChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.xy.XYDataset;

public class PolarRenderer
extends AbstractChartRenderer {
    public PolarRenderer(IChart iChart) {
        super(iChart);
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        PolarPlot polarPlot = new PolarPlot();
        polarPlot.setDataset((XYDataset)datasetHolder.getDataset());
        JFreeChart jFreeChart = new JFreeChart((Plot)polarPlot);
        PolarType polarType = (PolarType)((Chart)this.m_Chart).getChartType();
        PolarUi polarUi = polarType.getPolarUi();
        Axis axis = polarUi.getAxis();
        Tick tick = axis.getTick();
        NumberAxis numberAxis = new NumberAxis();
        this.formatTick((org.jfree.chart.axis.Axis)numberAxis, tick);
        this.formatLabel((org.jfree.chart.axis.Axis)numberAxis, axis.getLabel());
        this.formatValueAxis((ValueAxis)numberAxis, (Format)tick.getFormat());
        polarPlot.setAxis((ValueAxis)numberAxis);
        polarPlot.setRenderer((PolarItemRenderer)new DefaultPolarItemRenderer());
        polarPlot.setBackgroundPaint((Paint)StandardColor.lookup(polarUi.getPlotBackground(), (Color)null));
        PolarRenderer.setLegend(jFreeChart, polarType.getLegend(), datasetHolder.getLegend());
        PolarRenderer.setTitle(jFreeChart, polarType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        PolarRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }

    private void formatTick(org.jfree.chart.axis.Axis axis, Tick tick) {
        if (tick.isTickMarkVisible()) {
            Font font;
            if (axis instanceof ValueAxis) {
                this.formatValueAxis((ValueAxis)axis, (Format)tick.getFormat());
            }
            if ((font = tick.getFont()) != null && font.getFontFamily() != null) {
                axis.setTickLabelFont(font.getAWTFont());
                axis.setTickLabelPaint((Paint)StandardColor.lookup(font.getFontColor(), Color.BLACK));
            }
        } else {
            axis.setTickMarksVisible(false);
            axis.setTickLabelsVisible(false);
        }
    }

    private void formatLabel(org.jfree.chart.axis.Axis axis, Label label) {
        if (StringUtil.notEmpty(label.getText())) {
            axis.setLabel(label.getText());
            Font font = label.getFont();
            if (font != null && font.getFontFamily() != null) {
                axis.setLabelFont(font.getAWTFont());
                axis.setLabelPaint((Paint)StandardColor.lookup(font.getFontColor(), Color.BLACK));
            }
        }
    }

    private void formatValueAxis(ValueAxis valueAxis, Format format) {
        if (Formatter.notNone(format)) {
            if (valueAxis instanceof NumberAxis) {
                NumberAxis numberAxis = (NumberAxis)valueAxis;
                NumberFormat numberFormat = Formatter.buildNumberFormatter(format, PolarRenderer.getLocale(this.m_Chart, format));
                numberAxis.setNumberFormatOverride(numberFormat);
            } else if (valueAxis instanceof DateAxis) {
                DateAxis dateAxis = (DateAxis)valueAxis;
                DateFormat dateFormat = (DateFormat)Formatter.buildFormatter(format, PolarRenderer.getLocale(this.m_Chart, format));
                dateAxis.setDateFormatOverride(dateFormat);
            }
        }
    }
}

