/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.WindType;
import com.elixirtech.chart2.model.WindUi;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.WindItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.xy.WindDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class WindRenderer
extends Abstract2DChartRenderer {
    private WindType m_WindType;

    public WindRenderer(IChart iChart) {
        super(iChart);
        this.m_WindType = (WindType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        WindUi windUi = this.m_WindType.getWindUi();
        DateAxis dateAxis = new DateAxis("DateAxis");
        NumberAxis numberAxis = new NumberAxis(null);
        numberAxis.setRange(new Range(-15.0, 15.0));
        XYPlot xYPlot = new XYPlot((XYDataset)((WindDataset)datasetHolder.getDataset()), (ValueAxis)dateAxis, (ValueAxis)numberAxis, (XYItemRenderer)new WR());
        xYPlot.setBackgroundPaint((Paint)StandardColor.lookup(windUi.getPlotBackground(), (Color)null));
        this.setDomainAxis(xYPlot, windUi.getValueAxis());
        JFreeChart jFreeChart = new JFreeChart((Plot)xYPlot);
        WindRenderer.setLegend(jFreeChart, this.m_WindType.getLegend(), datasetHolder.getLegend());
        WindRenderer.setTitle(jFreeChart, this.m_WindType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        WindRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        xYPlot.setDomainGridlinesVisible(windUi.isDomainGridlinesVisible());
        xYPlot.setRangeGridlinesVisible(windUi.isRangeGridlinesVisible());
        return jFreeChart;
    }

    private static class WR
    extends WindItemRenderer {
        private WR() {
        }

        public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
            WindDataset windDataset = (WindDataset)xYDataset;
            Paint paint = this.getItemPaint(n, n2);
            Stroke stroke = this.getItemStroke(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.setStroke(stroke);
            Number number = windDataset.getX(n, n2);
            Number number2 = windDataset.getWindDirection(n, n2);
            Number number3 = windDataset.getWindForce(n, n2);
            double d = Math.toRadians(number2.doubleValue());
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d2 = number.doubleValue();
            double d3 = number3.doubleValue();
            double d4 = number.doubleValue();
            double d5 = 0.0;
            double d6 = valueAxis.valueToJava2D(d4, rectangle2D, rectangleEdge);
            double d7 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge2);
            double d8 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
            double d9 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
            Line2D.Double double_ = new Line2D.Double(d6, d7, d8, d9);
            graphics2D.rotate(d, d6, d7);
            graphics2D.draw(double_);
            graphics2D.rotate(-d, d6, d7);
        }
    }
}

