/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.WindRoseType;
import com.elixirtech.chart2.model.WindRoseUi;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.windrose.WindRoseAxis;
import com.elixirtech.chart2.windrose.WindRoseDataset;
import com.elixirtech.chart2.windrose.WindRosePlot;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Paint;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;

public class WindRoseRenderer
extends Abstract2DChartRenderer {
    private WindRoseType m_WindType;

    public WindRoseRenderer(IChart iChart) {
        super(iChart);
        this.m_WindType = (WindRoseType)iChart.getChartType();
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        WindRoseUi windRoseUi = this.m_WindType.getWindRoseUi();
        WindRoseAxis windRoseAxis = new WindRoseAxis();
        WindRosePlot windRosePlot = new WindRosePlot((WindRoseDataset)datasetHolder.getDataset(), windRoseAxis);
        windRosePlot.setBackgroundPaint(StandardColor.lookup(windRoseUi.getPlotBackground(), (Color)null));
        JFreeChart jFreeChart = new JFreeChart((Plot)windRosePlot);
        WindRoseRenderer.setLegend(jFreeChart, this.m_WindType.getLegend(), datasetHolder.getLegend());
        WindRoseRenderer.setTitle(jFreeChart, this.m_WindType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        WindRoseRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }
}

