/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.chart2.renderer;

import com.elixirtech.chart2.ChartException;
import com.elixirtech.chart2.model.Chart;
import com.elixirtech.chart2.model.ChartType;
import com.elixirtech.chart2.model.Format;
import com.elixirtech.chart2.model.IChart;
import com.elixirtech.chart2.model.Position;
import com.elixirtech.chart2.model.Value;
import com.elixirtech.chart2.model.XYType;
import com.elixirtech.chart2.model.XYUi;
import com.elixirtech.chart2.renderer.Abstract2DChartRenderer;
import com.elixirtech.chart2.renderer.DatasetHolder;
import com.elixirtech.chart2.renderer.Formatter;
import com.elixirtech.chart2.renderer.ItemAnchorUtil;
import com.elixirtech.chart2.renderer.TextAnchorUtil;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.text.NumberFormat;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.AbstractXYItemLabelGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYSplineRenderer;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.TextAnchor;

public class XYRenderer
extends Abstract2DChartRenderer {
    public XYRenderer(IChart iChart) {
        super(iChart);
    }

    @Override
    public JFreeChart getChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        String string = this.m_Chart.getType();
        if (string.startsWith("XY")) {
            return this.getXYChart(object, datasetHolder);
        }
        return null;
    }

    protected ValueAxis[] getXYAxis(XYDataset xYDataset) {
        DateAxis dateAxis = null;
        NumberAxis numberAxis = null;
        if (xYDataset instanceof TimeSeriesCollection) {
            dateAxis = new DateAxis();
            numberAxis = new NumberAxis();
            numberAxis.setAutoRangeIncludesZero(false);
        } else {
            dateAxis = new NumberAxis();
            ((NumberAxis)dateAxis).setAutoRangeIncludesZero(false);
            numberAxis = new NumberAxis();
            numberAxis.setAutoRangeIncludesZero(false);
        }
        ValueAxis[] valueAxisArray = new ValueAxis[]{dateAxis, numberAxis};
        return valueAxisArray;
    }

    protected XYPlot getPlot(Object object, DatasetHolder datasetHolder) throws ChartException {
        XYDataset xYDataset = (XYDataset)datasetHolder.getDataset();
        ValueAxis[] valueAxisArray = this.getXYAxis(xYDataset);
        ValueAxis valueAxis = valueAxisArray[0];
        ValueAxis valueAxis2 = valueAxisArray[1];
        StandardXYItemRenderer standardXYItemRenderer = null;
        String string = this.m_Chart.getType();
        if ("XY-Scattered".equals(string)) {
            standardXYItemRenderer = new StandardXYItemRenderer(1);
            standardXYItemRenderer.setBaseShapesFilled(Boolean.TRUE.booleanValue());
        } else if ("XY-Line".equals(string)) {
            standardXYItemRenderer = new StandardXYItemRenderer(2);
        } else if ("XY-LineShape".equals(string)) {
            standardXYItemRenderer = new StandardXYItemRenderer(3);
        } else if ("XY-CurveLine".equals(string)) {
            standardXYItemRenderer = new XYSplineRenderer();
        } else {
            throw new ChartException("No XY chart type: " + string + " available");
        }
        XYPlot xYPlot = new XYPlot(xYDataset, valueAxis, valueAxis2, (XYItemRenderer)standardXYItemRenderer);
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        XYUi xYUi = ((XYType)this.m_Chart.getChartType()).getXYUi();
        xYPlot.setBackgroundPaint((Paint)StandardColor.lookup(xYUi.getPlotBackground(), (Color)null));
        this.setRangeAxis(xYPlot, xYUi.getYAxis());
        this.setDomainAxis(xYPlot, xYUi.getXAxis());
        XYRenderer.setValue(this, this.m_Chart, xYPlot, xYUi.getValue(), xYUi.getPositivePosition(), xYUi.getNegativePosition());
        xYPlot.setDomainGridlinesVisible(xYUi.isDomainGridlinesVisible());
        xYPlot.setRangeGridlinesVisible(xYUi.isRangeGridlinesVisible());
        return xYPlot;
    }

    protected JFreeChart getXYChart(Object object, DatasetHolder datasetHolder) throws ChartException {
        XYPlot xYPlot = this.getPlot(object, datasetHolder);
        JFreeChart jFreeChart = new JFreeChart((Plot)xYPlot);
        ChartType chartType = ((Chart)this.m_Chart).getChartType();
        XYRenderer.setLegend(jFreeChart, chartType.getLegend(), datasetHolder.getLegend());
        XYRenderer.setTitle(jFreeChart, chartType.getTitle(), datasetHolder.getTitle());
        jFreeChart.setBackgroundPaint((Paint)this.m_Chart.getBackgroundColor());
        XYRenderer.processScript(object, jFreeChart, this.m_Chart.getOnConfigure());
        return jFreeChart;
    }

    protected AbstractXYItemLabelGenerator getLabelGenerator(String string, NumberFormat numberFormat) {
        if (numberFormat != null) {
            return new StandardXYItemLabelGenerator("{2}", numberFormat, numberFormat);
        }
        return new StandardXYItemLabelGenerator();
    }

    public static void setValue(XYRenderer xYRenderer, IChart iChart, XYPlot xYPlot, Value value, Position position, Position position2) {
        String string = iChart.getType();
        if (value == null) {
            return;
        }
        if (!value.isVisible()) {
            return;
        }
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        Format format = (Format)value.getFormat();
        NumberFormat numberFormat = null;
        if (Formatter.notNone(format)) {
            numberFormat = Formatter.buildNumberFormatter(format, XYRenderer.getLocale(iChart, format));
        }
        XYItemLabelGenerator xYItemLabelGenerator = (XYItemLabelGenerator)xYRenderer.getLabelGenerator(string, numberFormat);
        com.elixirtech.chart2.model.Font font = value.getFont();
        if (font != null) {
            Font font2 = font.getAWTFont();
            xYItemRenderer.setBaseItemLabelFont(font2);
            Color color = StandardColor.lookup(font.getFontColor());
            xYItemRenderer.setBaseItemLabelPaint((Paint)color);
        }
        xYItemRenderer.setBaseItemLabelGenerator(xYItemLabelGenerator);
        if (position == null) {
            position = XYRenderer.getPositivePosition();
        }
        xYItemRenderer.setBasePositiveItemLabelPosition(XYRenderer.build(position));
        if (position2 == null) {
            position2 = XYRenderer.getNegativePosition();
        }
        xYItemRenderer.setBaseNegativeItemLabelPosition(XYRenderer.build(position2));
        xYItemRenderer.setBaseItemLabelsVisible(true);
    }

    private static ItemLabelPosition build(Position position) {
        ItemLabelAnchor itemLabelAnchor = ItemAnchorUtil.lookup(position.getPosition());
        TextAnchor textAnchor = TextAnchorUtil.lookup(position.getAnchor());
        TextAnchor textAnchor2 = TextAnchorUtil.lookup(position.getPivot());
        double d = Math.PI * 2 * (double)position.getAngle() / 360.0;
        return new ItemLabelPosition(itemLabelAnchor, textAnchor, textAnchor2, d);
    }

    private static Position getPositivePosition() {
        Position position = new Position();
        position.setPosition("Outside1");
        position.setAnchor("Baseline");
        position.setPivot("Baseline");
        return position;
    }

    private static Position getNegativePosition() {
        Position position = new Position();
        position.setPosition("Outside6");
        position.setAnchor("Baseline");
        position.setPivot("Baseline");
        return position;
    }
}

