/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.ARM$;
import com.elixirtech.data2.DRWrapper;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.ExternalSortReader;
import com.elixirtech.data2.ExternalSortWriter$Desc$;
import com.elixirtech.data2.InMemoryReader;
import com.elixirtech.data2.SortCriteria;
import com.elixirtech.data2.SortReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Comparator;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class ExternalSortWriter {
    private final DataSchema schema;
    private final List criteria;
    private final long maxMemory;
    private final int criteriaLen;
    public final ExternalSortWriter$Desc$ Desc$lzy1;
    private ListBuffer<DRWrapper> buffer;
    private final ListBuffer<File> bufferFiles;
    private long totalLength;
    private final List comparators;

    public ExternalSortWriter(DataSchema schema, List<SortCriteria> criteria, long maxMemory) {
        this.schema = schema;
        this.criteria = criteria;
        this.maxMemory = maxMemory;
        this.Desc$lzy1 = new ExternalSortWriter$Desc$(this);
        this.criteriaLen = criteria.size();
        this.buffer = new ListBuffer();
        this.bufferFiles = new ListBuffer();
        this.totalLength = 0L;
        this.comparators = this.buildComparators();
    }

    public DataSchema schema() {
        return this.schema;
    }

    public List<SortCriteria> criteria() {
        return this.criteria;
    }

    public long maxMemory() {
        return this.maxMemory;
    }

    public ExternalSortWriter(DataSchema s, java.util.List<SortCriteria> c, long m) {
        this(s, (List<SortCriteria>)CollectionConverters$.MODULE$.ListHasAsScala(c).asScala().toList(), m);
    }

    public int criteriaLen() {
        return this.criteriaLen;
    }

    public final ExternalSortWriter$Desc$ Desc() {
        return this.Desc$lzy1;
    }

    public List<Comparator<Object>> comparators() {
        return this.comparators;
    }

    private List<Comparator<Object>> buildComparators() {
        return this.criteria().map((Function1 & Serializable)sc -> {
            DataType dt = this.schema().getColumnType(sc.idx());
            if (sc.asc()) {
                return dt;
            }
            return this.Desc().apply(dt);
        });
    }

    public long byteLength() {
        return this.totalLength;
    }

    public int bufferCount() {
        return this.bufferFiles.size();
    }

    public void add(DataRecord record) {
        DataSchema dataSchema = record.getSchema();
        DataSchema dataSchema2 = this.schema();
        Predef$.MODULE$.require(!(dataSchema != null ? !((Object)dataSchema).equals(dataSchema2) : dataSchema2 != null));
        int length = record.writeLength();
        if ((long)length + this.totalLength > this.maxMemory()) {
            this.sortBuffer();
            this.writeBuffer();
        }
        this.buffer.$plus$eq((Object)new DRWrapper(record, this.getSortItems(record)));
        this.totalLength += (long)length;
    }

    public void sortBuffer() {
        this.buffer = (ListBuffer)this.buffer.sortWith((Function2 & Serializable)(o1, o2) -> this.comparator((DRWrapper)o1, (DRWrapper)o2));
    }

    public boolean comparator(DRWrapper o1, DRWrapper o2) {
        Object[] d1 = o1.sortItems();
        Object[] d2 = o2.sortItems();
        return this.compare(0, this.comparators(), d1, d2) < 0;
    }

    public int compare(int idx, List<Comparator<Object>> cs, Object[] d1, Object[] d2) {
        List<Comparator<Object>> list = cs;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Comparator<Object>> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return 0;
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            Comparator c = (Comparator)colon2.head();
            List tail = list3;
            int n = c.compare(d1[idx], d2[idx]);
            if (0 == n) {
                return this.compare(idx + 1, (List<Comparator<Object>>)tail, d1, d2);
            }
            int x = n;
            return x;
        }
        throw new MatchError(list);
    }

    public Object[] getSortItems(DataRecord record) {
        Object[] data = record.getData();
        Object[] array = new Object[this.criteriaLen()];
        ((List)this.criteria().zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                SortCriteria sc = (SortCriteria)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                array$1[i] = data[sc.idx()];
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        return array;
    }

    public File writeBuffer() {
        File file = File.createTempFile("extsort-", ".dat");
        this.bufferFiles.$plus$eq((Object)file);
        ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
            DataOutputStream dos = (DataOutputStream)arm.manage((Object)com.elixirtech.arch.package$.MODULE$.enrichOutputStream((OutputStream)com.elixirtech.arch.package$.MODULE$.enrichOutputStream((OutputStream)com.elixirtech.arch.package$.MODULE$.enrichFile(file).output()).buffered()).data());
            this.buffer.foreach((Function1)(JProcedure1 & Serializable)rec -> {
                dos.writeByte(82);
                rec.value().write(dos);
            });
            dos.writeByte(88);
        });
        this.buffer.clear();
        this.totalLength = 0L;
        return file;
    }

    public SortReader getReader() {
        if (this.bufferFiles.isEmpty()) {
            this.sortBuffer();
            return new InMemoryReader(this.buffer);
        }
        if (this.totalLength > 0L) {
            this.sortBuffer();
            this.writeBuffer();
        }
        return new ExternalSortReader(this, (List<File>)this.bufferFiles.toList());
    }

    public class Desc
    implements Comparator<Object>,
    Product,
    Serializable {
        private final Comparator comp;
        private final /* synthetic */ ExternalSortWriter $outer;

        public Desc(ExternalSortWriter $outer, Comparator<Object> comp) {
            this.comp = comp;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Desc)) return false;
            if (((Desc)object).com$elixirtech$data2$ExternalSortWriter$Desc$$$outer() != this.$outer) return false;
            Desc desc = (Desc)object;
            Comparator<Object> comparator = this.comp();
            Comparator<Object> comparator2 = desc.comp();
            if (comparator == null) {
                if (comparator2 != null) {
                    return false;
                }
            } else if (!((Object)comparator).equals(comparator2)) return false;
            if (!desc.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Desc;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Desc";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "comp";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Comparator<Object> comp() {
            return this.comp;
        }

        @Override
        public int compare(Object o1, Object o2) {
            return this.comp().compare(o2, o1);
        }

        public Desc copy(Comparator<Object> comp) {
            return new Desc(this.$outer, comp);
        }

        public Comparator<Object> copy$default$1() {
            return this.comp();
        }

        public Comparator<Object> _1() {
            return this.comp();
        }

        public final /* synthetic */ ExternalSortWriter com$elixirtech$data2$ExternalSortWriter$Desc$$$outer() {
            return this.$outer;
        }
    }
}

