/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.PushContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RecordScope
extends ScriptableObject {
    private static final String[] NAMES = new String[]{"substitute"};
    private final DataSchema m_Schema;
    private final Map<String, Integer> m_Names = new HashMap<String, Integer>();
    private Object[] m_Data;
    private List<PropertyChangeListener> m_Listeners;
    private PushContext m_Context;

    public RecordScope(DataSchema dataSchema) {
        this.m_Schema = dataSchema;
        this.defineFunctionProperties(NAMES, RecordScope.class, 2);
        int n = dataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Object object = dataSchema.getColumnName(i);
            if (!StringUtil.notEmpty((String)object)) continue;
            char c = ((String)object).charAt(0);
            if (!Character.isJavaIdentifierStart(c)) {
                object = "_" + (String)object;
            }
            this.m_Names.put((String)object, new Integer(i));
        }
    }

    public void setContext(PushContext pushContext) {
        this.m_Context = pushContext;
    }

    public static Object substitute(Context context, Scriptable scriptable, Object[] objectArray, Function function) {
        if (objectArray.length > 0) {
            return ((RecordScope)scriptable).doSubstitute(String.valueOf(objectArray[0]));
        }
        return null;
    }

    public String doSubstitute(String string) {
        if (this.m_Context != null) {
            return this.m_Context.substitute(string);
        }
        return string;
    }

    public void setData(Object[] objectArray) {
        this.m_Data = objectArray;
        if (this.m_Listeners != null) {
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, "data", null, null);
            this.fire(propertyChangeEvent);
        }
    }

    public Object getData(int n) {
        return this.m_Data[n];
    }

    public Map<String, String> getSubstitutionMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < this.m_Data.length; ++i) {
            String string = this.m_Schema.getColumnName(i);
            DataType dataType = this.m_Schema.getColumnType(i);
            hashMap.put(string, this.m_Schema.format(dataType, this.m_Data[i]));
        }
        return hashMap;
    }

    public String getClassName() {
        return "RecordScope";
    }

    public boolean has(String string, Scriptable scriptable) {
        if (this.m_Names.containsKey(string)) {
            return true;
        }
        return super.has(string, scriptable);
    }

    public Object get(String string, Scriptable scriptable) {
        if (this.m_Data != null) {
            Integer n = this.m_Names.get(string);
            if (n == null) {
                return super.get(string, scriptable);
            }
            Object object = this.m_Data[n];
            if (object instanceof Character) {
                object = String.valueOf(((Character)object).charValue());
            } else if (object instanceof BigDecimal) {
                Context context = Context.getCurrentContext();
                object = context.getWrapFactory().wrap(context, (Scriptable)this, object, null);
            }
            return object;
        }
        return super.get(string, scriptable);
    }

    public void put(String string, Scriptable scriptable, Object object) {
        Object object2 = object;
        if (this.m_Data != null) {
            Integer n = this.m_Names.get(string);
            if (n == null) {
                if (this.m_Listeners != null) {
                    Object object3 = super.get(string, scriptable);
                    if (!this.equals(object3, object2)) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object3, object2);
                        super.put(string, scriptable, object2);
                        this.fire(propertyChangeEvent);
                    }
                } else {
                    super.put(string, scriptable, object2);
                }
            } else {
                int n2 = n;
                if (object2 instanceof NativeJavaObject) {
                    object2 = ((NativeJavaObject)object2).unwrap();
                }
                if (this.m_Listeners != null) {
                    Object object4 = this.m_Data[n2];
                    if (!this.equals(object4, object2)) {
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object4, object2);
                        this.m_Data[n2] = object2;
                        this.fire(propertyChangeEvent);
                    }
                } else {
                    this.m_Data[n2] = object2;
                }
            }
        } else {
            super.put(string, scriptable, object2);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_Listeners == null) {
            this.m_Listeners = new ArrayList<PropertyChangeListener>();
        }
        this.m_Listeners.add(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.m_Listeners != null) {
            this.m_Listeners.remove(propertyChangeListener);
        }
    }

    private void fire(PropertyChangeEvent propertyChangeEvent) {
        Iterator<PropertyChangeListener> iterator = this.m_Listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().propertyChange(propertyChangeEvent);
        }
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }
}

