/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2;

import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.SchemaBuilder;
import com.elixirtech.data2.SchemaItem;
import java.util.List;
import scala.collection.Seq;
import scala.collection.mutable.HashSet;
import scala.jdk.CollectionConverters$;
import scala.sys.package$;

public class UniqueValueListener
implements DataListener2,
IDataSource {
    private final DataListener dl;
    private final String column;
    private int _idx;
    private DataSchema _schema;
    private final HashSet<Object> _set;

    public UniqueValueListener(DataListener dl, String column) {
        this.dl = dl;
        this.column = column;
        this._idx = -1;
        this._schema = new DataSchema();
        this._set = new HashSet();
    }

    @Override
    public void startData(IDataSource src) {
        DataSchema schema = src.getSchema();
        this._idx = schema.getColumnIndex(this.column);
        SchemaBuilder sb = new SchemaBuilder(true);
        if (this._idx >= 0) {
            sb.add(new SchemaItem(schema.getColumnName(this._idx), schema.getColumnType(this._idx), schema.getAttributes(this._idx)));
        }
        this._schema = sb.getSchema();
        this._set.clear();
        this.dl.startData(this);
    }

    @Override
    public void startGroup(DataGroup group) {
    }

    @Override
    public boolean processRecord(DataRecord record) {
        if (this._idx >= 0) {
            Object data = record.getData(this._idx);
            if (this._set.contains(data)) {
                return true;
            }
            this._set.$plus$eq(data);
            return this.dl.processRecord(new DataRecord(this._schema, new Object[]{data}));
        }
        return true;
    }

    @Override
    public void endGroup(DataGroup group) {
    }

    @Override
    public void endData(IDataSource src) {
        this.dl.endData(this);
    }

    @Override
    public <T> T getAdapter(Class<T> cls) {
        return null;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public String getType() {
        return "UniqueValueListener";
    }

    @Override
    public List<Parameter> getParameters() {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)scala.package$.MODULE$.Nil()).asJava();
    }

    @Override
    public DataSchema getSchema() {
        return this._schema;
    }

    @Override
    public void pushTo(PushContext cxt, DataListener dl) {
        throw package$.MODULE$.error("Can't pushTo a UniqueValueListener");
    }
}

