/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.attributes;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.jdom.Element;

public class PrimaryKey
extends DataAttribute {
    public static final String NAME = "PrimaryKey";
    private final int m_Sequence;
    private final String m_ConstraintName;

    public static DataAttribute newPrimaryKey(Element element) {
        int n = 0;
        String string = null;
        try {
            n = Integer.parseInt(element.getAttributeValue("sequence"));
            string = element.getAttributeValue("constraint-name");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new PrimaryKey(n, string);
    }

    public static DataAttribute newPrimaryKey(String string) {
        String[] stringArray = StringUtil.arrayOfSubstrings(string, '|');
        if (stringArray.length != 2) {
            return null;
        }
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String string2 = stringArray[1];
        if ("null".equalsIgnoreCase(string2)) {
            string2 = null;
        }
        return new PrimaryKey(n, string2);
    }

    public PrimaryKey() {
        this(0, null);
    }

    public PrimaryKey(int n) {
        this(n, null);
    }

    public PrimaryKey(int n, String string) {
        super(NAME);
        this.m_Sequence = n;
        this.m_ConstraintName = string;
    }

    @Override
    public Element getElement() {
        Element element = super.getElement();
        element.setAttribute("sequence", String.valueOf(this.m_Sequence));
        if (this.m_ConstraintName != null) {
            element.setAttribute("constraint-name", String.valueOf(this.m_ConstraintName));
        }
        return element;
    }

    @Override
    public String getMemento() {
        String string = super.getMemento();
        return string + this.m_Sequence + "|" + this.m_ConstraintName;
    }

    @Override
    public String getRenderableName() {
        return super.getRenderableName() + "(" + this.m_Sequence + ")";
    }

    @Override
    public String getRenderableValue() {
        return String.valueOf(this.m_Sequence);
    }

    public int getSequence() {
        return this.m_Sequence;
    }

    public String getConstraintName() {
        return this.m_ConstraintName;
    }
}

