/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.data2.datasource.cache;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.DataAttribute;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataGroup;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataListener2;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.Parameter;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.cache.CachedDataSource;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CacheBuilder
implements IDataSource,
DataListener2 {
    private CachedDataSource m_Source;
    private File m_File;
    private DataSchema m_Schema;
    private DataOutputStream m_Output;
    private DataListener m_Listener;
    private boolean m_ListenerStopped;
    private Set<DataGroup> m_SentGroups = new HashSet<DataGroup>();
    private DataType[] m_Types;
    private int m_RecordCount;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CacheBuilder.class);

    public CacheBuilder(CachedDataSource cachedDataSource, File file, PushContext pushContext, DataListener dataListener) {
        this.m_File = file;
        m_Log.info((Object)("Building cache " + this.m_File.getAbsolutePath()));
        this.m_Source = cachedDataSource;
        this.m_Listener = dataListener;
        this.m_Source.getParent().pushTo(pushContext, this);
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IDataSource.class) {
            return clazz.cast(this);
        }
        return this.m_Source.getAdapter(clazz);
    }

    @Override
    public String getName() {
        return this.m_Source.getName();
    }

    @Override
    public String getDescription() {
        return this.m_Source.getDescription();
    }

    @Override
    public String getType() {
        return this.m_Source.getType();
    }

    @Override
    public List<Parameter> getParameters() {
        return this.m_Source.getParameters();
    }

    @Override
    public DataSchema getSchema() {
        return this.m_Schema;
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        throw new IllegalStateException("CacheBuilder.pushTo");
    }

    @Override
    public void startData(IDataSource iDataSource) {
        this.m_RecordCount = 0;
        this.m_Schema = iDataSource.getSchema();
        this.m_Types = new DataType[this.m_Schema.getColumnCount()];
        for (int i = 0; i < this.m_Types.length; ++i) {
            this.m_Types[i] = this.m_Schema.getColumnType(i);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.m_File);
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            this.m_Output = new DataOutputStream(bufferedOutputStream);
            this.writeVersion(this.m_Output);
            this.writeSchema(this.m_Schema);
            this.m_Output.writeChar(77);
            this.m_Output.writeChar(66);
            this.m_Output.writeInt(0);
        }
        catch (IOException iOException) {
            m_Log.error((Object)("Cannot initialize cache " + String.valueOf(iOException)));
        }
    }

    @Override
    public void startGroup(DataGroup dataGroup) {
        if (this.m_Output != null) {
            try {
                int n = dataGroup.getLevel();
                String string = dataGroup.getName();
                this.m_Output.writeChar(77);
                this.m_Output.writeChar(83);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(string);
                this.m_Output.writeInt(byteArrayOutputStream.size());
                this.m_Output.write(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error writing startGroup: " + String.valueOf(iOException)), (Throwable)iOException);
                this.m_Output = null;
            }
        }
        if (!this.m_ListenerStopped) {
            if (this.m_Listener != null) {
                this.m_Listener.startGroup(dataGroup);
            }
            this.m_SentGroups.add(dataGroup);
        }
    }

    @Override
    public boolean processRecord(DataRecord dataRecord) {
        ++this.m_RecordCount;
        if (this.m_Output != null) {
            try {
                this.m_Output.writeChar(77);
                this.m_Output.writeChar(82);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                Object[] objectArray = dataRecord.getData();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.write(byteArrayOutputStream, objectArray[i], this.m_Types[i]);
                }
                this.m_Output.writeInt(byteArrayOutputStream.size());
                this.m_Output.write(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error writing record: " + String.valueOf(iOException)), (Throwable)iOException);
                this.m_Output = null;
            }
        }
        if (this.m_Listener != null && !this.m_ListenerStopped) {
            this.m_ListenerStopped = !this.m_Listener.processRecord(dataRecord);
        }
        return true;
    }

    @Override
    public void endGroup(DataGroup dataGroup) {
        if (this.m_Output != null) {
            int n = dataGroup.getLevel();
            String string = dataGroup.getName();
            try {
                this.m_Output.writeChar(77);
                this.m_Output.writeChar(69);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(n);
                dataOutputStream.writeUTF(string);
                this.m_Output.writeInt(byteArrayOutputStream.size());
                this.m_Output.write(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error writing startGroup: " + String.valueOf(iOException)), (Throwable)iOException);
                this.m_Output = null;
            }
        }
        if (!this.m_ListenerStopped || this.m_SentGroups.contains(dataGroup)) {
            if (this.m_Listener != null) {
                this.m_Listener.endGroup(dataGroup);
            }
            this.m_SentGroups.remove(dataGroup);
        }
    }

    @Override
    public void endData(IDataSource iDataSource) {
        if (this.m_Output != null) {
            try {
                this.m_Output.writeChar(77);
                this.m_Output.writeChar(88);
                this.m_Output.writeInt(0);
                this.m_Output.close();
            }
            catch (IOException iOException) {
                m_Log.error((Object)("Error closing cache file " + String.valueOf(iOException)), (Throwable)iOException);
            }
        }
        if (this.m_Listener != null) {
            this.m_Listener.endData(this);
        }
    }

    public int getRecordCount() {
        return this.m_RecordCount;
    }

    protected void write(OutputStream outputStream, Object object, DataType dataType) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        if (object == null) {
            dataOutputStream.writeChar(78);
        } else {
            dataOutputStream.writeChar(68);
            try {
                switch (dataType.getTypeId()) {
                    case 8: {
                        dataOutputStream.writeLong(((Number)object).longValue());
                        break;
                    }
                    case 6: {
                        dataOutputStream.writeDouble(((Number)object).doubleValue());
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeUTF((String)object);
                        break;
                    }
                    case 3: {
                        dataOutputStream.writeBoolean(((Boolean)object).equals(Boolean.TRUE));
                        break;
                    }
                    default: {
                        dataOutputStream.writeUTF(this.m_Schema.format(dataType, object));
                        break;
                    }
                }
            }
            catch (ClassCastException classCastException) {
                m_Log.error((Object)("Can't convert a " + object.getClass().getName() + " to " + dataType.getTypeName()));
                switch (dataType.getTypeId()) {
                    case 8: {
                        dataOutputStream.writeLong(0L);
                        break;
                    }
                    case 6: {
                        dataOutputStream.writeDouble(0.0);
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeUTF("");
                        break;
                    }
                    case 3: {
                        dataOutputStream.writeBoolean(false);
                        break;
                    }
                    default: {
                        dataOutputStream.writeUTF("");
                    }
                }
            }
        }
    }

    protected void writeVersion(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(3);
        dataOutputStream.writeByte(0);
    }

    protected void writeSchema(DataSchema dataSchema) throws IOException {
        this.m_Output.writeChar(77);
        this.m_Output.writeChar(65);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream.writeBoolean(this.m_Schema.isCaseSensitive());
        dataOutputStream.writeUTF(dataSchema.getDateFormat());
        dataOutputStream.writeUTF(dataSchema.getTimeFormat());
        dataOutputStream.writeUTF(dataSchema.getTimestampFormat());
        int n = dataSchema.getColumnCount();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeByte((byte)dataSchema.getColumnType(i).getTypeId());
            dataOutputStream.writeUTF(dataSchema.getColumnName(i));
            DataAttributes dataAttributes = dataSchema.getAttributes(i);
            List<DataAttribute> list = dataAttributes.getAttributes();
            dataOutputStream.writeInt(list.size());
            for (DataAttribute dataAttribute : list) {
                dataOutputStream.writeUTF(dataAttribute.getMemento());
            }
        }
        this.m_Output.writeInt(byteArrayOutputStream.size());
        this.m_Output.write(byteArrayOutputStream.toByteArray());
    }
}

